/* $Id: ssh_v1_auth_rhosts_client.c,v 1.3 2001/02/11 03:35:17 tls Exp $ */

/*
 * Copyright 1999 RedBack Networks, Incorporated.
 * All rights reserved.
 *        
 * This software is not in the public domain.  It is distributed
 * under the terms of the license in the file LICENSE in the
 * same directory as this file.  If you have received a copy of this
 * software without the LICENSE file (which means that whoever gave
 * you this software violated its license) you may obtain a copy from
 * http://www.panix.com/~tls/LICENSE.txt
 */

/*
 * Copyright (c) 2000, 2001 Andrew Brown, Eric Haszlakiewicz,
 *      and Jason Thorpe.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. The names of the authors may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHORS ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL THE AUTHORS BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING,
 * BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED
 * AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

/*
 * SSHv1 rhosts authentication: client-side routines.
 */

#include "options.h"

#ifdef WITH_AUTH_RHOSTS
#include <sys/types.h>
#include <string.h>
#include <stdlib.h>

#include "sshd.h"
#include "ssh_buffer.h"
#include "ssh_event.h"
#include "ssh_types.h"
#include "ssh_util.h"

#include "crypto/ssh_auth.h"

#include "ssh_v1_messages.h"
#include "ssh_v1_auth_rhosts.h"

int
v1_user_try_auth_rhosts(ssh_context_t *context, struct ssh_buf **bufp,
    size_t size, int msg_type, struct ssh_event *evp)
{
	struct ssh_buf *buf;
	size_t l;

	if (context->client->Verbosity)
		fprintf(stderr,
		    "%s: Doing %s authentication.\r\n",
		    context->client->localhost,
		    auth_name(context->v1_ctx.auth_tries));

	buf = buf_alloc(NULL,
	    4 + (l = strlen(context->pwent.pw_name)));
	buf_put_binstr(buf, context->pwent.pw_name, l);
	EVT_BUILD_SEND(*evp, SSH_V1_CMSG_AUTH_RHOSTS);

	*bufp = buf;

	return (RET_OK);
}
#endif /* #ifdef WITH_AUTH_RHOSTS */
