/* $Id: ssh_v2_dispatch.c,v 1.4 2001/02/11 03:35:20 tls Exp $ */

/*
 * Copyright (c) 2000 Eric Haszlakiewicz.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING,
 * BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED
 * AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

int dispatch_v2_message(ssh_context_t *ssh_context, struct ssh_buf *msg,
                        int size)
{
	int msg_type;
	char cookie[16];

	if (buf_get_uint8(msg, &msg_type) != 0)
	{
		XX send disconnect

		SSH_ERROR("buf_get_uint8 for msg_type failed\n");
		return(1);
	}

	send_event = 0;

	if (msg_type <= SSH_V2_MSG_MAX_TRANSPORT)
	{
		switch(msg_type)
		{
		case SSH_V2_MSG_DISCONNECT:
			XX send info from disconnect packet along to event code
			XX perhaps we should send the event here instead of returning.

			/* Shutdown receives from remote end */
			shutdown(ssh_context->s, SHUT_RD);

			/* Set flag to exit as soon as we send the event */
			ssh_context->recv_exit_flag = 1;

			return(SSH_EVENT_DISCONNECT);	/* Tell caller to send event. */
			break;
		case SSH_V2_MSG_UNIMPLEMENTED:

			break;
		case SSH_V2_MSG_DEBUG:
			SSH_DLOG(3, ("DEBUG packet received\n"));
			XX filter the debug data.
			SSH_DLOG(3, ("%s\n", buf_data(clr_buf)));
		/* FALLTHROUGH */
		case SSH_V2_MSG_IGNORE:
			if (buf_get_skip(msg, size) != 0)
			{
				SSH_ERROR("buf_get_skip(%d) failed", size);
				return(1);
			}
			break;
		case SSH_V2_SERVICE_REQUEST:
			if (ssh_context->running_as_server == NO)
			{
				SSH_ERROR("Inappropriate SERVICE_REQUEST message\n");
				return(1);
			}

			XX initiate state change.
			SSH_V2_STATE_INIT --("ssh-userauth")-->SSH_V2_STATE_AUTH
			SSH_V2_STATE_AUTH --("ssh-connection")-->SSH_V2_STATE_RUN
			break;
		case SSH_V2_SERVICE_ACCEPT:
			if (ssh_context->running_as_server == YES)
			{
				SSH_ERROR("Inappropriate SERVICE_ACCEPT message\n);
				return(1);
			}

			break;

		default:
			/* Handle transport layer specific messages */
			if (msg_type < SSH_V2_ALGORITHM_MIN)
			{
				SSH_DLOG(1, ("Unknown message number: %d\n", msg_type);
			} else {
				XX this can do things like renegotiate keys.
				XX Note that we can keep on getting normal data
				XX during key reexchange
				return(ssh_context->ssh_transport_context->
				       dispatch_msg(ssh_context, msg, size));
			}
			XX send UNIMPLEMENTED
		}
	}
	else if (msg_type <= SSH_V2_MSG_MAX_USERAUTH)
	{
		if (ssh_context->v2_ctx.state != SSH_V2_STATE_AUTH)
		{
			send unimplemented?  send disconnect?
		}

		switch(msg_type)
		{
			case ...:
			default:
				XX send unimplemented
		}
	}
	else if (msg_type <= SSH_V2_MSG_MAX_CONNECT)
	{
		if (ssh_context->v2_ctx.state != SSH_V2_STATE_RUN)
		{
			send unimplemented?  send disconnect?
		}

		switch(msg_type)
		{
			case ...:
			default:
				XX send unimplemented
		}
	}
	else
	{
		XX send unimplemeted
	}

}
