/* $Id: sshd.h,v 1.106 2001/02/10 23:16:34 tls Exp $ */

/*
 * Copyright 1999 RedBack Networks, Incorporated.
 * All rights reserved.
 *
 * This software is not in the public domain.  It is distributed 
 * under the terms of the license in the file LICENSE in the
 * same directory as this file.  If you have received a copy of this
 * software without the LICENSE file (which means that whoever gave
 * you this software violated its license) you may obtain a copy from
 * http://www.panix.com/~tls/LICENSE.txt
 */


#ifndef _SSHD_H
#define _SSHD_H

#define YES 1
#define NO  0
#define ASK 2
typedef int bool;

#ifdef BSD		/* XXX! */
#include <sys/ttycom.h>
#else
#include <sys/ioctl.h>
#endif

#include <sys/types.h>
#include <sys/socket.h>
#include <time.h>
#include <sys/time.h>

#include <stdio.h>

#define alloc_func	z_alloc_func
#define free_func	z_free_func
#include <zlib.h>
#undef alloc_func
#undef free_func

struct ssh_context;
typedef struct ssh_context ssh_context_t;
struct ssh_version;

#include "options.h"
#include "ssh_defines.h"

#include "ssh_channel.h"
#include "ssh_crypto.h"
#include "ssh_logging.h"
#include "ssh_transport.h"
#include "ssh_sys.h"
#include "ssh_event.h"

struct ssh_cipher;

/* -------------------------------------- */

typedef int flag;
struct sshd_options {
	const char *hostkey;	/* Filename of host key. */
	flag keepalive;
	const char *address;	/* Address to listen on. */
	const char *port;	/* Port to listen on. */
	const char *pidfile;

	int v1_compat_mode;
};

/* ------- */

/* protocol_version */
enum {
	SSH_V1 = 0,
	SSH_V2
};

/* state */
#define SSH_STATE_NONE	0
enum e_ssh_v2_state {
	SSH_V2_STATE_INIT = 1,
	SSH_V2_STATE_USERAUTH,
	SSH_V2_STATE_RUN
};
enum e_ssh_v1_state {
	SSH_V1_STATE_GETUSER = 1,
	SSH_V1_STATE_AUTHUSER,
	SSH_V1_STATE_PREPOPS,
	SSH_V1_STATE_IACTIVE,
	SSH_V1_STATE_EXITING
};

struct ssh_buf;

/* ------- */
struct ssh_v1_context {

	int state;
	int go_to_exit;
	int auth_tries;				/* Number of authentication tries */
#define SSH_V1_MAX_AUTH_TRIES	8

	ssh_RSA *serverkey;
	ssh_RSA *hostkey;
	ssh_RSA *userkey;
	void *authagent_session;

	int readsize;		/* Size we should read from primary FD. */

	struct ssh_buf *read_buf;	/* Input from the network socket. */

	u_int8_t cookie[8];	/* Cookie used during initial negotiations. */
	u_int8_t session_id[16];
	u_int8_t session_key[SSH_V1_SESSION_KEY_SIZE];

	int child_gone;

	/*
	 * Variables for the primary channel exit dance.
	 * When the shell/command exits we don't know which thread will
	 * find out first.
	 * If the sendThread finds out first it gets on EOF on read,
	 *  then closes the fd, sets primary_eof, checks if we have the
	 *  exitstatus yet and since we don't just continues.
	 *  Then the recvThread finds out through a SIGCHLD signal, grabs
	 *  the exitstatus, send an event to the sendThread.
	 *  Then, the sendThread receives the exitstatus event, checks
	 *  if it got an eof yet and since it did sends the EXITSTATUS msg.
	 * If the recvThread finds out first then the sendThread will
	 *  get the event before the EOF so it won't send the msg there.
	 *  Instead when it does get the EOF the check for exitstatus will
	 *  be true and it will send the msg there and set primary_eof
 	 *
	 * Finally, after the EXITSTATUS message is sent and primary_eof is set
	 *  the main send thread loop checks if for open channels.  If all
	 *  channels are closed it exits.
	 */
	int primary_eof;
	int have_exitstat;
	struct ssh_buf *exitstatus;

	int sent_exitstat;
	int have_other_channels;
};

struct ssh_v2_context
{
	int state;

	char cookie[16];

	int *kex_algo;             // Key exchange algorithms
	int cur_kex_algo;
	int *shk_algo;             // Server host key.
	int cur_shk_algo;
	int *encr_algo_c2s;  
	int cur_encr_algo_c2s;
	int *encr_algo_s2c;
	int cur_encr_algo_s2c;
	int *mac_algo_c2s;
	int cur_mac_algo_c2s;
	int *mac_algo_s2c;
	int cur_mac_algo_s2c;
	int *comp_algo_c2s;
	int cur_comp_algo_c2s;
	int *comp_algo_s2c;
	int cur_comp_algo_s2c;
	int *lang_c2s;
	int cur_lang_c2s;
	int *lang_s2c;
	int cur_lang_s2c;
	
};

struct sshd_listen_socket {
	struct sshd_listen_socket *next;
	int sock;
};

struct ssh_context {
	bool running_as_server;
	int protocol_version;
	int transport_layer;
	int thread_id;

	struct sshd_options opts;
	struct ssh_client_options *client;

	/* Server only. */
	struct sshd_listen_socket *listen_sockets;
	int listen_socket_max;

	struct sockaddr_storage saddr;	/* address of connecting party */

	ssh_sys_eventq eventq;

	const char *disconnect_msg;

	struct ssh_v1_context v1_ctx;
	struct ssh_v2_context v2_ctx;

	struct channel_info channels[MAX_CHANNEL];

	u_int32_t supported_ciphers;
	u_int32_t supported_auths;

	struct ssh_transport transport_ctx;
	struct ssh_cipher *cipher;	/* type, enc/dec functions, key data */

	struct ssh_password pwent;
	u_int8_t *username;

	int usepty;
	u_int8_t *term;
	u_int8_t *modes;
	size_t msize;
	struct winsize win;

	int child_pid;	/* XXX this is likely version specific. */

	int send_pid;	/* pid of send thread */
	int recv_pid;	/* pid of recv thread */

	ssh_fdinfo_t fdi[SSH_MAX_FD];
	int nfds;
};

#define SSH_UNKNOWN   0x00000000
#define SSH_FRESSH    0x00000001
#define SSH_FSECURE   0x00000002
#define SSH_TTSSH     0x00000003
#define SSH_OPENSSH   0x00000004

struct ssh_version {
    int v_major, v_minor;
    char v_vendor[24]; /* ought to be enough... */
    int v_flags;
};

/* sshd_main.c functions: */
void doquit(int);
int read_conffile(char *);
int OpenListenSocket(ssh_context_t *);
void set_defaults(void);

void doSSH_client(ssh_context_t *);

#endif /* _SSHD_H */
