/* $Id: ssh_v2tls_transport.c,v 1.3 2001/02/11 03:35:33 tls Exp $ */

/*
 * Copyright (c) 2001 Eric Haszlakiewicz.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING,
 * BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED
 * AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */
#include "sshd.h"

static int v2tls_read_packet(ssh_context_t *, struct ssh_buf *);
static int v2tls_xmit_data(ssh_context_t *, u_int8_t, const u_int8_t *, size_t);
static int v2tls_xmit_packet(ssh_context_t *, unsigned char,
                             const struct ssh_buf *);


int v2tls_init_transport(struct ssh_transport *xport, int isserver)
{
	memset(xport, 0, sizeof(*xport));

	xport->dispatch_packet = v2tls_dispatch_transport;
	xport->read_packet = v2tls_read_packet;
	xport->xmit_data = v2tls_xmit_data;
	xport->xmit_packet = v2tls_xmit_data;

	xport->send_buf = buf_alloc(NULL, 2048);
	xport->clr_buf = buf_alloc(NULL, 2048);
	xport->compress_buf = buf_alloc(NULL, 2048);
}

/*
 * Reads from the socket into buf.
 *
 * Returns:
 *     -1 on error
 *     >0 Enough data to form a complete packet.
 *          Returns size of packet.
 *     0  Not enough data yet.
 */
static int v2tls_read_packet(ssh_context_t *context, struct ssh_buf *buf)
{
	int amt_to_read;
	int payload_len;
	int read_len;
	int dlen;

	dlen = INT_MAX;

	/*
	 * Note: buf might have data in it from last time through
	 *   but the payload should have been used up already.
	 */

	amt_to_read = sizeof(u_int32_t) - buf_len(buf);
	while (amt_to_read > 0)
	{
		read_len = buf_fillbuf(SSL_read, buf, context->s, amt_to_read);
		if (read_len < amt_to_read)
		{
			if (read_len < 0)
			{
				if (errno != EINTR)
					return(-1);
				continue;
			}
			if (read_len == 0) {
				SSH_DLOG(4, ("EOF\n"));
				errno = EPIPE;
				return(-1);
			}
		}
		amt_to_read -= read_len;
	}

	buf_get_int32(buf, &payload_len);
	buf_trim(buf, -1);		/* Move rest of packet to start of buf */

	amt_to_read = payload_len - buf_len(buf);

	while (amt_to_read > 0)
	{

		/* If we're here then we've already retrieved the length */
		read_len = buf_fillbuf(SSL_read, buf, context->s, amt_to_read);
		if (read_len < 0 && errno != EAGAIN)
			return(-1);
		if (read_len == 0) {
			SSH_DLOG(4, ("EOF\n"));
			errno = EPIPE;
			return(-1);
		}
		amt_to_read -= read_len;

		SSH_DLOG(4, ("Read data length: %d\n", read_len));
		SSH_DLOG(4, ("Total length: %d\n", buf_len(buf)));

	}

	/* Got enough data, let's return */
	return(payload_len);
}

static int v2tls_xmit_data(ssh_context_t *context,
                           u_int8_t ptype, const u_int8_t *rawbuf, size_t len)
{
	FUNC_DECL(v2tls_xmit_data);

	SSH_ERROR("Unimplemented");
	return(RET_FATAL);
}
static int v2tls_xmit_packet(ssh_context_t *context, u_int8_t ptype,
                             const struct ssh_buf *buf)
{
	FUNC_DECL(v2tls_xmit_packet);

	SSH_ERROR("Unimplemented");
	return(RET_FATAL);
}

static int v2tls_dipatch_packet(ssh_context_t *context, struct ssh_buf *msg,
                                size_t size, int msg_type)
{
	FUNC_DECL(v2tls_dispatch_packet);

	SSH_ERROR("Unimplemented");
	return(RET_FATAL);
}
