/* $Id: ssh_3des.h,v 1.6 2000/10/31 00:52:12 thorpej Exp $ */

/*
 * Copyright 1999 RedBack Networks, Incorporated.
 * All rights reserved.
 *
 * This software is not in the public domain.  It is distributed 
 * under the terms of the license in the file LICENSE in the
 * same directory as this file.  If you have received a copy of this
 * software without the LICENSE file (which means that whoever gave
 * you this software violated its license) you may obtain a copy from
 * http://www.panix.com/~tls/LICENSE.txt
 */


#ifndef _SSH_3DES_H
#define _SSH_3DES_H

#include "openssl/des.h"
#include "openssl/hmac.h"

#include "ssh_defines.h"

struct ssh_cipher;

typedef struct {
	des_key_schedule des_ks[3];
	des_cblock	 des_ivec[6];	/* Two directions, same key! */
} ssh_3des_t;

typedef struct {
	des_key_schedule des_ks[6];
	des_cblock	 des_ivec[2];
	u_int8_t	 mac_key[2][16];
} ssh_des3_t;

void ssh_3des_attach(struct ssh_cipher *);
ssh_3des_t *ssh_3des_initialize(u_int8_t *, int, int);
void ssh_3des_destroy(ssh_3des_t *);

void ssh_des3_attach(struct ssh_cipher *);
ssh_des3_t *ssh_des3_initialize(u_int8_t *, int, int);
void ssh_des3_destroy(ssh_des3_t *);

void ssh_3des_encrypt(u_int8_t *, u_int8_t *, int, ssh_3des_t *);
void ssh_3des_decrypt(u_int8_t *, u_int8_t *, int, ssh_3des_t *);

void ssh_des3_encrypt(u_int8_t *, u_int8_t *, int, ssh_des3_t *);
void ssh_des3_decrypt(u_int8_t *, u_int8_t *, int, ssh_des3_t *);
u_int8_t * ssh_des3_mac_generate(u_int8_t *, ssh_des3_t *, int);
int ssh_des3_mac_validate(u_int8_t *, u_int8_t *, ssh_des3_t *, int, int);

#endif /* _SSH_3DES_H */
