/* $Id: ssh_blowfish.h,v 1.3 2000/10/31 00:52:13 thorpej Exp $ */

/*
 * Copyright 1999 RedBack Networks, Incorporated.
 * All rights reserved.
 *
 * This software is not in the public domain.  It is distributed 
 * under the terms of the license in the file LICENSE in the
 * same directory as this file.  If you have received a copy of this
 * software without the LICENSE file (which means that whoever gave
 * you this software violated its license) you may obtain a copy from
 * http://www.panix.com/~tls/LICENSE.txt
 */


#ifndef _SSH_BLOWFISH_H
#define _SSH_BLOWFISH_H

#include "openssl/blowfish.h"
#include "openssl/hmac.h"
#include <sys/types.h>

struct ssh_cipher;

typedef u_int8_t	bf_block[8];

typedef struct {
	BF_KEY		bf_ks;
	bf_block	bf_iv[2];
} ssh_blowfish_t;

typedef struct {
	BF_KEY		bf_ks[2];
	u_int8_t	mac_key[2][16];
	bf_block	bf_iv[2];
} ssh_fishblow_t;

void ssh_blowfish_attach(struct ssh_cipher *);
ssh_blowfish_t *ssh_blowfish_initialize(u_int8_t *, int, int);
void ssh_blowfish_destroy(ssh_blowfish_t *);

void ssh_fishblow_attach(struct ssh_cipher *);
ssh_fishblow_t *ssh_fishblow_initialize(u_int8_t *, int, int);
void ssh_fishblow_destroy(ssh_fishblow_t *);

void ssh_blowfish_encrypt(u_int8_t *, u_int8_t *, int, ssh_blowfish_t *);
void ssh_blowfish_decrypt(u_int8_t *, u_int8_t *, int, ssh_blowfish_t *);

void ssh_fishblow_encrypt(u_int8_t *, u_int8_t *, int, ssh_fishblow_t *);
void ssh_fishblow_decrypt(u_int8_t *, u_int8_t *, int, ssh_fishblow_t *);

u_int8_t * ssh_fishblow_mac_generate(u_int8_t *, ssh_fishblow_t *, int);
int ssh_fishblow_mac_validate(u_int8_t *, u_int8_t *, ssh_fishblow_t *, int, int);

#endif /* _SSH_BLOWFISH_H */
