/* $Id: ssh_cipher.h,v 1.9 2001/02/06 19:41:59 andrew Exp $ */

/*
 * Copyright 1999 RedBack Networks, Incorporated.
 * All rights reserved.
 *
 * This software is not in the public domain.  It is distributed 
 * under the terms of the license in the file LICENSE in the
 * same directory as this file.  If you have received a copy of this
 * software without the LICENSE file (which means that whoever gave
 * you this software violated its license) you may obtain a copy from
 * http://www.panix.com/~tls/LICENSE.txt
 */


#ifndef _SSH_CIPHER_H
#define _SSH_CIPHER_H

#include "sshd.h"

#define SSH_CIPHER_NONE		0
#define SSH_CIPHER_IDEA		1
#define SSH_CIPHER_DES		2
#define SSH_CIPHER_3DES		3
#define SSH_CIPHER_RC4		5
#define SSH_CIPHER_BLOWFISH	6
#define SSH_CIPHER_FISHBLOW	29	/* Normal blowfish, an extension */
#define SSH_CIPHER_DES3		30	/* Outer triple DES, an extension */

/* Default cipher to use for keyfiles. */
#define	SSH_DEFAULT_KEYFILE_CIPHER	SSH_CIPHER_BLOWFISH

/* XXX these probably don't belong in this file */
#define SSH_MAC_OK		1
#define SSH_MAC_BAD		0

#define	SSH_ROLE_CLIENT		0
#define	SSH_ROLE_SERVER		1
#define	SSH_ROLE_NEITHER	2	/* ...when not a session key */

typedef struct ssh_cipher {
	int type;
	void * (*initialize) (void *, int, int);
			/* takes session key, key length in bytes,
			   and ROLE_CLIENT or ROLE_SERVER, returns
			   allocated key_data */
	void (*encrypt) (u_int8_t *, u_int8_t *, int, void *);
			/* clear, enc, length, key_data */
	void (*decrypt) (u_int8_t *, u_int8_t *, int, void *);
			/* enc, clear, length, key_data */
	void (*destroy)(void *);
	void *key_data;
	int block_size;

	/* note MAC length assumed to be >= length on wire! */
	u_int8_t * (*mac_generate) (u_int8_t *, void *, int);
				   /* clear, key_data, len */
	int	(*mac_validate)	(u_int8_t *, u_int8_t *, void *, int, int);
				/* clear, mac, key_data, len, maclen */
			   
} ssh_cipher_t;

/* Bitmask of supported ciphers. */
void set_supported_ciphers(int *);
int cipher_supported(ssh_context_t *, int);

/* Cipher number->name */
const char *cipher_name(int);
/* Cipher name->number */
int cipher_number(const char *);

#define	cipher_key_data(c)	(c)->key_data
#define	cipher_block_size(c)	(c)->block_size

void *cipher_initialize_passphrase(struct ssh_cipher *, const char *, int);

#define	cipher_initialize(c, k, kl, r)					\
	((c)->key_data = (*(c)->initialize)((k), (kl), (r)))
#define	cipher_encrypt(c, cl, en, l)					\
	(*(c)->encrypt)((cl), (en), (l), (c)->key_data)
#define	cipher_decrypt(c, en, cl, l)					\
	(*(c)->decrypt)((en), (cl), (l), (c)->key_data)
#define	cipher_destroy(c)						\
	(*(c)->destroy)((c)->key_data)

#define	cipher_mac_generate(c, cl, l)					\
	(*(c)->mac_generate)((cl), (c)->key_data, (l))
#define	cipher_mac_validate(c, cl, m, l, ml)				\
	(*(c)->mac_validate)((cl), (m), (c)->key_data, (l), (ml))

int set_cipher_type(struct ssh_cipher *, int);

#endif /* _SSH_CIPHER_H */
