/* $Id: ssh_rsakeys.h,v 1.4 2001/02/11 00:09:16 tls Exp $ */

/*
 * Copyright 1999 RedBack Networks, Incorporated.
 * All rights reserved.
 *
 * This software is not in the public domain.  It is distributed 
 * under the terms of the license in the file LICENSE in the
 * same directory as this file.  If you have received a copy of this
 * software without the LICENSE file (which means that whoever gave
 * you this software violated its license) you may obtain a copy from
 * http://www.panix.com/~tls/LICENSE.txt
 */


#ifndef _SSH_RSAKEYS_H
#define _SSH_RSAKEYS_H

/* Note: this is _NOT_ the format of these data on the wire! */
typedef struct ssh_mpint {
	u_int16_t bits;		/* host byte order. */
	u_int8_t *data;
} ssh_mpint_t;

#include "sshd.h"

void regen_serverkey(void);
int init_serverkey(void);
int read_hostkey(void);
int decrypt_session_key(ssh_context_t *, struct ssh_mpint *);
int encrypt_session_key(ssh_context_t *, struct ssh_mpint *);

#endif /* _SSH_RSAKEYS_H */
