/*	$Id: ssh_authagent.h,v 1.5 2001/02/11 03:35:09 tls Exp $	*/

/*
 * Copyright (c) 2001 Jason R. Thorpe.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING,
 * BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED
 * AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

#ifndef __ssh_authagent_h
#define	__ssh_authagent_h

struct authagent_state {
	struct ssh_buf buf;	/* buffer holding identities */
	u_int32_t count;	/* number of identities left in buffer */
	int sock;		/* for agent communication */
};

/*
 * SSHv1 Authentication Agent messages.
 */
#define	SSH_AGENT_V1_RSA_ID_REQUEST		1
#define	SSH_AGENT_V1_RSA_ID_REPLY		2
#define	SSH_AGENT_V1_RSA_CHALLENGE		3
#define	SSH_AGENT_V1_RSA_RESPONSE		4
#define	SSH_AGENT_V1_FAILURE			5
#define	SSH_AGENT_V1_SUCCESS			6
#define	SSH_AGENT_V1_ADD_RSA_ID			7
#define	SSH_AGENT_V1_REMOVE_RSA_ID		8
#define	SSH_AGENT_V1_REMOVE_ALL_RSA_ID		9

int	ssh_authagent_opensock(void);
void	ssh_authagent_closesock(int);

int	ssh_authagent_ispresent(void);

void	*ssh_authagent_opensession(ssh_context_t *);
void	ssh_authagent_closesession(ssh_context_t *, void *);

int	ssh_authagent_request(int, struct ssh_buf *, struct ssh_buf *);

int	ssh_authagent_v1_getcount(ssh_context_t *, void *);
int	ssh_authagent_v1_getkey(ssh_context_t *, void *, ssh_RSA **, char **);

int	ssh_authagent_v1_rsachallenge(ssh_context_t *, void *,
	    u_int8_t *, ssh_RSA *, ssh_BIGNUM *, u_int8_t *);

#endif /* __ssh_authagent_h */
