/* $Id: ssh_channel.h,v 1.3 2001/02/11 03:35:11 tls Exp $ */

/*
 * Copyright (c) 2000 Eric Haszlakiewicz.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING,
 * BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED
 * AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

#ifndef __ssh_channel_h
#define __ssh_channel_h

#define SSH_MAX_FD	32
enum ssh_fd_types {
	SSH_FD_STDDATA,
	SSH_FD_STDINDATA,
	SSH_FD_CHANNEL_DATA,
	SSH_FD_FORWARDED_PORT,
	SSH_FD_X11,
};

enum ssh_channel_types {
	SSH_CHANNEL_SESSION,
	SSH_CHANNEL_X11,
	SSH_CHANNEL_AGENT,
	SSH_CHANNEL_AGENT1,
};

struct channel_info {
	int used;
	int channel_id;
	int remote_id;

	int fd_normal;
	int fd_ext_stderr;

	int is_closing;
	int window_size;

	int max_packet_size;
};

struct ssh_fdinfo {
	int fd;
	int fd_type;		/* Type of data on this fd */
	int header_size;	/* Offset into xmitbuf that readbuf points to */
	int max_read_size;	/* Maximum we can read into readbuf */
						/* (derived from channel max_packet size */
	char *xmitbuf;		/* What gets handed to xmit_packet */
	char *readbuf;		/* Where within xmitbuf new data is read into */
	                    /* This can be offset to allow space for packet type */
	struct channel_info *p_chan;
};
typedef struct ssh_fdinfo ssh_fdinfo_t;

#define MAX_CHANNEL 4

#define find_channel(c,i) (i > MAX_CHANNEL) ? NULL : (&(c)->channels[i])

void channel_init(ssh_context_t *);
int init_fdi(ssh_context_t *, ssh_fdinfo_t *, int, int, int, u_int8_t);
int create_channel(ssh_context_t *, int, int, int, int);
int chan_attach_fd(ssh_context_t *, int, int, int);
void cleanup_channels(ssh_context_t *);

#endif
