/* $Id: ssh_defines.h,v 1.16 2001/02/11 03:35:11 tls Exp $ */

/*
 * Copyright (c) 2000, 2001 Eric Haszlakiewicz, Thor Lancelot Simon,
 * 	and Jason R. Thorpe.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. The names of the authors may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHORS ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL THE AUTHORS BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING,
 * BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED
 * AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

#ifndef __ssh_defines_h
#define __ssh_defines_h

/* Version: */
#define V1_PROTO_MAJOR	1
#define V1_PROTO_MINOR	5
#define V2_PROTO_MAJOR  2
#define V2_PROTO_MINOR  0
#define V2_PROTO_MINOR_COMPAT  99	/* Turns a major version 1 into 2 */

#define SSHD_REV	"FreSSH.0.8"

/* Size of stuff: (in bytes) */
#define SSH_V1_COOKIE_SIZE		8
#define SSH_V1_SESSION_KEY_SIZE	32

/* Default values for some options. */
#define SSHD_PORT		"22"
#define	SSHD_SERVICE		"ssh"

#define SSHD_REGENCONNS		16384
#define SSHD_REGENINTERVAL	1200
#define SSHD_SERVERKEYBITS	768

/* Minimum size buffer to use for reads. */
#define SSH_MIN_READSIZE	8192
#define SSH_MAX_READSIZE	(16 * 1024)

#endif
