/* $Id: ssh_main.h,v 1.7 2001/02/11 03:35:13 tls Exp $ */

/*
 * Copyright (c) 2000 Andrew Brown.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING,
 * BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED
 * AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

#ifndef _SSH_MAIN_H
#define _SSH_MAIN_H

#define def_ssh_ForwardAgent			1
#define def_ssh_ForwardX11				1
#define def_ssh_RhostsAuthentication	1
#define def_ssh_RhostsRSAAuthentication	1
#define def_ssh_RSAAuthentication		1
#define def_ssh_TISAuthentication		0
#define def_ssh_PasswordAuthentication	1
#define def_ssh_FallBackToRsh			1
#define def_ssh_UseRsh					0
#define def_ssh_BatchMode				0
#define def_ssh_StrictHostKeyChecking	2
#define def_ssh_IdentityFile			"~/" _PATH_SSH_CLIENT_PRIVKEY
#define def_ssh_Port					SSHD_PORT
#define def_ssh_Cipher					SSH_CIPHER_3DES
#define def_ssh_EscapeChar				'~'

#define def_ssh_CompressionLevel		6
#define def_ssh_GlobalKnownHostsFile	"/etc/ssh_known_hosts"
#define def_ssh_UserKnownHostsFile		"~/" _PATH_SSH_USER_DIR "/known_hosts"
#define def_ssh_NumberOfPasswordPrompts	1
#define def_ssh_PasswordPromptLogin		1
#define def_ssh_PasswordPromptHost		1

#endif /* _SSH_MAIN_H */
