/* $Id: ssh_parse.h,v 1.14 2001/02/11 03:35:14 tls Exp $ */

/*
 * Copyright 1999 RedBack Networks, Incorporated.
 * All rights reserved.
 *
 * This software is not in the public domain.  It is distributed 
 * under the terms of the license in the file LICENSE in the
 * same directory as this file.  If you have received a copy of this
 * software without the LICENSE file (which means that whoever gave
 * you this software violated its license) you may obtain a copy from
 * http://www.panix.com/~tls/LICENSE.txt
 */

/*
 * Copyright (c) 2000 Jason R. Thorpe.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING,
 * BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED
 * AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */


#ifndef _SSH_PARSE_H
#define _SSH_PARSE_H
/*
 * Various functions to parse data.
 */
#include "ssh_crypto.h"

/* Type of keyfile to generate in encode_keyfile */
#define FRESSH_PUB_KEYFILE	1
#define FRESSH_PRIV_KEYFILE	2
#define FSECURE_PUB_KEYFILE	FRESSH_PUB_KEYFILE
#define FSECURE_PRIV_KEYFILE	3

/* Return values from decode_keyfile() */
#define	DECODE_KEYFILE_OK		0 /* decode was successful */
#define	DECODE_KEYFILE_PASSPHRASE	1 /* passphrase needed */
#define	DECODE_KEYFILE_FAILED		2 /* keyfile corrupted, other error */

/* Data parsing functions: */
int decode_keyfile(ssh_context_t *, char *, int, char *, int, ssh_RSA **,
	char **, int *);
int encode_keyfile(ssh_context_t *, int, char **, char *, int, ssh_RSA *,
	char *);

int encode_public_keyfile(ssh_context_t *, char ** , ssh_RSA *, const char *);
int decode_public_keyfile(ssh_context_t *, char *buf, int len, ssh_RSA **key,
	char **comment);

int decode_fressh_keyfile(ssh_context_t *, char *, int, char *, int,
	ssh_RSA **, char **);
int encode_fressh_keyfile(ssh_context_t *, char **, char *, int,
	ssh_RSA *, char *);

int decode_fsecure_keyfile(ssh_context_t *, char *, int, char *, int,
	ssh_RSA **, char **);
int encode_fsecure_keyfile(ssh_context_t *, char **, char *, int,
	ssh_RSA *, char *);

int lookup_authorized_key(ssh_context_t *, ssh_BIGNUM *, ssh_RSA **);
int lookup_known_host(ssh_context_t *, const char *, char *, char *, int);
int set_known_host(ssh_context_t *, const char *, char *, char *, char *, int);
int verify_host_key(ssh_context_t *, int, ssh_RSA *);

#endif /* _SSH_PARSE_H */
