/* $Id: ssh_sys.h,v 1.31 2001/02/07 17:57:00 thorpej Exp $ */

/*
 * Copyright 1999 RedBack Networks, Incorporated.
 * All rights reserved.
 *
 * This software is not in the public domain.  It is distributed 
 * under the terms of the license in the file LICENSE in the
 * same directory as this file.  If you have received a copy of this
 * software without the LICENSE file (which means that whoever gave
 * you this software violated its license) you may obtain a copy from
 * http://www.panix.com/~tls/LICENSE.txt
 */

#ifndef _SSH_SYS_H
#define _SSH_SYS_H

/*
 * System dependant function prototypes.
 *	These are functions that need to be implemented
 *	differently depending on the system we're running on.
 */

#include <sys/types.h>
#include <pwd.h>
#include <termios.h>

#ifdef SYS_BSD44
#include "ssh_sys_bsd44+.h"
#endif

#ifdef SYS_SYSV
#include "ssh_sys_bsd44+.h"
#endif

#ifdef SYS_LINUX
#include "ssh_sys_linux.h"
#endif

/*
 * Per X/Open CAE Spec, Issue 5, define 3 preprocessor symbols to be used to
 * specify the type of socket shutdown(2).  NetBSD added these in socket.h
 * revision 1.29, which was released into NetBSD 1.4.  Previous releases do
 * not have these.
 */
#ifndef SHUT_RD
#define SHUT_RD		0		/* Disallow further receives. */
#endif /* SHUT_RD */
#ifndef SHUT_WR
#define SHUT_WR		1		/* Disallow further sends. */
#endif /* SHUT_WR */
#ifndef SHUT_RDWR
#define SHUT_RDWR	2		/* Disallow further sends/receives. */
#endif /* SHUT_RDWR */

struct ssh_buf;

/* As in "struct ssh_password" -> "struct passwd" */
#define ssh_password	passwd

int ssh_sys_allocpty(ssh_context_t *, char *, int, int, int, int, u_int8_t *, size_t);
void ssh_sys_setbufsize(ssh_context_t *, int, int);
int ssh_sys_execcmd(ssh_context_t *, char *, int *);
void ssh_sys_exit(int)
#ifdef __GNUC__
	__attribute__((__noreturn__))
#endif
	;
void ssh_sys_randinit(void);
void ssh_sys_randclean(void);
void ssh_sys_randadd(void);
int ssh_sys_get_tty_size(int, struct winsize *);
int ssh_sys_set_tty_size(int, struct winsize *);
int ssh_sys_set_tty_modes(struct termios *, u_int8_t *, int);
int ssh_sys_put_tty_modes(struct ssh_buf *, struct termios *);
int ssh_sys_checkpw(char *, const char *);
int ssh_sys_setuser(ssh_context_t *, char *);
int ssh_sys_lookupuser(ssh_context_t *, char *);
int ssh_sys_lookupuid(ssh_context_t *, uid_t);
int ssh_sys_writepid(const char *);
int ssh_sys_daemonize(void);
int ssh_sys_readfile(char *, struct ssh_buf **);
void *ssh_sys_readin(const char *, off_t *);
void ssh_sys_readrelease(void *, off_t);

#endif /* _SSH_SYS_H */
