/* $Id: ssh_v1_iactive_client.c,v 1.2 2001/02/11 03:35:19 tls Exp $ */

/*
 * Copyright 1999 RedBack Networks, Incorporated.
 * All rights reserved.
 *
 * This software is not in the public domain.  It is distributed
 * under the terms of the license in the file LICENSE in the
 * same directory as this file.  If you have received a copy of this
 * software without the LICENSE file (which means that whoever gave
 * you this software violated its license) you may obtain a copy from
 * http://www.panix.com/~tls/LICENSE.txt
 */

/*
 * Copyright (c) 2000 Andrew Brown and Eric Haszlakiewicz.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. The names of the authors may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHORS ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL THE AUTHORS BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING,
 * BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED
 * AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

#include <errno.h>
#include <string.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <sys/time.h>
#include <sys/wait.h>
#include <signal.h>
#include <unistd.h>
#include <stdlib.h>

#include "options.h"

#include "sshd.h"
#include "ssh_buffer.h"
#include "ssh_channel.h"
#include "ssh_util.h"
#include "ssh_v1_messages.h"
#include "ssh_v1_proto.h"
#include "ssh_transport.h"
#include "ssh_types.h"

int 
ssh_v1_iactive_client(ssh_context_t * context, struct ssh_buf * buf,
    size_t size, int msg_type)
{
	FUNC_DECL(ssh_v1_iactive_client);

	struct ssh_event ev;

	ev.event_type = SSH_EVENT_NONE;

	switch (msg_type) {
	case SSH_V1_MSG_PORT_OPEN:
	case SSH_V1_MSG_CHANNEL_OPEN_CONFIRMATION:
	case SSH_V1_MSG_CHANNEL_OPEN_FAILURE:
	case SSH_V1_MSG_CHANNEL_DATA:
	case SSH_V1_MSG_CHANNEL_CLOSE:
	case SSH_V1_MSG_CHANNEL_CLOSE_CONFIRMATION:

	case SSH_V1_SMSG_X11_OPEN:
	case SSH_V1_SMSG_AGENT_OPEN:
		/* unimplemented. */
		EVT_V1_DEBUG(ev, context, "Unimplemented.");
		EVT_SEND(&ev, context);

		EVT_V1_FAILURE(ev);
		EVT_SEND(&ev, context);
		break;

	case SSH_V1_SMSG_STDOUT_DATA:
	case SSH_V1_SMSG_STDERR_DATA:
	    {
		u_int8_t *indata;
		u_int32_t dlen, wlen;
		int ofd = msg_type == SSH_V1_SMSG_STDOUT_DATA ?
		STDOUT_FILENO : STDERR_FILENO;

		indata = NULL;

		buf_use_binstr(buf, &indata, &dlen);
		if ((wlen = write(ofd, indata, dlen)) != dlen) {
			SSH_DLOG(3, ("write failed: %d/%d errno %d\n",
				     wlen, dlen, errno));
			EVT_V1_FAILURE(ev);
			EVT_SEND(&ev, context);
		}
		break;
	    }

	case SSH_V1_SMSG_EXITSTATUS:
		buf_get_int32(buf, &context->client->exitwith);
		SSH_DLOG(4, ("got exit status (%04x), moving on",
			     context->client->exitwith));
		context->v1_ctx.go_to_exit = 1;
		return RET_NEXT_STATE;
		break;

	default:
		SSH_DLOG(2, ("Client sent unknown packet type: %d\n",
		    msg_type));
		EVT_V1_DISCONNECT(ev, context, "Unkown packet type");
		EVT_SEND(&ev, context);
		return (RET_FAIL);
		break;

	}

	return (RET_OK);
}

int 
ssh_v1_exiting_client(ssh_context_t * context, struct ssh_buf * buf,
    size_t size, int msg_type)
{
	struct ssh_event ev;

	SSH_DLOG(3, ("****** oh my god...i'm done!"));

	/* Just send the exit confirmation */

	EVT_BUILD_SEND(ev, SSH_V1_CMSG_EXIT_CONFIRMATION);
	EVT_SEND(&ev, context);

	/* we close our socket here, but the child will have to do the same */
	close(context->transport_ctx.commsock);

	return RET_NEXT_STATE;
}
