/* $Id: ssh_v1_proto.h,v 1.15 2001/02/11 03:35:20 tls Exp $ */

/*
 * Copyright (c) 2000 Eric Haszlakiewicz.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING,
 * BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED
 * AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

#ifndef __ssh_v1_proto_h
#define __ssh_v1_proto_h

/* sshd_auth.c functions: */
int get_user(ssh_context_t *, struct ssh_buf *, size_t, int);
int send_user(ssh_context_t *, int);
int v1_auth_user(ssh_context_t *, struct ssh_buf *, size_t, int);

int v1_user_try_auth(ssh_context_t *, struct ssh_buf *, size_t, int);

int ssh_v1_prep_server(ssh_context_t *, struct ssh_buf *, size_t, int);
int ssh_v1_prep_client(ssh_context_t *, struct ssh_buf *, size_t, int);

int ssh_v1_iactive_server(ssh_context_t *, struct ssh_buf *, size_t, int);
int ssh_v1_iactive_client(ssh_context_t *, struct ssh_buf *, size_t, int);

int ssh_v1_exiting_server(ssh_context_t *, struct ssh_buf *, size_t, int);
int ssh_v1_exiting_client(ssh_context_t *, struct ssh_buf *, size_t, int);

void v1_cleanup(ssh_context_t *);

int dispatch_v1_server_msg(ssh_context_t *, struct ssh_buf *, int);
int dispatch_v1_client_msg(ssh_context_t *, struct ssh_buf *, int);
int start_v1_conversation(ssh_context_t *);
#endif
