/* $Id: ssh_transport.h,v 1.15 2001/02/11 03:35:32 tls Exp $ */

/*
 * Copyright 1999 RedBack Networks, Incorporated.
 * All rights reserved.
 *
 * This software is not in the public domain.  It is distributed 
 * under the terms of the license in the file LICENSE in the
 * same directory as this file.  If you have received a copy of this
 * software without the LICENSE file (which means that whoever gave
 * you this software violated its license) you may obtain a copy from
 * http://www.panix.com/~tls/LICENSE.txt
 */

/*
 * Copyright (c) 2000, 2001 Andrew Brown and Eric Haszlakiewicz.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. The names of the authors may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHORS ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL THE AUTHORS BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING,
 * BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED
 * AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

#ifndef _SSH_TRANSPORT_H
#define _SSH_TRANSPORT_H

struct ssh_buf;


/* Macros: */
/* 
XXX XXX XAX, argh, these use the v1 msg types.
XAX XXX need to do something different for v2.

XAX this might need also to check context->socket_gone.
XAX SEND_DISCONNECT probably needs to set socket_gone.
*/
#define SEND_DATA(c,t,p,l)  (c)->transport_ctx.xmit_data((c), (t), (p), (l))
#define SEND_FAILURE(c)		SEND_DATA((c), SSH_V1_SMSG_FAILURE, NULL, 0)
#define SEND_SUCCESS(c)		SEND_DATA((c), SSH_V1_SMSG_SUCCESS, NULL, 0)
#define SEND_DEBUG(c,p)		SEND_DATA((c), SSH_V1_MSG_DEBUG, (p), strlen(p))
#define SEND_DEBUGX(c,p,l)	SEND_DATA((c), SSH_V1_MSG_DEBUG, (p), (l))
#define SEND_DISCONNECT(c,p) SEND_DATA((c), SSH_V1_MSG_DISCONNECT, (p), strlen(p))

#define xmit_packet(c,t,b)	(c)->transport_ctx->xmit_packet((c), (t), (b))

/* transport_layer */
enum {
	SSH_V1_TRANSPORT,
	SSH_V2SSH_TRANSPORT,
	SSH_V2TLS_TRANSPORT
};

#define SSH_MIN_PACKET_SIZE (4 + 1 + 4)		/* Length + type + crc */
#define SSH_MAX_PACKET_SIZE (256 * 1024)
#define SSH_CRCCOMP_MAX_PACKETSIZE	(64 * 1024)

struct ssh_v1_transport
{
	int compressing;
	int max_packet_size;
	z_stream inz;
	z_stream outz;
	struct ssh_buf *send_buf;
	struct ssh_buf *clr_buf;
	struct ssh_buf *compress_buf;
};

struct ssh_v2_transport
{
	int compressing;
	z_stream inz;
	z_stream outz;
	int max_payload_size;
	int max_packet_size;
	struct ssh_buf *enc_buf;
	struct ssh_buf *clr_buf;
	struct ssh_mac_context *mac_send;
	struct ssh_mac_context *mac_recv;
	u_int32_t sequence_send;
	u_int32_t sequence_recv;
};

struct ssh_transport {

	/* Function to start the key exchange */
	int (*kexinit)(ssh_context_t *, struct ssh_buf *);

	/* Dispatch a transport layer message. */
	int (*dispatch_transport)(ssh_context_t *, struct ssh_buf *, size_t, int);

	int (*init_compression)(ssh_context_t *, u_int32_t);   /* Only for V1 */
	int (*init_decompress)(ssh_context_t *, u_int32_t);    /* Only for V1 */

	int (*read_packet)(ssh_context_t *, struct ssh_buf *);

	int (*xmit_data)(ssh_context_t *, u_int8_t, const u_int8_t *, size_t);
	int (*xmit_packet)(ssh_context_t *, const struct ssh_buf *);

	/* Set the maximum size of a packet */
	int (*set_max_packet_size)(struct ssh_transport *, int);

	/* Get the maximum size upper layers should try to send */
	int (*get_sendsize)(struct ssh_transport *);

	int commsock;				/* Communication socket */

	union {
		struct ssh_v1_transport v1;
		struct ssh_v2_transport v2;
	} u;
};

#define t_v1 u.v1
#define t_v2 u.v2


/*
 * Functions to initialize the transport layer.
 * These should be called after the introduction strings
 * when we know what version of the protocol and therefore
 * the transport layer that we'll be using.
 */
int v1_init_transport(struct ssh_transport *, int);
int v2ssh_init_transport(struct ssh_transport *, int);
int v2tls_init_transport(struct ssh_transport *, int);

/* ssh_deattack.c */
int detect_attack(unsigned char *, u_int32_t, unsigned char *);

/* ssh_intro.c */
int get_version(ssh_context_t *, struct ssh_version *);
char *build_version(ssh_context_t *);

#endif /* _SSH_TRANSPORT_H */
