/*
 * Copyright (c) 2003 Regents of The University of Michigan.
 * All Rights Reserved.  See COPYRIGHT.
 */

#import "NSImage(IconForType).h"

@implementation NSImage(IconForType)

+ ( NSImage * )iconForType: ( NSString * )extension
{
    static NSMutableDictionary	*images = nil;
    NSImage			*icon = nil;
    NSString			*ext = extension;
    
    if ( extension == nil ) {
        return( nil );
    }
    
    if ( [ ext isEqualToString: @"" ] ) {
        ext = @"'doc '";
    }
    
    if ( images == nil ) {
        images = [[ NSMutableDictionary alloc ] init ];
    }
    
    if (( icon = [ images objectForKey: ext ] ) == nil ) {
        if (( icon = [[ NSWorkspace sharedWorkspace ] iconForFileType: ext ] ) != nil ) {
            [ images setObject: icon forKey: ext ];
        }
    }
    
    return( icon );
}

@end
