/*
 * Copyright (c) 2003 Regents of The University of Michigan.
 * All Rights Reserved.  See COPYRIGHT.
 */

#include <sys/param.h>
#include <sys/wait.h>
#include <errno.h>
#include <fcntl.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <syslog.h>
#include <unistd.h>
#include "sshversion.h"

extern int	errno;

    float
sshversion()
{
    int		efd[ 2 ];
    char	*sshexec[] = { NULL, NULL, NULL };
    char	line[ MAXPATHLEN ], sshpath[ MAXPATHLEN ], *p;
    int		estatus, rr;
    
    /* check to see if there's an ssh binary in /usr/local/bin */
    if ( access( "/usr/local/bin/ssh", X_OK | F_OK ) == 0 ) {
        sprintf( sshpath, "/usr/local/bin/ssh" );
    } else {
        if ( access( "/usr/bin/ssh", X_OK | F_OK ) < 0 ) {
            syslog( LOG_ERR, "/usr/bin/ssh: %s", strerror( errno ));
            return( -1 );
        }
        sprintf( sshpath, "/usr/bin/ssh" );
    }
    
    if ( pipe( efd ) < 0 ) {
        syslog( LOG_ERR, "pipe: %s", strerror( errno ));
        return( -1 );
    }
    
    sshexec[ 0 ] = sshpath;
    sshexec[ 1 ] = "-V";
    sshexec[ 2 ] = NULL;
    
    switch ( fork()) {
    case 0:
        if ( dup2( efd[ 1 ], 2 ) < 0 ) {
            syslog( LOG_ERR, "dup2: %s", strerror( errno ));
            break;
        }
        ( void )close( efd[ 0 ] );
        ( void )close( efd[ 1 ] );
        
        execve( sshpath, ( char ** )sshexec, NULL );
        syslog( LOG_ERR, "execve ssh -V: %s", strerror( errno ));
        break;
        
    case -1:
        ( void )close( efd[ 0 ] );
        ( void )close( efd[ 1 ] );
        syslog( LOG_ERR, "fork failed: %s", strerror( errno ));
        exit( 2 );
        
    default:
        break;
    }
    
    ( void )close( efd[ 1 ] );
    rr = read( efd[ 0 ], line, MAXPATHLEN );
    if ( rr < 0 ) {
        syslog( LOG_ERR, "read returned < 0: %s", strerror( errno ));
        return( -1 );
    }
    
    line[ rr ] = '\0';
    syslog( LOG_INFO, line );
    
    wait( &estatus );

    if (( p = strstr( line, "OpenSSH" )) == NULL ) {
        return( -1 );
    }
    if (( p = strchr( line, '_' )) == NULL ) return( -1 );
    
    
    p++;
    if ( p != NULL ) {
        float	ver;
        int		i;
        char	tmp[ 4 ];
        
        for ( i = 0; i < 3; i++ ) {
            if ( *p == NULL ) break;
            tmp[ i ] = *p;
            p++;
        }
	
        ver = atof( tmp );
        return( ver );
    }
    
    return( -1 );
}