/*
 * Decompiled with CFR 0.152.
 */
package app.session;

import app.SessionSpec;
import app.Settings;
import app.session.Session;
import app.session.SessionIOHandler;
import java.io.IOException;
import telnet.Dimension;
import telnet.TelnetProtocolHandler;

public class TelnetSession
extends Session
implements SessionIOHandler {
    private TelnetProtocolHandler telnet;

    public TelnetSession() {
        this.emulation.setLocalEcho(true);
    }

    public void connect(SessionSpec sessionSpec) {
        this.telnet = new TelnetProtocolHandler(){

            public String getTerminalType() {
                if (Settings.terminalType.length() > 0) {
                    return Settings.terminalType;
                }
                return TelnetSession.this.emulation.getTerminalID();
            }

            public Dimension getWindowSize() {
                return new Dimension(TelnetSession.this.emulation.width, TelnetSession.this.emulation.height);
            }

            public void setLocalEcho(boolean bl) {
                TelnetSession.this.emulation.localecho = bl;
            }

            public void notifyEndOfRecord() {
            }

            public void write(byte[] byArray) throws IOException {
                TelnetSession.this.sendData(byArray, 0, byArray.length);
            }
        };
        super.connect(sessionSpec, this);
    }

    protected int defaultPort() {
        return 23;
    }

    public void handleReceiveData(byte[] byArray, int n, int n2) throws IOException {
        int n3;
        this.telnet.inputfeed(byArray, n, n2);
        do {
            if ((n3 = this.telnet.negotiate(byArray, n, n2)) <= 0) continue;
            this.receiveData(byArray, n, n3);
        } while (n3 != -1);
    }

    public void handleSendData(byte[] byArray, int n, int n2) throws IOException {
        if (n2 > 0) {
            this.telnet.transpose(byArray, n, n2);
        } else {
            this.telnet.sendTelnetNOP();
        }
    }
}

