/*
 * Decompiled with CFR 0.152.
 */
package gui;

import gui.Activatable;
import gui.MainMenu;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.List;

public abstract class EditableMenu
extends List
implements CommandListener,
Activatable {
    protected static Command newCommand = new Command("New", 1, 8);
    protected static Command editCommand = new Command("Edit", 8, 9);
    protected static Command deleteCommand = new Command("Delete", 8, 10);
    protected Command selectCommand = List.SELECT_COMMAND;
    private Activatable back;

    public EditableMenu(String string) {
        super(string, 3);
        this.addCommand(newCommand);
        this.addCommand(editCommand);
        this.addCommand(deleteCommand);
        this.addCommand(MainMenu.backCommand);
        this.setCommandListener(this);
    }

    protected void replaceSelectCommand(Command command) {
        this.selectCommand = command;
        this.addCommand(command);
    }

    public void deleteAll() {
        while (this.size() > 0) {
            this.delete(0);
        }
    }

    protected abstract void addItems();

    public void commandAction(Command command, Displayable displayable) {
        if (command == List.SELECT_COMMAND || command == this.selectCommand) {
            int n = this.getSelectedIndex();
            if (n >= 0 && n < this.size()) {
                this.doSelect(this.getSelectedIndex());
            }
        } else if (command == newCommand) {
            this.doNew();
        } else if (command == editCommand) {
            int n = this.getSelectedIndex();
            if (n >= 0 && n < this.size()) {
                this.doEdit(n);
            }
        } else if (command == deleteCommand) {
            int n = this.getSelectedIndex();
            if (n >= 0 && n < this.size()) {
                this.doDelete(n);
            }
        } else if (command == MainMenu.backCommand) {
            this.doBack();
        }
    }

    public void activate() {
        this.addItems();
        MainMenu.setDisplay((Displayable)this);
    }

    public void activate(Activatable activatable) {
        this.back = activatable;
        this.activate();
    }

    protected abstract void doSelect(int var1);

    protected abstract void doEdit(int var1);

    protected abstract void doDelete(int var1);

    protected abstract void doNew();

    protected void doBack() {
        this.back.activate();
    }
}

