/*
 * Decompiled with CFR 0.152.
 */
package gui;

import app.SessionManager;
import app.SessionSpec;
import app.Settings;
import gui.EditableForm;
import gui.MainMenu;
import gui.settings.SettingsForm;
import javax.microedition.lcdui.ChoiceGroup;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Item;
import javax.microedition.lcdui.StringItem;
import javax.microedition.lcdui.TextField;

public class SessionForm
extends EditableForm {
    public static final Command saveCommand = new Command("Save", 1, 1);
    public static final Command createCommand = new Command("Create", 1, 1);
    public static final String WARNING_REQUIRED = "Please fill in required fields.";
    private int connectionIndex = 1;
    private boolean edit;
    private TextField tfAlias;
    private TextField tfHost;
    private TextField tfUsername;
    private TextField tfPassword;
    private ChoiceGroup cgUsePublicKey;
    private ChoiceGroup cgType;
    private static String[] typeNames = new String[]{"SSH", "Telnet"};
    private static String[] typeCodes = new String[]{"ssh", "telnet"};

    public SessionForm(boolean bl) {
        super(bl ? "Edit Session" : "New Session");
        this.edit = bl;
        this.tfAlias = new TextField("Alias:", null, 255, 0);
        this.tfHost = new TextField("Host:", null, 255, 0);
        this.tfUsername = new TextField("Username:", null, 255, 0);
        this.tfPassword = new TextField("Password:", null, 255, 65536);
        this.cgType = new ChoiceGroup("Type", 1);
        for (int i = 0; i < typeNames.length; ++i) {
            this.cgType.append(typeNames[i], null);
        }
        this.append((Item)this.tfAlias);
        this.append((Item)this.tfHost);
        this.append((Item)this.cgType);
        this.append((Item)new StringItem("Authentication:\n", "For SSH connections only. Optional."));
        this.append((Item)this.tfUsername);
        this.append((Item)this.tfPassword);
        if (Settings.x != null) {
            this.cgUsePublicKey = new ChoiceGroup("Use Public Key", 1);
            SettingsForm.booleanChoiceGroup(this.cgUsePublicKey);
            this.append((Item)this.cgUsePublicKey);
        }
        if (bl) {
            this.addCommand(saveCommand);
        } else {
            this.addCommand(createCommand);
        }
    }

    public void activate() {
        if (!this.edit) {
            this.tfAlias.setString("");
            this.tfHost.setString("");
            this.tfUsername.setString("");
            this.tfPassword.setString("");
        }
        super.activate();
    }

    public void setConnectionIndex(int n) {
        this.connectionIndex = n;
        SessionSpec sessionSpec = SessionManager.getSession(n);
        if (sessionSpec != null) {
            this.tfAlias.setString(sessionSpec.alias);
            this.tfHost.setString(sessionSpec.host);
            if (sessionSpec.type != null) {
                for (int i = 0; i < typeCodes.length; ++i) {
                    if (!typeCodes[i].equals(sessionSpec.type)) continue;
                    this.cgType.setSelectedIndex(i, true);
                }
            }
            this.tfUsername.setString(sessionSpec.username);
            this.tfPassword.setString(sessionSpec.password);
            if (this.cgUsePublicKey != null) {
                this.cgUsePublicKey.setSelectedIndex(sessionSpec.usepublickey ? 0 : 1, true);
            }
        }
    }

    public void commandAction(Command command, Displayable displayable) {
        if (command == saveCommand) {
            this.doSave(false);
        } else if (command == createCommand) {
            this.doSave(true);
        } else {
            super.commandAction(command, displayable);
        }
    }

    private void doSave(boolean bl) {
        if ((!bl || this.connectionIndex != -1) && this.validateForm()) {
            SessionSpec sessionSpec = new SessionSpec();
            sessionSpec.alias = this.tfAlias.getString();
            sessionSpec.type = typeCodes[this.cgType.getSelectedIndex()];
            sessionSpec.host = this.tfHost.getString();
            sessionSpec.username = this.tfUsername.getString();
            sessionSpec.password = this.tfPassword.getString();
            if (this.cgUsePublicKey != null) {
                boolean bl2 = sessionSpec.usepublickey = this.cgUsePublicKey.getSelectedIndex() == 0;
            }
            if (bl) {
                SessionManager.addSession(sessionSpec);
            } else {
                SessionManager.replaceSession(this.connectionIndex, sessionSpec);
            }
            this.doBack();
        }
    }

    protected boolean validateForm() {
        String string = this.tfAlias.getString();
        String string2 = this.tfHost.getString();
        if (string.length() == 0 || string2.length() == 0) {
            MainMenu.showErrorMessage(WARNING_REQUIRED);
            return false;
        }
        return true;
    }
}

