/*
 * Decompiled with CFR 0.152.
 */
package gui.session.macros;

import app.session.MacroSetManager;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Vector;

public class MacroSet {
    private static final byte VERSION = 1;
    public String name;
    public String value;
    public Vector macros;

    public MacroSet() {
        this.macros = new Vector();
    }

    public MacroSet(String string, String string2) {
        this.name = string;
        this.value = string2;
    }

    public void read(DataInputStream dataInputStream) throws IOException {
        dataInputStream.readByte();
        this.name = dataInputStream.readUTF();
        int n = dataInputStream.readByte();
        for (int i = 0; i < n; ++i) {
            String string = dataInputStream.readUTF();
            String string2 = dataInputStream.readUTF();
            MacroSet macroSet = new MacroSet(string, string2);
            this.macros.addElement(macroSet);
        }
    }

    public void write(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeByte(1);
        dataOutputStream.writeUTF(this.name);
        dataOutputStream.writeByte(this.macros.size());
        for (int i = 0; i < this.macros.size(); ++i) {
            MacroSet macroSet = (MacroSet)this.macros.elementAt(i);
            dataOutputStream.writeUTF(macroSet.name);
            dataOutputStream.writeUTF(macroSet.value);
        }
    }

    public MacroSet getMacro(int n) {
        return n >= this.macros.size() ? null : (MacroSet)this.macros.elementAt(n);
    }

    public void addMacro(MacroSet macroSet) {
        this.macros.addElement(macroSet);
        MacroSetManager.saveMacroSets();
    }

    public void deleteMacro(int n) {
        if (n < this.macros.size()) {
            this.macros.removeElementAt(n);
            MacroSetManager.saveMacroSets();
        }
    }

    public void replaceMacro(int n, MacroSet macroSet) {
        if (n >= this.macros.size()) {
            this.macros.addElement(macroSet);
        } else {
            this.macros.setElementAt(macroSet, n);
        }
        MacroSetManager.saveMacroSets();
    }
}

