/*
 * Decompiled with CFR 0.152.
 */
package ssh;

import app.Settings;
import app.session.SshSession;
import java.io.IOException;
import java.util.Date;
import java.util.Random;
import ssh.SshPacket;
import ssh.v1.BigInteger;
import ssh.v1.Cipher;
import ssh.v1.MD5;
import ssh.v1.SshCrypto;
import ssh.v1.SshPacket1;
import ssh.v2.DHKeyExchange;
import ssh.v2.PublicKeyAuthentication;
import ssh.v2.SHA1Digest;
import ssh.v2.SshCrypto2;
import ssh.v2.SshPacket2;

public class SshIO {
    private static MD5 md5 = new MD5();
    private SshSession sshSession;
    private String idstr = "";
    private String idstr_sent = "SSH/MidpSSH\n";
    private SshCrypto crypto;
    private SshCrypto2 crypto2;
    String cipher_type;
    public static Random rnd = new Random();
    private int remotemajor;
    private int remoteminor;
    private int mymajor;
    private int myminor;
    private int useprotocol;
    public String login;
    public String password;
    private String dataToSend = null;
    private byte lastPacketSentType;
    private boolean initting = true;
    private int authmode;
    public boolean usepublickey = false;
    private static final byte MODE_PUBLICKEY = 1;
    private static final byte MODE_PASSWORD = 2;
    private static final byte SSH_MSG_DISCONNECT = 1;
    private static final byte SSH_SMSG_PUBLIC_KEY = 2;
    private static final byte SSH_CMSG_SESSION_KEY = 3;
    private static final byte SSH_CMSG_USER = 4;
    private static final byte SSH_CMSG_AUTH_PASSWORD = 9;
    private static final byte SSH_CMSG_REQUEST_PTY = 10;
    private static final byte SSH_CMSG_EXEC_SHELL = 12;
    private static final byte SSH_SMSG_SUCCESS = 14;
    private static final byte SSH_SMSG_FAILURE = 15;
    private static final byte SSH_CMSG_STDIN_DATA = 16;
    private static final byte SSH_SMSG_STDOUT_DATA = 17;
    private static final byte SSH_SMSG_STDERR_DATA = 18;
    private static final byte SSH_SMSG_EXITSTATUS = 20;
    private static final byte SSH_MSG_IGNORE = 32;
    private static final byte SSH_CMSG_EXIT_CONFIRMATION = 33;
    private static final byte SSH2_MSG_DISCONNECT = 1;
    private static final byte SSH2_MSG_IGNORE = 2;
    private static final byte SSH2_MSG_SERVICE_REQUEST = 5;
    private static final byte SSH2_MSG_SERVICE_ACCEPT = 6;
    private static final byte SSH2_MSG_KEXINIT = 20;
    private static final byte SSH2_MSG_NEWKEYS = 21;
    private static final byte SSH2_MSG_KEXDH_INIT = 30;
    private static final byte SSH2_MSG_KEXDH_REPLY = 31;
    private static final byte SSH2_MSG_USERAUTH_REQUEST = 50;
    private static final byte SSH2_MSG_USERAUTH_FAILURE = 51;
    private static final byte SSH2_MSG_USERAUTH_SUCCESS = 52;
    private static final byte SSH2_MSG_CHANNEL_OPEN = 90;
    private static final byte SSH2_MSG_CHANNEL_OPEN_CONFIRMATION = 91;
    private static final byte SSH2_MSG_CHANNEL_DATA = 94;
    private static final byte SSH2_MSG_CHANNEL_CLOSE = 97;
    private static final byte SSH2_MSG_CHANNEL_REQUEST = 98;
    private int outgoingseq = 0;
    private static final int SSH_CIPHER_IDEA = 1;
    private static final int SSH_CIPHER_DES = 2;
    private static final int SSH_CIPHER_3DES = 3;
    private static final int SSH_CIPHER_BLOWFISH = 6;
    private boolean cansenddata = false;
    SshPacket currentpacket;
    private DHKeyExchange dhkex;
    private byte[] session_id;

    public SshIO(SshSession sshSession) {
        this.sshSession = sshSession;
    }

    public void write(byte[] byArray) throws IOException {
        this.sshSession.sendData(byArray);
    }

    protected void sendDisconnect(int n, String string) throws IOException {
        SshPacket sshPacket;
        if (this.useprotocol == 2) {
            sshPacket = new SshPacket2(1);
            sshPacket.putInt32(n);
            sshPacket.putString(string);
            sshPacket.putString("en");
            this.sendPacket2((SshPacket2)sshPacket);
        }
        if (this.useprotocol == 1) {
            sshPacket = new SshPacket1(1);
            sshPacket.putInt32(n);
            sshPacket.putString(string);
            sshPacket.putString("en");
            this.sendPacket1((SshPacket1)sshPacket);
        }
    }

    public void sendData(byte[] byArray, int n, int n2) throws IOException {
        String string = new String(byArray, n, n2);
        this.dataToSend = this.dataToSend == null ? string : this.dataToSend + string;
        if (this.cansenddata) {
            if (this.useprotocol == 2) {
                SshPacket2 sshPacket2 = new SshPacket2(94);
                sshPacket2.putInt32(0);
                sshPacket2.putString(this.dataToSend);
                this.sendPacket2(sshPacket2);
            }
            if (this.useprotocol == 1) {
                this.Send_SSH_CMSG_STDIN_DATA(this.dataToSend);
            }
            this.dataToSend = null;
        }
    }

    public byte[] handleSSH(byte[] byArray, int n, int n2) throws IOException {
        int n3;
        block11: {
            n3 = n + n2;
            if (this.initting) {
                while (n < n3) {
                    byte by = byArray[n++];
                    this.idstr = this.idstr + (char)by;
                    if (by != 10) continue;
                    if (this.idstr.startsWith("SSH-")) {
                        this.initting = false;
                        this.remotemajor = Integer.parseInt(this.idstr.substring(4, 5));
                        String string = this.idstr.substring(6, 8);
                        if (!Character.isDigit(string.charAt(1))) {
                            string = string.substring(0, 1);
                        }
                        this.remoteminor = Integer.parseInt(string);
                        if (this.remotemajor == 2) {
                            this.mymajor = 2;
                            this.myminor = 0;
                            this.useprotocol = 2;
                        } else if (this.remoteminor == 99 && Settings.sshVersionPreferred == 2) {
                            this.mymajor = 2;
                            this.myminor = 0;
                            this.useprotocol = 2;
                        } else {
                            this.mymajor = 1;
                            this.myminor = 5;
                            this.useprotocol = 1;
                        }
                        this.idstr_sent = "SSH-" + this.mymajor + "." + this.myminor + "-" + this.idstr_sent;
                        this.write(this.idstr_sent.getBytes());
                        this.currentpacket = this.useprotocol == 2 ? new SshPacket2() : new SshPacket1();
                        break block11;
                    }
                    this.idstr = "";
                }
                if (n == n3) {
                    return "".getBytes();
                }
                return "PHASE_INIT error\n".getBytes();
            }
        }
        String string = "";
        while (n < n3) {
            n = this.currentpacket.addPayload(byArray, n, n3 - n);
            if (!this.currentpacket.isFinished()) continue;
            if (this.useprotocol == 2) {
                string = string + this.handlePacket2((SshPacket2)this.currentpacket);
                this.currentpacket = new SshPacket2(this.crypto2);
            }
            if (this.useprotocol != 1) continue;
            string = string + this.handlePacket1((SshPacket1)this.currentpacket);
            this.currentpacket = new SshPacket1(this.crypto);
        }
        return string.getBytes();
    }

    private String fingerprint(byte[] byArray) {
        byte[] byArray2 = md5.digest(byArray);
        StringBuffer stringBuffer = new StringBuffer();
        int n = byArray2.length;
        for (int i = 0; i < n; ++i) {
            int n2 = byArray2[i] & 0xFF;
            String string = Integer.toHexString(n2);
            if (string.length() == 1) {
                stringBuffer.append('0');
            }
            stringBuffer.append(string);
            if (i + 1 >= n) continue;
            stringBuffer.append(':');
        }
        return stringBuffer.toString();
    }

    private String handlePacket2(SshPacket2 sshPacket2) throws IOException {
        switch (sshPacket2.getType()) {
            case 1: {
                sshPacket2.getInt32();
                String string = sshPacket2.getString();
                return "\r\nDisconnected: " + string + "\r\n";
            }
            case 21: {
                this.sendPacket2(new SshPacket2(21));
                this.updateKeys(this.dhkex);
                SshPacket2 sshPacket22 = new SshPacket2(5);
                sshPacket22.putString("ssh-userauth");
                this.sendPacket2(sshPacket22);
                return "Requesting authentication\r\n";
            }
            case 6: {
                SshPacket2 sshPacket23 = new SshPacket2(50);
                sshPacket23.putString(this.login);
                sshPacket23.putString("ssh-connection");
                if (this.usepublickey && Settings.x != null) {
                    this.authmode = 1;
                    PublicKeyAuthentication publicKeyAuthentication = new PublicKeyAuthentication();
                    sshPacket23.putString("publickey");
                    sshPacket23.putByte((byte)1);
                    sshPacket23.putString("ssh-dss");
                    sshPacket23.putString(publicKeyAuthentication.getPublicKeyBlob());
                    byte[] byArray = publicKeyAuthentication.sign(this.session_id, sshPacket23.getData());
                    sshPacket23.putString(byArray);
                    this.sendPacket2(sshPacket23);
                    return "Sent publickey\r\n";
                }
                this.authmode = 2;
                sshPacket23.putString("password");
                sshPacket23.putByte((byte)0);
                sshPacket23.putString(this.password);
                this.sendPacket2(sshPacket23);
                return "Sent password\r\n";
            }
            case 51: {
                String string = sshPacket2.getString();
                sshPacket2.getByte();
                if (this.authmode != 2) {
                    this.authmode = 2;
                    SshPacket2 sshPacket24 = new SshPacket2(50);
                    sshPacket24.putString(this.login);
                    sshPacket24.putString("ssh-connection");
                    sshPacket24.putString("password");
                    sshPacket24.putByte((byte)0);
                    sshPacket24.putString(this.password);
                    this.sendPacket2(sshPacket24);
                    return "Retrying with password\r\n";
                }
                return "Authentication failure.\r\nAvailable methods are: " + string + "\r\n";
            }
            case 52: {
                SshPacket2 sshPacket25 = new SshPacket2(90);
                sshPacket25.putString("session");
                sshPacket25.putInt32(0);
                sshPacket25.putInt32(0x100000);
                sshPacket25.putInt32(16384);
                this.sendPacket2(sshPacket25);
                return "Authentication accepted\r\n";
            }
            case 91: {
                sshPacket2.getInt32();
                int n = sshPacket2.getInt32();
                sshPacket2.getInt32();
                sshPacket2.getInt32();
                SshPacket2 sshPacket26 = new SshPacket2(98);
                sshPacket26.putInt32(n);
                sshPacket26.putString("pty-req");
                sshPacket26.putByte((byte)0);
                sshPacket26.putString(this.getTerminalID());
                sshPacket26.putInt32(this.getTerminalWidth());
                sshPacket26.putInt32(this.getTerminalHeight());
                sshPacket26.putInt32(0);
                sshPacket26.putInt32(0);
                sshPacket26.putString("");
                this.sendPacket2(sshPacket26);
                sshPacket26 = new SshPacket2(98);
                sshPacket26.putInt32(n);
                sshPacket26.putString("shell");
                sshPacket26.putByte((byte)0);
                this.sendPacket2(sshPacket26);
                this.cansenddata = true;
                if (this.dataToSend != null) {
                    sshPacket26 = new SshPacket2(94);
                    sshPacket26.putInt32(0);
                    sshPacket26.putString(this.dataToSend);
                    this.sendPacket2(sshPacket26);
                    this.dataToSend = null;
                }
                return "Shell opened\r\n";
            }
            case 94: {
                sshPacket2.getInt32();
                String string = sshPacket2.getString();
                return string;
            }
            case 97: {
                this.sendDisconnect(11, "Finished");
                break;
            }
            case 20: {
                SshPacket2 sshPacket27 = new SshPacket2(20);
                byte[] byArray = new byte[16];
                Random random = new Random();
                for (int i = 0; i < byArray.length; ++i) {
                    byArray[i] = (byte)random.nextInt();
                }
                sshPacket27.putBytes(byArray);
                sshPacket27.putString("diffie-hellman-group1-sha1");
                sshPacket27.putString("ssh-dss");
                this.cipher_type = "DES3";
                String string = "3des-cbc";
                sshPacket27.putString(string);
                sshPacket27.putString(string);
                sshPacket27.putString("hmac-sha1");
                sshPacket27.putString("hmac-sha1");
                sshPacket27.putString("none");
                sshPacket27.putString("none");
                sshPacket27.putString("");
                sshPacket27.putString("");
                sshPacket27.putByte((byte)0);
                sshPacket27.putInt32(0);
                byte[] byArray2 = sshPacket27.getData();
                this.sendPacket2(sshPacket27);
                if (Settings.ssh2StoreKey) {
                    if (Settings.ssh2x == null || Settings.ssh2y == null) {
                        byte[][] byArray3 = DHKeyExchange.generateKeyPairBytes(Settings.ssh2KeySize);
                        Settings.ssh2x = byArray3[0];
                        Settings.ssh2y = byArray3[1];
                        Settings.saveSettings();
                    }
                    this.dhkex = new DHKeyExchange(Settings.ssh2x, Settings.ssh2y);
                } else {
                    this.dhkex = new DHKeyExchange(Settings.ssh2KeySize);
                }
                this.dhkex.V_S = this.idstr.trim().getBytes();
                this.dhkex.V_C = this.idstr_sent.trim().getBytes();
                this.dhkex.I_S = this.add20(sshPacket2.getData());
                this.dhkex.I_C = this.add20(byArray2);
                sshPacket27 = new SshPacket2(30);
                sshPacket27.putMpInt(this.dhkex.getE());
                this.sendPacket2(sshPacket27);
                return "Negotiating...";
            }
            case 31: {
                byte[] byArray = sshPacket2.getByteString();
                byte[] byArray4 = sshPacket2.getMpInt();
                byte[] byArray5 = sshPacket2.getByteString();
                boolean bl = this.dhkex.next(byArray, byArray4, byArray5);
                if (bl) {
                    return "OK\r\n" + this.dhkex.keyalg + " " + this.fingerprint(byArray) + "\r\n";
                }
                this.sendDisconnect(3, "Key exchange failed");
                return "FAILED\r\n";
            }
        }
        return "";
    }

    private void sendPacket2(SshPacket2 sshPacket2) throws IOException {
        this.write(sshPacket2.getPayLoad(this.crypto2, this.outgoingseq));
        ++this.outgoingseq;
        this.lastPacketSentType = sshPacket2.getType();
    }

    private void updateKeys(DHKeyExchange dHKeyExchange) {
        byte[] byArray;
        byte[] byArray2;
        int n;
        byte[] byArray3 = dHKeyExchange.K;
        byte[] byArray4 = dHKeyExchange.H;
        SHA1Digest sHA1Digest = new SHA1Digest();
        if (this.session_id == null) {
            this.session_id = new byte[byArray4.length];
            System.arraycopy(byArray4, 0, this.session_id, 0, byArray4.length);
        }
        SshPacket2 sshPacket2 = new SshPacket2();
        sshPacket2.putMpInt(byArray3);
        sshPacket2.putBytes(byArray4);
        sshPacket2.putByte((byte)65);
        sshPacket2.putBytes(this.session_id);
        byte[] byArray5 = sshPacket2.getData();
        sHA1Digest.update(byArray5, 0, byArray5.length);
        byte[] byArray6 = new byte[sHA1Digest.getDigestSize()];
        sHA1Digest.doFinal(byArray6, 0);
        int n2 = n = byArray5.length - this.session_id.length - 1;
        byArray5[n2] = (byte)(byArray5[n2] + 1);
        sHA1Digest.update(byArray5, 0, byArray5.length);
        byte[] byArray7 = new byte[sHA1Digest.getDigestSize()];
        sHA1Digest.doFinal(byArray7, 0);
        int n3 = n;
        byArray5[n3] = (byte)(byArray5[n3] + 1);
        sHA1Digest.update(byArray5, 0, byArray5.length);
        byte[] byArray8 = new byte[sHA1Digest.getDigestSize()];
        sHA1Digest.doFinal(byArray8, 0);
        int n4 = n;
        byArray5[n4] = (byte)(byArray5[n4] + 1);
        sHA1Digest.update(byArray5, 0, byArray5.length);
        byte[] byArray9 = new byte[sHA1Digest.getDigestSize()];
        sHA1Digest.doFinal(byArray9, 0);
        int n5 = n;
        byArray5[n5] = (byte)(byArray5[n5] + 1);
        sHA1Digest.update(byArray5, 0, byArray5.length);
        byte[] byArray10 = new byte[sHA1Digest.getDigestSize()];
        sHA1Digest.doFinal(byArray10, 0);
        int n6 = n;
        byArray5[n6] = (byte)(byArray5[n6] + 1);
        sHA1Digest.update(byArray5, 0, byArray5.length);
        byte[] byArray11 = new byte[sHA1Digest.getDigestSize()];
        sHA1Digest.doFinal(byArray11, 0);
        int n7 = 24;
        while (n7 > byArray9.length) {
            sshPacket2 = new SshPacket2();
            sshPacket2.putMpInt(byArray3);
            sshPacket2.putBytes(byArray4);
            sshPacket2.putBytes(byArray9);
            byArray5 = sshPacket2.getData();
            sHA1Digest.update(byArray5, 0, byArray5.length);
            byArray2 = new byte[sHA1Digest.getDigestSize()];
            sHA1Digest.doFinal(byArray2, 0);
            byArray = new byte[byArray9.length + byArray2.length];
            System.arraycopy(byArray9, 0, byArray, 0, byArray9.length);
            System.arraycopy(byArray2, 0, byArray, byArray9.length, byArray2.length);
            byArray9 = byArray;
        }
        while (n7 > byArray8.length) {
            sshPacket2 = new SshPacket2();
            sshPacket2.putMpInt(byArray3);
            sshPacket2.putBytes(byArray4);
            sshPacket2.putBytes(byArray8);
            byArray5 = sshPacket2.getData();
            sHA1Digest.update(byArray5, 0, byArray5.length);
            byArray2 = new byte[sHA1Digest.getDigestSize()];
            sHA1Digest.doFinal(byArray2, 0);
            byArray = new byte[byArray8.length + byArray2.length];
            System.arraycopy(byArray8, 0, byArray, 0, byArray8.length);
            System.arraycopy(byArray2, 0, byArray, byArray8.length, byArray2.length);
            byArray8 = byArray;
        }
        this.crypto2 = new SshCrypto2(byArray6, byArray7, byArray8, byArray9, byArray10, byArray11);
    }

    private byte[] add20(byte[] byArray) {
        byte[] byArray2 = new byte[byArray.length + 1];
        byArray2[0] = 20;
        System.arraycopy(byArray, 0, byArray2, 1, byArray.length);
        return byArray2;
    }

    private String handlePacket1(SshPacket1 sshPacket1) throws IOException {
        switch (sshPacket1.getType()) {
            case 1: {
                return sshPacket1.getString();
            }
            case 2: {
                byte[] byArray = sshPacket1.getBytes(8);
                sshPacket1.getBytes(4);
                byte[] byArray2 = sshPacket1.getMpInt();
                byte[] byArray3 = sshPacket1.getMpInt();
                sshPacket1.getBytes(4);
                byte[] byArray4 = sshPacket1.getMpInt();
                byte[] byArray5 = sshPacket1.getMpInt();
                sshPacket1.getBytes(4);
                byte[] byArray6 = sshPacket1.getBytes(4);
                sshPacket1.getBytes(4);
                String string = this.Send_SSH_CMSG_SESSION_KEY(byArray, byArray3, byArray5, byArray6, byArray2, byArray4);
                if (string != null) {
                    return string;
                }
                byte[] byArray7 = new byte[byArray4.length + byArray5.length];
                System.arraycopy(byArray5, 0, byArray7, 0, byArray5.length);
                System.arraycopy(byArray2, 0, byArray7, byArray5.length, byArray2.length);
                String string2 = this.fingerprint(byArray7);
                return string2 + "\r\n";
            }
            case 14: {
                if (this.lastPacketSentType == 3) {
                    this.Send_SSH_CMSG_USER();
                    break;
                }
                if (this.lastPacketSentType == 4) {
                    this.Send_SSH_CMSG_REQUEST_PTY();
                    return "Empty password login.\r\n";
                }
                if (this.lastPacketSentType == 9) {
                    this.Send_SSH_CMSG_REQUEST_PTY();
                    return "Login & password accepted\r\n";
                }
                if (this.lastPacketSentType == 10) {
                    this.cansenddata = true;
                    if (this.dataToSend != null) {
                        this.Send_SSH_CMSG_STDIN_DATA(this.dataToSend);
                        this.dataToSend = null;
                    }
                    this.Send_SSH_CMSG_EXEC_SHELL();
                    break;
                }
                if (this.lastPacketSentType != 12) break;
                break;
            }
            case 15: {
                if (this.lastPacketSentType == 9) {
                    return "Login & password not accepted\r\n";
                }
                if (this.lastPacketSentType == 4) {
                    this.Send_SSH_CMSG_AUTH_PASSWORD();
                    break;
                }
                if (this.lastPacketSentType != 10) break;
                break;
            }
            case 17: {
                return sshPacket1.getString();
            }
            case 18: {
                return "Error : " + sshPacket1.getString();
            }
            case 20: {
                sshPacket1.getInt32();
                this.Send_SSH_CMSG_EXIT_CONFIRMATION();
            }
        }
        return "";
    }

    private void sendPacket1(SshPacket1 sshPacket1) throws IOException {
        this.write(sshPacket1.getPayLoad(this.crypto));
        this.lastPacketSentType = sshPacket1.getType();
    }

    private String Send_SSH_CMSG_SESSION_KEY(byte[] byArray, byte[] byArray2, byte[] byArray3, byte[] byArray4, byte[] byArray5, byte[] byArray6) throws IOException {
        byte by;
        byte[] byArray7 = new byte[byArray3.length + byArray2.length + byArray.length];
        System.arraycopy(byArray3, 0, byArray7, 0, byArray3.length);
        System.arraycopy(byArray2, 0, byArray7, byArray3.length, byArray2.length);
        System.arraycopy(byArray, 0, byArray7, byArray3.length + byArray2.length, byArray.length);
        byte[] byArray8 = md5.digest(byArray7);
        if ((byArray4[3] & 0x40) != 0 && this.hasCipher("Blowfish")) {
            by = 6;
            this.cipher_type = "Blowfish";
        } else if ((byArray4[3] & 2) != 0 && this.hasCipher("IDEA")) {
            by = 1;
            this.cipher_type = "IDEA";
        } else if ((byArray4[3] & 8) != 0 && this.hasCipher("DES3")) {
            by = 3;
            this.cipher_type = "DES3";
        } else if ((byArray4[3] & 4) != 0 && this.hasCipher("DES")) {
            by = 2;
            this.cipher_type = "DES";
        } else {
            return "\rIncompatible ciphers.\r\n";
        }
        byte[] byArray9 = new byte[16];
        byte[] byArray10 = new byte[16];
        byArray9 = md5.digest(("" + rnd.nextLong() * new Date().getTime()).getBytes());
        byArray10 = byArray9;
        byArray9 = md5.digest(SshIO.addArrayOfBytes(md5.digest((this.password + this.login).getBytes()), byArray9));
        byArray10 = md5.digest(SshIO.addArrayOfBytes(md5.digest((this.password + this.login).getBytes()), byArray10));
        byte[] byArray11 = SshIO.addArrayOfBytes(byArray9, byArray10);
        byte[] byArray12 = SshIO.XORArrayOfBytes(byArray9, byArray8);
        byArray12 = SshIO.addArrayOfBytes(byArray12, byArray10);
        byte[] byArray13 = byArray2.length <= byArray3.length ? SshIO.encrypteRSAPkcs1Twice(byArray12, byArray5, byArray2, byArray6, byArray3) : SshIO.encrypteRSAPkcs1Twice(byArray12, byArray6, byArray3, byArray5, byArray2);
        int n = 0;
        SshPacket1 sshPacket1 = new SshPacket1(3);
        sshPacket1.putByte(by);
        sshPacket1.putBytes(byArray);
        sshPacket1.putBytes(byArray13);
        sshPacket1.putInt32(n);
        this.sendPacket1(sshPacket1);
        this.crypto = new SshCrypto(this.cipher_type, byArray11);
        return null;
    }

    public static byte[] encrypteRSAPkcs1Twice(byte[] byArray, byte[] byArray2, byte[] byArray3, byte[] byArray4, byte[] byArray5) {
        int n;
        int n2;
        int n3 = 0;
        byte[] byArray6 = new byte[byArray3.length];
        byArray6[0] = 0;
        byArray6[1] = 2;
        n3 = 2;
        for (n2 = 2; n2 < byArray6.length - byArray.length - 1; ++n2) {
            byArray6[n3++] = SshIO.getNotZeroRandomByte();
        }
        byArray6[n3++] = 0;
        for (n2 = 0; n2 < byArray.length; ++n2) {
            byArray6[n3++] = byArray[n2];
        }
        BigInteger bigInteger = new BigInteger(byArray3);
        BigInteger bigInteger2 = new BigInteger(byArray2);
        BigInteger bigInteger3 = new BigInteger(byArray6);
        bigInteger3 = bigInteger3.modPow(bigInteger2, bigInteger);
        byte[] byArray7 = bigInteger3.toByteArray();
        byte[] byArray8 = new byte[byArray3.length];
        int n4 = 0;
        while (byArray7[n4] == 0) {
            ++n4;
        }
        for (n = byArray8.length - byArray7.length + n4; n < byArray8.length; ++n) {
            byArray8[n] = byArray7[n4++];
        }
        byArray = byArray8;
        n3 = 0;
        byArray6 = new byte[byArray5.length];
        byArray6[0] = 0;
        byArray6[1] = 2;
        n3 = 2;
        for (n = 2; n < byArray6.length - byArray.length - 1; ++n) {
            byArray6[n3++] = SshIO.getNotZeroRandomByte();
        }
        byArray6[n3++] = 0;
        for (n = 0; n < byArray.length; ++n) {
            byArray6[n3++] = byArray[n];
        }
        bigInteger = new BigInteger(byArray5);
        bigInteger2 = new BigInteger(byArray4);
        bigInteger3 = new BigInteger(byArray6);
        bigInteger3 = bigInteger3.modPow(bigInteger2, bigInteger);
        byArray7 = bigInteger3.toByteArray();
        byArray8 = new byte[byArray5.length];
        n4 = 0;
        while (byArray7[n4] == 0) {
            ++n4;
        }
        for (n = byArray8.length - byArray7.length + n4; n < byArray8.length; ++n) {
            byArray8[n] = byArray7[n4++];
        }
        byte[] byArray9 = new byte[byArray5.length + 2];
        byArray9[1] = (byte)(8 * byArray5.length & 0xFF);
        byArray9[0] = (byte)(8 * byArray5.length >> 8 & 0xFF);
        for (int i = 0; i < byArray5.length; ++i) {
            byArray9[i + 2] = byArray8[i];
        }
        return byArray9;
    }

    public static byte[] addArrayOfBytes(byte[] byArray, byte[] byArray2) {
        int n;
        if (byArray == null) {
            return byArray2;
        }
        if (byArray2 == null) {
            return byArray;
        }
        byte[] byArray3 = new byte[byArray.length + byArray2.length];
        for (n = 0; n < byArray.length; ++n) {
            byArray3[n] = byArray[n];
        }
        for (n = 0; n < byArray2.length; ++n) {
            byArray3[n + byArray.length] = byArray2[n];
        }
        return byArray3;
    }

    public static byte[] XORArrayOfBytes(byte[] byArray, byte[] byArray2) {
        if (byArray == null) {
            return null;
        }
        if (byArray2 == null) {
            return null;
        }
        if (byArray.length != byArray2.length) {
            return null;
        }
        byte[] byArray3 = new byte[byArray.length];
        for (int i = 0; i < byArray3.length; ++i) {
            byArray3[i] = (byte)((byArray[i] & 0xFF ^ byArray2[i] & 0xFF) & 0xFF);
        }
        return byArray3;
    }

    private boolean hasCipher(String string) {
        return Cipher.getInstance(string) != null;
    }

    private String Send_SSH_CMSG_USER() throws IOException {
        SshPacket1 sshPacket1 = new SshPacket1(4);
        sshPacket1.putString(this.login);
        this.sendPacket1(sshPacket1);
        return "";
    }

    private String Send_SSH_CMSG_AUTH_PASSWORD() throws IOException {
        SshPacket1 sshPacket1 = new SshPacket1(9);
        sshPacket1.putString(this.password);
        this.sendPacket1(sshPacket1);
        return "";
    }

    private String Send_SSH_CMSG_EXEC_SHELL() throws IOException {
        SshPacket1 sshPacket1 = new SshPacket1(12);
        this.sendPacket1(sshPacket1);
        return "";
    }

    private String Send_SSH_CMSG_STDIN_DATA(String string) throws IOException {
        SshPacket1 sshPacket1 = new SshPacket1(16);
        sshPacket1.putString(string);
        this.sendPacket1(sshPacket1);
        return "";
    }

    private String Send_SSH_CMSG_REQUEST_PTY() throws IOException {
        SshPacket1 sshPacket1 = new SshPacket1(10);
        sshPacket1.putString(this.getTerminalID());
        sshPacket1.putInt32(this.getTerminalHeight());
        sshPacket1.putInt32(this.getTerminalWidth());
        sshPacket1.putInt32(0);
        sshPacket1.putInt32(0);
        sshPacket1.putByte((byte)0);
        this.sendPacket1(sshPacket1);
        return "";
    }

    private String Send_SSH_CMSG_EXIT_CONFIRMATION() throws IOException {
        SshPacket1 sshPacket1 = new SshPacket1(33);
        this.sendPacket1(sshPacket1);
        return "";
    }

    public String Send_SSH_NOOP() throws IOException {
        SshPacket sshPacket;
        if (this.useprotocol == 1) {
            sshPacket = new SshPacket1(32);
            this.sendPacket1((SshPacket1)sshPacket);
        }
        if (this.useprotocol == 2) {
            sshPacket = new SshPacket2(2);
            sshPacket.putString("");
            this.sendPacket2((SshPacket2)sshPacket);
        }
        return "";
    }

    protected String getTerminalID() {
        return this.sshSession.getTerminalID();
    }

    protected int getTerminalHeight() {
        return this.sshSession.getTerminalHeight();
    }

    protected int getTerminalWidth() {
        return this.sshSession.getTerminalWidth();
    }

    public static byte getNotZeroRandomByte() {
        Date date = new Date();
        String string = String.valueOf(rnd.nextLong() * date.getTime());
        byte[] byArray = md5.digest(string.getBytes());
        for (int i = 0; i < 20; ++i) {
            byte by = 0;
            if (i < byArray.length) {
                by = byArray[i];
            }
            if (by == 0) continue;
            return by;
        }
        return SshIO.getNotZeroRandomByte();
    }
}

