/*
 * Decompiled with CFR 0.152.
 */
package ssh.v2;

import java.util.Random;
import ssh.v2.BigInteger;
import ssh.v2.SHA1Digest;
import ssh.v2.SshPacket2;

public class DHKeyExchange {
    public static final String SSH_DSS = "ssh-dss";
    public static final BigInteger g = new BigInteger("2", 16);
    public static final BigInteger p = new BigInteger("ffffffffffffffffc90fdaa22168c234c4c6628b80dc1cd129024e088a67cc74020bbea63b139b22514a08798e3404ddef9519b3cd3a431b302b0a6df25f14374fe1356d6d51c245e485b576625e7ec6f44c42e9a637ed6b0bff5cb6f406b7edee386bfb5a899fa5ae9f24117c4b1fe649286651ece65381ffffffffffffffff", 16);
    public byte[] V_S;
    public byte[] V_C;
    public byte[] I_S;
    public byte[] I_C;
    public byte[] H;
    private byte[] e;
    public byte[] K;
    private BigInteger x;
    private BigInteger y;
    public String keyalg;

    public DHKeyExchange(int n) {
        BigInteger[] bigIntegerArray = DHKeyExchange.generateKeyPair(n);
        this.x = bigIntegerArray[0];
        this.y = bigIntegerArray[1];
    }

    public DHKeyExchange(byte[] byArray, byte[] byArray2) {
        this.x = new BigInteger(byArray);
        this.y = new BigInteger(byArray2);
    }

    public byte[] getE() {
        if (this.e == null) {
            this.e = this.y.toByteArray();
        }
        return this.e;
    }

    public static BigInteger[] generateKeyPair(int n) {
        n = Math.min(n, p.bitLength() - 1 - 1);
        BigInteger bigInteger = new BigInteger(n, new Random());
        BigInteger bigInteger2 = g.modPow(bigInteger, p);
        return new BigInteger[]{bigInteger, bigInteger2};
    }

    public static byte[][] generateKeyPairBytes(int n) {
        BigInteger[] bigIntegerArray = DHKeyExchange.generateKeyPair(n);
        return new byte[][]{bigIntegerArray[0].toByteArray(), bigIntegerArray[1].toByteArray()};
    }

    public boolean next(byte[] byArray, byte[] byArray2, byte[] byArray3) {
        boolean bl;
        this.K = new BigInteger(byArray2).modPow(this.x, p).toByteArray();
        SshPacket2 sshPacket2 = new SshPacket2();
        sshPacket2.putString(this.V_C);
        sshPacket2.putString(this.V_S);
        sshPacket2.putString(this.I_C);
        sshPacket2.putString(this.I_S);
        sshPacket2.putString(byArray);
        sshPacket2.putMpInt(this.e);
        sshPacket2.putMpInt(byArray2);
        sshPacket2.putMpInt(this.K);
        byte[] byArray4 = sshPacket2.getData();
        SHA1Digest sHA1Digest = new SHA1Digest();
        sHA1Digest.update(byArray4, 0, byArray4.length);
        this.H = new byte[sHA1Digest.getDigestSize()];
        sHA1Digest.doFinal(this.H, 0);
        SshPacket2 sshPacket22 = new SshPacket2(null);
        sshPacket22.putBytes(byArray);
        this.keyalg = sshPacket22.getString();
        if (this.keyalg.equals(SSH_DSS)) {
            byte[] byArray5 = sshPacket22.getByteString();
            byte[] byArray6 = sshPacket22.getByteString();
            byte[] byArray7 = sshPacket22.getByteString();
            byte[] byArray8 = sshPacket22.getByteString();
            bl = DHKeyExchange.verifyDSASignature(this.H, byArray3, new BigInteger(byArray8), new BigInteger(byArray5), new BigInteger(byArray6), new BigInteger(byArray7));
        } else {
            bl = false;
        }
        return bl;
    }

    public static boolean verifyDSASignature(byte[] byArray, byte[] byArray2, BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3, BigInteger bigInteger4) {
        SshPacket2 sshPacket2 = new SshPacket2();
        sshPacket2.putBytes(byArray2);
        sshPacket2.getByteString();
        byte[] byArray3 = sshPacket2.getByteString();
        int n = byArray3.length / 2;
        byte[] byArray4 = new byte[n];
        byArray4[0] = 0;
        System.arraycopy(byArray3, 0, byArray4, 0, n);
        BigInteger bigInteger5 = new BigInteger(1, byArray4);
        System.arraycopy(byArray3, n, byArray4, 0, n);
        BigInteger bigInteger6 = new BigInteger(1, byArray4);
        SHA1Digest sHA1Digest = new SHA1Digest();
        sHA1Digest.update(byArray, 0, byArray.length);
        byte[] byArray5 = new byte[sHA1Digest.getDigestSize()];
        sHA1Digest.doFinal(byArray5, 0);
        byArray = byArray5;
        BigInteger bigInteger7 = new BigInteger(1, byArray);
        BigInteger bigInteger8 = BigInteger.valueOf(0L);
        if (bigInteger8.compareTo(bigInteger5) >= 0 || bigInteger3.compareTo(bigInteger5) <= 0) {
            return false;
        }
        if (bigInteger8.compareTo(bigInteger6) >= 0 || bigInteger3.compareTo(bigInteger6) <= 0) {
            return false;
        }
        BigInteger bigInteger9 = bigInteger6.modInverse(bigInteger3);
        BigInteger bigInteger10 = bigInteger7.multiply(bigInteger9).mod(bigInteger3);
        BigInteger bigInteger11 = bigInteger5.multiply(bigInteger9).mod(bigInteger3);
        bigInteger10 = bigInteger4.modPow(bigInteger10, bigInteger2);
        bigInteger11 = bigInteger.modPow(bigInteger11, bigInteger2);
        BigInteger bigInteger12 = bigInteger10.multiply(bigInteger11).mod(bigInteger2).mod(bigInteger3);
        return bigInteger12.equals(bigInteger5);
    }
}

