/*
 * Decompiled with CFR 0.152.
 */
package ssh.v2;

import ssh.v2.SHA1Digest;

public class HMACSHA1 {
    private String name = "hmac-sha1";
    private int bsize = 20;
    private byte[] tmp = new byte[4];
    private static final int BLOCK_LENGTH = 64;
    private static final byte IPAD = 54;
    private static final byte OPAD = 92;
    private SHA1Digest digest;
    private int digestSize;
    private byte[] inputPad = new byte[64];
    private byte[] outputPad = new byte[64];

    public int getBlockSize() {
        return this.bsize;
    }

    public void init(byte[] byArray) {
        int n;
        if (byArray.length > this.bsize) {
            byte[] byArray2 = new byte[this.bsize];
            System.arraycopy(byArray, 0, byArray2, 0, this.bsize);
            byArray = byArray2;
        }
        this.digest = new SHA1Digest();
        this.digestSize = this.digest.getDigestSize();
        this.digest.reset();
        if (byArray.length > 64) {
            this.digest.update(byArray, 0, byArray.length);
            this.digest.doFinal(this.inputPad, 0);
            for (n = this.digestSize; n < this.inputPad.length; ++n) {
                this.inputPad[n] = 0;
            }
        } else {
            System.arraycopy(byArray, 0, this.inputPad, 0, byArray.length);
            for (n = byArray.length; n < this.inputPad.length; ++n) {
                this.inputPad[n] = 0;
            }
        }
        this.outputPad = new byte[this.inputPad.length];
        System.arraycopy(this.inputPad, 0, this.outputPad, 0, this.inputPad.length);
        n = 0;
        while (n < this.inputPad.length) {
            int n2 = n++;
            this.inputPad[n2] = (byte)(this.inputPad[n2] ^ 0x36);
        }
        n = 0;
        while (n < this.outputPad.length) {
            int n3 = n++;
            this.outputPad[n3] = (byte)(this.outputPad[n3] ^ 0x5C);
        }
        this.digest.update(this.inputPad, 0, this.inputPad.length);
    }

    public void update(int n) {
        this.tmp[0] = (byte)(n >>> 24);
        this.tmp[1] = (byte)(n >>> 16);
        this.tmp[2] = (byte)(n >>> 8);
        this.tmp[3] = (byte)n;
        this.update(this.tmp, 0, 4);
    }

    public void update(byte[] byArray, int n, int n2) {
        this.digest.update(byArray, n, n2);
    }

    public byte[] doFinal() {
        byte[] byArray = new byte[this.digestSize];
        byte[] byArray2 = new byte[this.digestSize];
        this.digest.doFinal(byArray2, 0);
        this.digest.update(this.outputPad, 0, this.outputPad.length);
        this.digest.update(byArray2, 0, byArray2.length);
        this.digest.doFinal(byArray, 0);
        this.reset();
        return byArray;
    }

    public void reset() {
        this.digest.reset();
        this.digest.update(this.inputPad, 0, this.inputPad.length);
    }

    public String getName() {
        return this.name;
    }
}

