/*
 * Decompiled with CFR 0.152.
 */
package terminal;

import app.Settings;
import app.session.Session;
import gui.Activatable;
import gui.MainMenu;
import gui.session.SpecialMenu;
import java.io.InputStream;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.TextBox;
import terminal.LCDFont;
import terminal.VT320;

public class Terminal
extends Canvas
implements Activatable,
CommandListener {
    private static final int MODE_DISCONNECTED = 0;
    private static final int MODE_CONNECTED = 1;
    private static final int MODE_CURSOR = 2;
    private static final int MODE_SCROLL = 3;
    private static final int MODE_TYPING = 4;
    private static int commandPriority = 1;
    private static final Command textEnterCommand = new Command("Enter", 4, commandPriority++);
    private static final Command textTypeCommand = new Command("Type", 4, commandPriority++);
    private static final Command backMainCommand = new Command("Back", 8, commandPriority++);
    private static final Command textInputCommand = new Command("Input", 8, commandPriority++);
    private static final Command typeCommand = new Command("Type", 8, commandPriority++);
    private static final Command macrosCommand = new Command("Macros", 8, commandPriority++);
    private static final Command tabCommand = new Command("TAB", 8, commandPriority++);
    private static final Command spaceCommand = new Command("SPACE", 8, commandPriority++);
    private static final Command enterCommand = new Command("ENTER", 8, commandPriority++);
    private static final Command escCommand = new Command("ESC", 8, commandPriority++);
    private static final Command ctrlCommand = new Command("CTRL", 8, commandPriority++);
    private static final Command altCommand = new Command("ALT", 8, commandPriority++);
    private static final Command shiftCommand = new Command("SHIFT", 8, commandPriority++);
    private static final Command specialCommand = new Command("Special", 8, commandPriority++);
    private static final Command cursorCommand = new Command("Cursor", 8, commandPriority++);
    private static final Command scrollCommand = new Command("Scroll", 8, commandPriority++);
    private static final Command backCommand = new Command("Back", 2, commandPriority++);
    private static final Command showBindingsCommand = new Command("Show Key Bindings", 8, commandPriority++);
    private static final Command disconnectCommand = new Command("Disconnect", 8, commandPriority++);
    private static final Command closeCommand = new Command("Close", 6, commandPriority++);
    private static final Command[] commandsDisconnected = new Command[]{closeCommand};
    private static final Command[] commandsConnected = new Command[]{textInputCommand, typeCommand, macrosCommand, tabCommand, spaceCommand, enterCommand, escCommand, ctrlCommand, altCommand, shiftCommand, specialCommand, cursorCommand, scrollCommand, showBindingsCommand, disconnectCommand};
    private static final Command[] commandsCursor = new Command[]{backCommand};
    private static final Command[] commandsTyping = new Command[]{backMainCommand, backCommand, textInputCommand, macrosCommand, tabCommand, spaceCommand, enterCommand, escCommand, ctrlCommand, altCommand, shiftCommand, specialCommand, cursorCommand, scrollCommand, disconnectCommand};
    private static int[] bindingKeys = new int[]{49, 50, 51, 52, 53, 54, 55, 56, 57, 42, 48, 35};
    private Session session;
    private TextBox inputDialog;
    private SpecialMenu menuSpecialKeys;
    private TextBox controlKeyDialog;
    private TextBox altKeyDialog;
    private TextBox shiftKeyDialog;
    private Command[] currentCommands;
    private int mode;
    private StringBuffer commandBuffer = new StringBuffer();
    private static final int KEY_BACKSPACE = -8;
    private static final int KEY_SHIFT = 137;
    private boolean typingShift;
    protected VT320 buffer;
    protected int top;
    protected int left;
    protected int width;
    protected int height;
    private int fontWidth;
    private int fontHeight;
    protected int rotated;
    public int rows;
    public int cols;
    private Image backingStore = null;
    public int fgcolor = 0;
    public int bgcolor = 0xFFFFFF;
    private static final int[] color = new int[]{0, 0xCC0000, 52224, 0xCCCC00, 204, 0xCC00CC, 52428, 0xCCCCCC};
    private static final int[] boldcolor = new int[]{0x333333, 0xFF0000, 65280, 0xFFFF00, 255, 0xFF00FF, 65535, 0xFFFFFF};
    private static final int[] lowcolor = new int[]{0, 0x990000, 39168, 0x999900, 153, 0x990099, 39321, 0x999999};
    private Object paintMutex = new Object();
    private boolean invalid = true;
    private LCDFont lcdfont;
    private int prevfg = -1;
    private int prevbg = -1;
    private int fontMode = Settings.fontMode;
    private Font font;
    private int[][] fontData;
    private static final String FONT_RESOURCE = "/font";

    public Terminal(VT320 vT320, Session session) {
        this.buffer = vT320;
        vT320.setDisplay(this);
        if (MainMenu.useColors) {
            this.fgcolor = color[7];
            this.bgcolor = color[0];
        }
        this.rotated = 0;
        this.initFont();
        this.top = 0;
        this.left = 0;
        this.session = session;
        this.changeMode(0);
        this.setCommandListener(this);
        if (MainMenu.useColors) {
            this.bgcolor = Settings.bgcolor;
            if (Settings.fgcolor != 0xFFFFFF) {
                this.fgcolor = Settings.fgcolor;
            }
        }
        this.sizeChanged();
    }

    protected void sizeChanged() {
        this.width = this.getWidth();
        this.height = this.getHeight();
        if (this.rotated != 0) {
            this.width = this.getHeight();
            this.height = this.getWidth();
        }
        this.cols = this.width / this.fontWidth;
        this.rows = this.height / this.fontHeight;
        this.backingStore = Image.createImage((int)this.width, (int)this.height);
        int n = this.cols;
        int n2 = this.rows;
        if (Settings.terminalCols != 0) {
            n = Settings.terminalCols;
        }
        if (Settings.terminalRows != 0) {
            n2 = Settings.terminalRows;
        }
        this.buffer.setScreenSize(n, n2);
    }

    public void connected() {
        this.changeMode(1);
    }

    public void disconnected() {
        this.changeMode(0);
    }

    protected void changeMode(int n) {
        this.mode = n;
        switch (n) {
            case 0: {
                this.changeCurrentCommands(commandsDisconnected);
                break;
            }
            case 1: {
                this.changeCurrentCommands(commandsConnected);
                break;
            }
            case 2: 
            case 3: {
                this.changeCurrentCommands(commandsCursor);
                break;
            }
            case 4: {
                this.changeCurrentCommands(commandsTyping);
            }
        }
    }

    protected void changeCurrentCommands(Command[] commandArray) {
        int n;
        if (this.currentCommands != null) {
            for (n = 0; n < this.currentCommands.length; ++n) {
                this.removeCommand(this.currentCommands[n]);
            }
        }
        for (n = 0; n < commandArray.length; ++n) {
            this.addCommand(commandArray[n]);
        }
        this.currentCommands = commandArray;
    }

    public void activate() {
        MainMenu.setDisplay((Displayable)this);
    }

    public void activate(Activatable activatable) {
        this.activate();
    }

    public void commandAction(Command command, Displayable displayable) {
        if (displayable == this.inputDialog) {
            if (command != backCommand) {
                this.commandBuffer.setLength(0);
                this.commandBuffer.append(this.inputDialog.getString());
                if (command == textEnterCommand) {
                    this.commandBuffer.append('\n');
                }
                if (command == tabCommand) {
                    this.commandBuffer.append('\t');
                }
                this.session.typeString(this.commandBuffer.toString());
                this.inputDialog.setString("");
            }
            this.activate();
        } else if (displayable == this.controlKeyDialog) {
            this.handleModifierDialog(command, this.controlKeyDialog, 1);
        } else if (displayable == this.altKeyDialog) {
            this.handleModifierDialog(command, this.altKeyDialog, 4);
        } else if (displayable == this.shiftKeyDialog) {
            this.handleModifierDialog(command, this.shiftKeyDialog, 2);
        } else if (displayable != this) {
            this.activate();
        } else if (command == disconnectCommand || command == closeCommand) {
            this.doDisconnect();
        } else if (command == textInputCommand) {
            this.doTextInput(null);
        } else if (command == macrosCommand) {
            MainMenu.doMacros(this);
        } else if (command == tabCommand) {
            this.buffer.keyTyped(0, '\t', 0);
        } else if (command == spaceCommand) {
            this.buffer.keyTyped(0, ' ', 0);
        } else if (command == enterCommand) {
            this.buffer.keyTyped(0, '\n', 0);
        } else if (command == escCommand) {
            this.buffer.keyTyped(0, '\u001b', 0);
        } else if (command == ctrlCommand) {
            this.doControlKeyInput();
        } else if (command == altCommand) {
            this.doAltKeyInput();
        } else if (command == shiftCommand) {
            this.doShiftKeyInput();
        } else if (command == cursorCommand) {
            this.doCursor();
        } else if (command == scrollCommand) {
            this.doScroll();
        } else if (command == typeCommand) {
            this.doTyping();
        } else if (command == specialCommand) {
            if (this.menuSpecialKeys == null) {
                this.menuSpecialKeys = new SpecialMenu();
            }
            this.menuSpecialKeys.activate(this);
        } else if (command == backCommand || command == backMainCommand) {
            this.changeMode(1);
        } else if (command == showBindingsCommand) {
            this.doShowBindings();
        }
    }

    private void handleModifierDialog(Command command, TextBox textBox, int n) {
        if (command != backCommand) {
            String string = textBox.getString();
            for (int i = 0; i < string.length(); ++i) {
                this.session.typeChar(string.charAt(i), n);
            }
            textBox.setString("");
        }
        this.activate();
    }

    protected void keyPressed(int n) {
        switch (this.mode) {
            case 1: {
                this.keyPressedConnected(n);
                break;
            }
            case 2: {
                this.keyPressedCursor(n);
                break;
            }
            case 3: {
                this.keyPressedScroll(n);
                break;
            }
            case 4: {
                this.keyPressedTyping(n);
            }
        }
    }

    protected void keyReleased(int n) {
        switch (this.mode) {
            case 1: {
                this.keyReleasedConnected(n);
                break;
            }
            case 4: {
                this.keyReleasedTyping(n);
            }
        }
    }

    protected void keyRepeated(int n) {
        switch (this.mode) {
            case 2: {
                this.keyPressedCursor(n);
                break;
            }
            case 3: {
                this.keyPressedScroll(n);
            }
        }
    }

    protected boolean handleGameAction(int n) {
        int n2 = this.getGameAction(n);
        if (n2 != 0) {
            switch (n2) {
                case 1: {
                    this.buffer.keyPressed(38, 8);
                    return true;
                }
                case 6: {
                    this.buffer.keyPressed(40, 8);
                    return true;
                }
                case 2: {
                    this.buffer.keyPressed(37, 8);
                    return true;
                }
                case 5: {
                    this.buffer.keyPressed(39, 8);
                    return true;
                }
            }
        }
        return false;
    }

    protected void keyPressedConnected(int n) {
        boolean bl = false;
        for (int i = 0; i < bindingKeys.length; ++i) {
            if (bindingKeys[i] != n) continue;
            bl = true;
        }
        if (n == -8) {
            bl = true;
        }
        if (!bl && this.handleGameAction(n)) {
            return;
        }
    }

    protected void keyReleasedConnected(int n) {
        int n2 = -1;
        for (int i = 0; i < bindingKeys.length; ++i) {
            if (bindingKeys[i] != n) continue;
            n2 = i;
            break;
        }
        if (n2 >= 0 && n2 < commandsConnected.length) {
            this.commandAction(commandsConnected[n2], (Displayable)this);
        } else if (n == -8) {
            this.buffer.keyPressed(8, 0);
        }
    }

    protected void keyPressedTyping(int n) {
        if (n == 137) {
            this.typingShift = true;
        }
        if (n != 8 && n != -8 && n != 10 && n != 13 && n != 137 && (n < 32 || n >= 128) && this.handleGameAction(n)) {
            return;
        }
    }

    protected void keyReleasedTyping(int n) {
        if (n == 8 || n == -8) {
            this.buffer.keyPressed(8, 0);
        } else if (n == 10 || n == 13) {
            this.buffer.keyTyped(0, '\n', 0);
        } else if (n == 137) {
            this.typingShift = false;
        } else if (n > 0 && n < 32) {
            this.buffer.keyTyped(n, (char)n, 0);
        } else if (n >= 32 && n < 128) {
            char c = (char)n;
            if (this.typingShift) {
                c = this.shiftChar(c);
            }
            this.buffer.keyTyped(0, c, 0);
        }
    }

    private char shiftChar(char c) {
        if (c >= 'a' && c <= 'z') {
            return (char)(c - 97 + 65);
        }
        switch (c) {
            case '0': {
                return ')';
            }
            case '1': {
                return '!';
            }
            case '2': {
                return '@';
            }
            case '3': {
                return '#';
            }
            case '4': {
                return '$';
            }
            case '5': {
                return '%';
            }
            case '6': {
                return '^';
            }
            case '7': {
                return '&';
            }
            case '8': {
                return '*';
            }
            case '9': {
                return '(';
            }
        }
        return c;
    }

    private int gameKeysToNumeric(int n) {
        int n2 = this.getGameAction(n);
        switch (n2) {
            case 1: {
                n = 50;
                break;
            }
            case 6: {
                n = 56;
                break;
            }
            case 2: {
                n = 52;
                break;
            }
            case 5: {
                n = 54;
            }
        }
        return n;
    }

    protected void keyPressedCursor(int n) {
        n = this.gameKeysToNumeric(n);
        switch (n) {
            case 50: {
                this.buffer.keyPressed(38, 8);
                break;
            }
            case 48: 
            case 56: {
                this.buffer.keyPressed(40, 8);
                break;
            }
            case 52: {
                this.buffer.keyPressed(37, 8);
                break;
            }
            case 54: {
                this.buffer.keyPressed(39, 8);
                break;
            }
            case 49: {
                this.keyPressedCursor(1);
                this.keyPressedCursor(2);
                break;
            }
            case 51: {
                this.keyPressedCursor(1);
                this.keyPressedCursor(5);
                break;
            }
            case 42: 
            case 55: {
                this.keyPressedCursor(6);
                this.keyPressedCursor(2);
                break;
            }
            case 35: 
            case 57: {
                this.keyPressedCursor(6);
                this.keyPressedCursor(5);
            }
        }
    }

    protected void keyPressedScroll(int n) {
        n = this.gameKeysToNumeric(n);
        switch (n) {
            case 50: {
                if (this.top > 0) {
                    --this.top;
                }
                this.redraw();
                break;
            }
            case 48: 
            case 56: {
                if (this.top + this.rows < this.buffer.height) {
                    ++this.top;
                }
                this.redraw();
                break;
            }
            case 52: {
                if (this.left > 0) {
                    --this.left;
                }
                this.redraw();
                break;
            }
            case 54: {
                if (this.left + this.cols < this.buffer.width) {
                    ++this.left;
                }
                this.redraw();
                break;
            }
            case 49: {
                this.keyPressedScroll(1);
                this.keyPressedScroll(2);
                break;
            }
            case 51: {
                this.keyPressedScroll(1);
                this.keyPressedScroll(5);
                break;
            }
            case 42: 
            case 55: {
                this.keyPressedScroll(6);
                this.keyPressedScroll(2);
                break;
            }
            case 35: 
            case 57: {
                this.keyPressedScroll(6);
                this.keyPressedScroll(5);
            }
        }
    }

    private void doDisconnect() {
        this.session.disconnect();
        this.session.goMainMenu();
    }

    public void doTextInput(String string) {
        if (this.inputDialog == null) {
            this.inputDialog = new TextBox("Input", "", 255, 0);
            this.inputDialog.addCommand(textEnterCommand);
            this.inputDialog.addCommand(typeCommand);
            this.inputDialog.addCommand(tabCommand);
            this.inputDialog.addCommand(backCommand);
            this.inputDialog.setCommandListener((CommandListener)this);
        }
        if (string != null) {
            this.inputDialog.setString(string);
        }
        MainMenu.setDisplay((Displayable)this.inputDialog);
    }

    private TextBox makeModifierInputDialog(String string) {
        TextBox textBox = new TextBox(string, "", 10, 0);
        textBox.addCommand(textTypeCommand);
        textBox.addCommand(backCommand);
        textBox.setCommandListener((CommandListener)this);
        return textBox;
    }

    private void doControlKeyInput() {
        if (this.controlKeyDialog == null) {
            this.controlKeyDialog = this.makeModifierInputDialog("CTRL");
        }
        MainMenu.setDisplay((Displayable)this.controlKeyDialog);
    }

    private void doAltKeyInput() {
        if (this.altKeyDialog == null) {
            this.altKeyDialog = this.makeModifierInputDialog("ALT");
        }
        MainMenu.setDisplay((Displayable)this.altKeyDialog);
    }

    private void doShiftKeyInput() {
        if (this.shiftKeyDialog == null) {
            this.shiftKeyDialog = this.makeModifierInputDialog("SHIFT");
        }
        MainMenu.setDisplay((Displayable)this.shiftKeyDialog);
    }

    public void doCursor() {
        this.changeMode(2);
    }

    public void doScroll() {
        this.changeMode(3);
    }

    public void doTyping() {
        this.changeMode(4);
    }

    private void doShowBindings() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.currentCommands != null) {
            for (int i = 0; i < bindingKeys.length && i < this.currentCommands.length; ++i) {
                int n = bindingKeys[i];
                Command command = this.currentCommands[i];
                String string = this.getKeyName(n);
                stringBuffer.append(string);
                stringBuffer.append(": ");
                stringBuffer.append(command.getLabel());
                stringBuffer.append("\n");
            }
        }
        MainMenu.showMessage("Key Bindings", stringBuffer.toString(), this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void paint(Graphics graphics) {
        graphics.setColor(this.bgcolor);
        graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
        Object object = this.paintMutex;
        synchronized (object) {
            this.redrawBackingStore();
            switch (this.rotated) {
                default: 
            }
            Image image = this.backingStore;
            graphics.drawImage(image, 0, 1, 20);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void redraw() {
        Object object = this.paintMutex;
        synchronized (object) {
            this.invalid = true;
            this.repaint();
        }
    }

    protected void redrawBackingStore() {
        if (this.invalid) {
            Graphics graphics = this.backingStore.getGraphics();
            graphics.setColor(this.bgcolor);
            graphics.fillRect(0, 0, this.width, this.height);
            for (int i = this.top; i < this.buffer.height && i < this.top + this.rows; ++i) {
                if (!this.buffer.update[0] && !this.buffer.update[i + 1]) continue;
                this.buffer.update[i + 1] = false;
                for (int j = this.left; j < this.buffer.width && j < this.left + this.cols; ++j) {
                    int n = 0;
                    int n2 = this.buffer.charAttributes[this.buffer.windowBase + i][j];
                    int n3 = this.fgcolor;
                    int n4 = this.bgcolor;
                    if (MainMenu.useColors) {
                        int n5;
                        int n6 = ((n2 & 0xF0) >> 4) - 1;
                        if (n6 >= 0 && n6 < 8) {
                            n3 = (n2 & 1) != 0 ? boldcolor[n6] : ((n2 & 8) != 0 ? lowcolor[n6] : color[n6]);
                        }
                        if ((n5 = ((n2 & 0xF00) >> 8) - 1) >= 0 && n5 < 8) {
                            n4 = color[n5];
                        }
                        if ((n2 & 4) != 0) {
                            int n7 = n4;
                            n4 = n3;
                            n3 = n7;
                        }
                    }
                    while (j + n < this.buffer.width && (this.buffer.charArray[this.buffer.windowBase + i][j + n] < ' ' || this.buffer.charAttributes[this.buffer.windowBase + i][j + n] == n2)) {
                        if (this.buffer.charArray[this.buffer.windowBase + i][j + n] < ' ') {
                            this.buffer.charArray[this.buffer.windowBase + i][j + n] = 32;
                            this.buffer.charAttributes[this.buffer.windowBase + i][j + n] = 0;
                            continue;
                        }
                        ++n;
                    }
                    graphics.setColor(n4);
                    graphics.fillRect((j - this.left) * this.fontWidth, (i - this.top) * this.fontHeight, n * this.fontWidth, this.fontHeight);
                    graphics.setColor(n3);
                    this.drawChars(graphics, n3, n4, this.buffer.charArray[this.buffer.windowBase + i], j, n, (j - this.left) * this.fontWidth, (i - this.top) * this.fontHeight);
                    j += n - 1;
                }
            }
            if (this.buffer.showcursor && this.buffer.screenBase + this.buffer.cursorY >= this.buffer.windowBase && this.buffer.screenBase + this.buffer.cursorY < this.buffer.windowBase + this.buffer.height) {
                graphics.setColor(this.fgcolor);
                graphics.fillRect((this.buffer.cursorX - this.left) * this.fontWidth, (this.buffer.cursorY - this.top + this.buffer.screenBase - this.buffer.windowBase) * this.fontHeight, this.fontWidth, this.fontHeight);
            }
            this.invalid = false;
        }
    }

    private void initFont() {
        switch (this.fontMode) {
            case 0: {
                this.initInternalFont();
                break;
            }
            case 1: {
                this.initSystemFont(8);
            }
        }
    }

    private void initInternalFont() {
        this.fontWidth = 4;
        this.fontHeight = 6;
        this.fontData = new int[128][];
        try {
            InputStream inputStream = this.getClass().getResourceAsStream(FONT_RESOURCE);
            for (int i = 33; i < 128; ++i) {
                int n = inputStream.read();
                int n2 = (n & 3) + 2;
                this.fontData[i] = new int[n2];
                this.fontData[i][0] = (n >> 2) - 32;
                for (int j = 1; j < n2; ++j) {
                    this.fontData[i][j] = inputStream.read();
                }
            }
            inputStream.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void initSystemFont(int n) {
        this.font = Font.getFont((int)32, (int)0, (int)n);
        this.fontHeight = this.font.getHeight();
        this.fontWidth = this.font.charWidth('W');
    }

    protected void drawChars(Graphics graphics, int n, int n2, char[] cArray, int n3, int n4, int n5, int n6) {
        block3: {
            block2: {
                if (this.fontMode != 0) break block2;
                for (int i = n3; i < n3 + n4; ++i) {
                    this.drawChar(graphics, cArray[i], n5, n6);
                    n5 += this.fontWidth;
                }
                break block3;
            }
            if (this.fontMode != 1) break block3;
            graphics.setFont(this.font);
            for (int i = n3; i < n3 + n4; ++i) {
                graphics.drawChar(cArray[i], n5, n6, 20);
                n5 += this.fontWidth;
            }
        }
    }

    private void drawChar(Graphics graphics, char c, int n, int n2) {
        if (c >= this.fontData.length || this.fontData[c] == null) {
            return;
        }
        for (int i = 1; i < this.fontData[c].length; ++i) {
            int n3 = this.fontData[c][i] & 3;
            int n4 = (this.fontData[c][i] & 0xC) >> 2;
            int n5 = (this.fontData[c][i] & 0x30) >> 4;
            int n6 = (this.fontData[c][i] & 0xC0) >> 6;
            if (n3 == 3) {
                n3 = n4;
                n4 = 4;
            }
            if (n5 == 3) {
                n5 = n6;
                n6 = 4;
            }
            graphics.drawLine(n + n3, n2 + n4, n + n5, n2 + n6);
        }
        if (this.fontData[c][0] != 0) {
            this.drawChar(graphics, (char)(c + this.fontData[c][0]), n, n2);
        }
    }
}

