/*
 * ====================================================================
 *
 * License for ISNetworks' MindTerm SCP modifications
 *
 * Copyright (c) 2001 ISNetworks, LLC.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 *
 * 3. The end-user documentation included with the redistribution, if
 *    any, must include an acknowlegement that the software contains
 *    code based on contributions made by ISNetworks, and include
 *    a link to http://www.isnetworks.com/.
 *
 * THIS SOFTWARE IS PROVIDED "AS IS" AND ANY EXPRESSED OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL THE APACHE SOFTWARE FOUNDATION OR
 * ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
 * USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
 * OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 * ====================================================================
 *
 */

/**
* Representation of a file on either the local or remote file systems.
* Knows whether it's a directory as well as its name and path.
*/
package com.isnetworks.ssh;

import java.io.*;
import java.util.*;

public class FileListItem {

    /**
     * Name of the file or directory
     */
    private String mName;

    /**
     * Full path of directory which contains this file
     */
    private String mParent;

    private String separator;
	
    /**
     * Whether this file is a directory
     */
    private boolean mDirectory;

    /**
     * Construct from a file on the local file system
     */
    public FileListItem( File file ) {
	this( file.getName(), file.getParent(), file.isDirectory(), File.separator );
    }

    public FileListItem( String name, String parent, boolean directory,
			 String separator ) {
	mName = name;
	mParent = parent;
	mDirectory = directory;
	this.separator = separator;
	if(!mParent.endsWith(separator)) {
	    mParent += separator;
	}
    }

    /**
     * Get fully qualified name
     */
    public String getAbsolutePath() {
	return mParent + mName;
    }
	
    /**
     * Get name of file relative to its parent directory
     */
    public String getName() {
	return mName;
    }
	
    /**
     * Get full path of directory this file lives in
     */
    public String getParent() {
	return mParent;
    }
	
    public boolean isDirectory() {
	return mDirectory;
    }
	
    /**
     * Used to sort files first by directory/non-directory and then by name
     */
    private boolean earlierThan( FileListItem fileListing ) {
	// Always put parent directory at the top of the list
	if ( mName.equals( ".." ) ) {
	    return true;
	}		
	if ( fileListing.mName.equals( ".." ) ) {
	    return false;
	}
		
	if ( isDirectory() && !fileListing.isDirectory() ) {
	    return true;
	}
	if ( !isDirectory() && fileListing.isDirectory() ) {
	    return false;
	}
		
	return mName.toUpperCase().compareTo( fileListing.mName.toUpperCase() ) < 0;
    }

    /**
     * Simple, inefficient bubble sort for array of FileListItems.
     * Only here because java.util.Arrays class does not exist
     * in Java 1.1 so it wouldn't work in an applet.  Should be
     * acceptable since directories typically contain a relatively
     * small number of files.
     */
    public static void sort( Vector files ) {
	for( int i = 0; i < files.size(); i++ ) {
	    for( int j = i; j < files.size(); j++ ) {
		if ( !((FileListItem)files.elementAt( i )).earlierThan( (FileListItem)files.elementAt( j ) ) ) {
		    FileListItem temp = (FileListItem)files.elementAt( j );
		    files.setElementAt( (FileListItem)files.elementAt( i ), j );
		    files.setElementAt( temp, i );
		}
	    }
	}
    }
}
