/******************************************************************************
 *
 * Copyright (c) 1999-2001 AppGate AB. All Rights Reserved.
 * 
 * This file contains Original Code and/or Modifications of Original Code as
 * defined in and that are subject to the MindTerm Public Source License,
 * Version 1.1, (the 'License'). You may not use this file except in compliance
 * with the License.
 * 
 * You should have received a copy of the MindTerm Public Source License
 * along with this software; see the file LICENSE.  If not, write to
 * AppGate AB, Stora Badhusgatan 18-20, 41121 Goteborg, SWEDEN
 *
 *****************************************************************************/

package com.mindbright.ssh2;

import java.net.Socket;

public class SSH2ConnectionPreferences {

    public static final int DEFAULT_INIT_WINSZ = 32768;
    public static final int DEFAULT_MAX_PKTSZ  = 8192;

    public static final String DEFAULT_X11_LOCALADDR = "127.0.0.1";
    public static final int    DEFAULT_X11_LOCALPORT = 6000;

    private int initWinSz;
    private int maxPktSz;

    private String x11LocalAddr;
    private int    x11LocalPort;
    private byte[] x11Cookie;

    public SSH2ConnectionPreferences() {
	this.initWinSz    = DEFAULT_INIT_WINSZ;
	this.maxPktSz     = DEFAULT_MAX_PKTSZ;
	this.x11LocalAddr = DEFAULT_X11_LOCALADDR;
	this.x11LocalPort = DEFAULT_X11_LOCALPORT;
	this.x11Cookie    = null;
    }

    public void setSocketOptions(int channelType, Socket s) {
	// Do nothing by default, derive this class to change
    }

    public void setRxInitWinSz(int channelType, int initWinSz) {
	this.initWinSz = initWinSz;
    }

    public int getRxInitWinSz(int channelType) {
	return initWinSz;
    }

    public void setRxMaxPktSz(int channelType, int maxPktSz) {
	this.maxPktSz = maxPktSz;
    }

    public int getRxMaxPktSz(int channelType) {
	return maxPktSz;
    }

    public void setX11LocalAddr(String x11LocalAddr) {
	if(x11LocalAddr != null) {
	    this.x11LocalAddr = x11LocalAddr;
	}
    }

    public String getX11LocalAddr() {
	return x11LocalAddr;
    }

    public void setX11LocalPort(int x11LocalPort) {
	if(x11LocalPort > 0) {
	    this.x11LocalPort = x11LocalPort;
	}
    }

    public int getX11LocalPort() {
	return x11LocalPort;
    }

    public void setX11Cookie(byte[] x11Cookie) {
	this.x11Cookie = x11Cookie;
    }

    public byte[] getX11Cookie() {
	return x11Cookie;
    }

}
