/******************************************************************************
 *
 * Copyright (c) 1999-2001 AppGate AB. All Rights Reserved.
 * 
 * This file contains Original Code and/or Modifications of Original Code as
 * defined in and that are subject to the MindTerm Public Source License,
 * Version 1.1, (the 'License'). You may not use this file except in compliance
 * with the License.
 * 
 * You should have received a copy of the MindTerm Public Source License
 * along with this software; see the file LICENSE.  If not, write to
 * AppGate AB, Stora Badhusgatan 18-20, 41121 Goteborg, SWEDEN
 *
 *****************************************************************************/

package com.mindbright.ssh2;

import java.io.InputStream;
import java.io.OutputStream;
import java.io.File;

import com.mindbright.sshcommon.SSHConsoleRemote;

public class SSH2ConsoleRemote implements SSHConsoleRemote {

    protected SSH2Connection     connection;
    protected SSH2SessionChannel session;
    protected OutputStream       stderr;

    public SSH2ConsoleRemote(SSH2Connection connection) {
	this(connection, null);
    }

    public SSH2ConsoleRemote(SSH2Connection connection, OutputStream stderr) {
	this.connection = connection;
	this.stderr     = stderr;
    }

    public boolean command(String command) {
	session = connection.newSession();
	if(stderr != null) {
	    session.changeStdErr(stderr);
	}
	return session.doSingleCommand(command);
    }

    public boolean connect() {
	session = connection.newSession();
	return session.doShell();
    }

    public void close() {
	session.close();
	session = null;
    }

    public void changeStdOut(OutputStream out) {
	session.changeStdOut(out);
    }

    public InputStream getStdOut() {
	return session.getStdOut();
    }

    public OutputStream getStdIn() {
	return session.getStdIn();
    }

}
