/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.common.ui;

import com.sshtools.common.configuration.SshToolsConnectionProfile;
import com.sshtools.common.ui.SessionManager;
import com.sshtools.common.ui.SessionProvider;
import com.sshtools.common.ui.SshToolsApplication;
import com.sshtools.common.ui.SshToolsApplicationException;
import com.sshtools.common.ui.SshToolsApplicationFrame;
import com.sshtools.common.ui.SshToolsApplicationSessionPanel;
import com.sshtools.j2ssh.SftpClient;
import com.sshtools.j2ssh.SshClient;
import com.sshtools.j2ssh.SshEventAdapter;
import com.sshtools.j2ssh.connection.Channel;
import com.sshtools.j2ssh.connection.ChannelFactory;
import com.sshtools.j2ssh.forwarding.ForwardingClient;
import com.sshtools.j2ssh.session.SessionChannelClient;
import java.awt.BorderLayout;
import java.awt.Component;
import java.io.IOException;

public class SessionProviderFrame
extends SshToolsApplicationFrame
implements SessionManager {
    private SshToolsApplicationSessionPanel panel;
    private SessionProvider provider;
    private SshToolsConnectionProfile profile;
    private SshClient ssh;
    private boolean disconnectOnClose = false;

    public SessionProviderFrame(SshToolsConnectionProfile sshToolsConnectionProfile, SshClient sshClient, SessionProvider sessionProvider) throws IOException, SshToolsApplicationException {
        try {
            this.provider = sessionProvider;
            this.ssh = sshClient;
            this.profile = sshToolsConnectionProfile;
            this.setIconImage(sessionProvider.getSmallIcon().getImage());
            this.setTitle(sessionProvider.getName() + " - " + sshClient.getConnectionProperties().getHost());
            this.getContentPane().setLayout(new BorderLayout());
            this.panel = (SshToolsApplicationSessionPanel)sessionProvider.getProviderClass().newInstance();
            this.getContentPane().add((Component)this.panel, "Center");
            return;
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (InstantiationException instantiationException) {
            // empty catch block
        }
        throw new SshToolsApplicationException("Failed to create instance of " + sessionProvider.getProviderClass().getName());
    }

    public boolean initFrame(SshToolsApplication sshToolsApplication) throws IOException, SshToolsApplicationException {
        this.panel.init(sshToolsApplication);
        this.init(sshToolsApplication, this.panel);
        this.pack();
        return this.panel.openSession(this, this.profile);
    }

    public SshToolsApplicationSessionPanel getSessionPanel() {
        return this.panel;
    }

    public int getRemoteEOL() {
        return this.ssh.getRemoteEOL();
    }

    public boolean canExit() {
        return this.panel.canClose();
    }

    public void exit() {
        this.panel.close();
        this.dispose();
    }

    public SessionChannelClient openSession() throws IOException {
        return this.ssh.openSessionChannel();
    }

    public void applyProfileChanges(SshToolsConnectionProfile sshToolsConnectionProfile) {
    }

    public void setDisconnectOnClose(boolean bl) {
        this.disconnectOnClose = bl;
    }

    public SftpClient openSftpClient() throws IOException {
        return this.ssh.openSftpClient();
    }

    public boolean openChannel(Channel channel) throws IOException {
        return this.ssh.openChannel(channel);
    }

    public boolean isConnected() {
        return this.ssh.isConnected();
    }

    public boolean requestDisconnect() {
        return this.disconnectOnClose;
    }

    public ForwardingClient getForwardingClient() {
        return this.ssh.getForwardingClient();
    }

    public byte[] sendGlobalRequest(String string, boolean bl, byte[] byArray) throws IOException {
        return this.ssh.sendGlobalRequest(string, bl, byArray);
    }

    public void addEventHandler(SshEventAdapter sshEventAdapter) {
        this.ssh.addEventHandler(sshEventAdapter);
    }

    public String getServerId() {
        return this.ssh.getServerId();
    }

    public void allowChannelOpen(String string, ChannelFactory channelFactory) throws IOException {
        this.ssh.allowChannelOpen(string, channelFactory);
    }

    public SshToolsConnectionProfile getProfile() {
        return this.profile;
    }
}

