/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.j2ssh.agent;

import com.sshtools.j2ssh.agent.ForwardingNotice;
import com.sshtools.j2ssh.agent.KeyStore;
import com.sshtools.j2ssh.agent.KeyTimeoutException;
import com.sshtools.j2ssh.agent.SshAgentAddKey;
import com.sshtools.j2ssh.agent.SshAgentAlive;
import com.sshtools.j2ssh.agent.SshAgentDeleteAllKeys;
import com.sshtools.j2ssh.agent.SshAgentDeleteKey;
import com.sshtools.j2ssh.agent.SshAgentFailure;
import com.sshtools.j2ssh.agent.SshAgentForwardingNotice;
import com.sshtools.j2ssh.agent.SshAgentKeyList;
import com.sshtools.j2ssh.agent.SshAgentListKeys;
import com.sshtools.j2ssh.agent.SshAgentLock;
import com.sshtools.j2ssh.agent.SshAgentOperationComplete;
import com.sshtools.j2ssh.agent.SshAgentPing;
import com.sshtools.j2ssh.agent.SshAgentPrivateKeyOp;
import com.sshtools.j2ssh.agent.SshAgentRandom;
import com.sshtools.j2ssh.agent.SshAgentRandomData;
import com.sshtools.j2ssh.agent.SshAgentRequestVersion;
import com.sshtools.j2ssh.agent.SshAgentSuccess;
import com.sshtools.j2ssh.agent.SshAgentUnlock;
import com.sshtools.j2ssh.agent.SshAgentVersionResponse;
import com.sshtools.j2ssh.configuration.ConfigurationLoader;
import com.sshtools.j2ssh.io.ByteArrayReader;
import com.sshtools.j2ssh.io.ByteArrayWriter;
import com.sshtools.j2ssh.subsystem.SubsystemMessage;
import com.sshtools.j2ssh.transport.publickey.InvalidSshKeyException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.net.Socket;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SshAgentConnection
implements Runnable {
    private static Log log = LogFactory.getLog(class$com$sshtools$j2ssh$agent$SshAgentConnection == null ? (class$com$sshtools$j2ssh$agent$SshAgentConnection = SshAgentConnection.class$("com.sshtools.j2ssh.agent.SshAgentConnection")) : class$com$sshtools$j2ssh$agent$SshAgentConnection);
    InputStream in;
    OutputStream out;
    KeyStore keystore;
    Thread thread;
    Vector forwardingNodes = new Vector();
    Socket socket;
    static /* synthetic */ Class class$com$sshtools$j2ssh$agent$SshAgentConnection;

    SshAgentConnection(KeyStore keyStore, InputStream inputStream, OutputStream outputStream) {
        this.keystore = keyStore;
        this.in = inputStream;
        this.out = outputStream;
        this.thread = new Thread(this);
        this.thread.start();
    }

    SshAgentConnection(KeyStore keyStore, Socket socket) throws IOException {
        this.keystore = keyStore;
        this.in = socket.getInputStream();
        this.out = socket.getOutputStream();
        this.socket = socket;
        socket.setSoTimeout(5000);
        this.thread = new Thread(this);
        this.thread.start();
    }

    protected void sendAgentSuccess() throws IOException {
        SshAgentSuccess sshAgentSuccess = new SshAgentSuccess();
        this.sendMessage(sshAgentSuccess);
    }

    protected void sendAgentFailure(int n) throws IOException {
        SshAgentFailure sshAgentFailure = new SshAgentFailure(n);
        this.sendMessage(sshAgentFailure);
    }

    protected void sendVersionResponse() throws IOException {
        SshAgentVersionResponse sshAgentVersionResponse = new SshAgentVersionResponse(2);
        this.sendMessage(sshAgentVersionResponse);
    }

    protected void sendAgentKeyList() throws IOException {
        SshAgentKeyList sshAgentKeyList = new SshAgentKeyList(this.keystore.getPublicKeys());
        this.sendMessage(sshAgentKeyList);
    }

    protected void sendOperationComplete(byte[] byArray) throws IOException {
        SshAgentOperationComplete sshAgentOperationComplete = new SshAgentOperationComplete(byArray);
        this.sendMessage(sshAgentOperationComplete);
    }

    protected void sendRandomData(byte[] byArray) throws IOException {
        SshAgentRandomData sshAgentRandomData = new SshAgentRandomData(byArray);
        this.sendMessage(sshAgentRandomData);
    }

    protected void sendAgentAlive(byte[] byArray) throws IOException {
        SshAgentAlive sshAgentAlive = new SshAgentAlive(byArray);
        this.sendMessage(sshAgentAlive);
    }

    protected void sendMessage(SubsystemMessage subsystemMessage) throws IOException {
        log.info("Sending message " + subsystemMessage.getMessageName());
        byte[] byArray = subsystemMessage.toByteArray();
        this.out.write(ByteArrayWriter.encodeInt(byArray.length));
        this.out.write(byArray);
        this.out.flush();
    }

    protected void onForwardingNotice(SshAgentForwardingNotice sshAgentForwardingNotice) {
        this.forwardingNodes.add(new ForwardingNotice(sshAgentForwardingNotice.getRemoteHostname(), sshAgentForwardingNotice.getRemoteIPAddress(), sshAgentForwardingNotice.getRemotePort()));
    }

    protected void onRequestVersion(SshAgentRequestVersion sshAgentRequestVersion) throws IOException {
        this.sendVersionResponse();
    }

    protected void onAddKey(SshAgentAddKey sshAgentAddKey) throws IOException {
        if (this.keystore.addKey(sshAgentAddKey.getPrivateKey(), sshAgentAddKey.getPublicKey(), sshAgentAddKey.getDescription(), sshAgentAddKey.getKeyConstraints())) {
            this.sendAgentSuccess();
        } else {
            this.sendAgentFailure(7);
        }
    }

    protected void onDeleteAllKeys(SshAgentDeleteAllKeys sshAgentDeleteAllKeys) throws IOException {
        this.keystore.deleteAllKeys();
        this.sendAgentSuccess();
    }

    protected void onListKeys(SshAgentListKeys sshAgentListKeys) throws IOException {
        this.sendAgentKeyList();
    }

    protected void onPrivateKeyOp(SshAgentPrivateKeyOp sshAgentPrivateKeyOp) throws IOException {
        try {
            if (sshAgentPrivateKeyOp.getOperation().equals("sign")) {
                this.sendAgentFailure(5);
            } else if (sshAgentPrivateKeyOp.getOperation().equals("hash-and-sign")) {
                byte[] byArray = this.keystore.performHashAndSign(sshAgentPrivateKeyOp.getPublicKey(), this.forwardingNodes, sshAgentPrivateKeyOp.getOperationData());
                this.sendOperationComplete(byArray);
            } else if (sshAgentPrivateKeyOp.getOperation().equals("decrypt")) {
                this.sendAgentFailure(5);
            } else if (sshAgentPrivateKeyOp.getOperation().equals("ssh1-challenge-response")) {
                this.sendAgentFailure(5);
            } else {
                this.sendAgentFailure(8);
            }
        }
        catch (KeyTimeoutException keyTimeoutException) {
            this.sendAgentFailure(1);
        }
        catch (InvalidSshKeyException invalidSshKeyException) {
            this.sendAgentFailure(2);
        }
    }

    protected void onDeleteKey(SshAgentDeleteKey sshAgentDeleteKey) throws IOException {
        if (this.keystore.deleteKey(sshAgentDeleteKey.getPublicKey(), sshAgentDeleteKey.getDescription())) {
            this.sendAgentSuccess();
        } else {
            this.sendAgentFailure(2);
        }
    }

    protected void onLock(SshAgentLock sshAgentLock) throws IOException {
        if (this.keystore.lock(sshAgentLock.getPassword())) {
            this.sendAgentSuccess();
        } else {
            this.sendAgentFailure(6);
        }
    }

    protected void onUnlock(SshAgentUnlock sshAgentUnlock) throws IOException {
        if (this.keystore.unlock(sshAgentUnlock.getPassword())) {
            this.sendAgentSuccess();
        } else {
            this.sendAgentFailure(6);
        }
    }

    protected void onPing(SshAgentPing sshAgentPing) throws IOException {
        this.sendAgentAlive(sshAgentPing.getPadding());
    }

    protected void onRandom(SshAgentRandom sshAgentRandom) throws IOException {
        if (sshAgentRandom.getLength() > 0) {
            byte[] byArray = new byte[sshAgentRandom.getLength()];
            ConfigurationLoader.getRND().nextBytes(byArray);
            this.sendRandomData(byArray);
        } else {
            this.sendAgentFailure(7);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void run() {
        block16: {
            log.info("Starting agent connection thread");
            byte[] byArray = new byte[4];
            boolean bl = true;
            while (bl) {
                int n = 0;
                while (n < byArray.length) {
                    try {
                        int n2 = 0;
                        n2 = this.in.read(byArray, n, byArray.length - n);
                        if (n2 >= 0) {
                            n += n2;
                            continue;
                        }
                        bl = false;
                        break;
                    }
                    catch (InterruptedIOException interruptedIOException) {
                        if (interruptedIOException.bytesTransferred <= 0) continue;
                        n += interruptedIOException.bytesTransferred;
                    }
                }
                if (!bl) continue;
                n = (int)ByteArrayReader.readInt(byArray, 0);
                byte[] byArray2 = new byte[n];
                n = 0;
                while (n < byArray2.length) {
                    try {
                        n += this.in.read(byArray2, n, byArray2.length - n);
                    }
                    catch (InterruptedIOException interruptedIOException) {
                        n += interruptedIOException.bytesTransferred;
                    }
                }
                this.onMessageReceived(byArray2);
            }
            Object var8_10 = null;
            try {
                this.socket.close();
            }
            catch (Exception exception) {}
            break block16;
            {
                catch (IOException iOException) {
                    log.info("The agent connection terminated");
                    Object var8_11 = null;
                    try {
                        this.socket.close();
                    }
                    catch (Exception exception) {}
                }
            }
            catch (Throwable throwable) {
                Object var8_12 = null;
                try {
                    this.socket.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        log.info("Exiting agent connection thread");
    }

    protected void onMessageReceived(byte[] byArray) throws IOException {
        switch (byArray[0] & 0xFF) {
            case 206: {
                log.info("Agent forwarding notice received");
                SshAgentForwardingNotice sshAgentForwardingNotice = new SshAgentForwardingNotice();
                sshAgentForwardingNotice.fromByteArray(byArray);
                this.onForwardingNotice(sshAgentForwardingNotice);
                break;
            }
            case 1: {
                log.info("Agent version request received");
                SshAgentRequestVersion sshAgentRequestVersion = new SshAgentRequestVersion();
                sshAgentRequestVersion.fromByteArray(byArray);
                this.onRequestVersion(sshAgentRequestVersion);
                break;
            }
            case 202: {
                log.info("Adding key to agent");
                SshAgentAddKey sshAgentAddKey = new SshAgentAddKey();
                sshAgentAddKey.fromByteArray(byArray);
                this.onAddKey(sshAgentAddKey);
                break;
            }
            case 203: {
                log.info("Deleting all keys from agent");
                SshAgentDeleteAllKeys sshAgentDeleteAllKeys = new SshAgentDeleteAllKeys();
                sshAgentDeleteAllKeys.fromByteArray(byArray);
                this.onDeleteAllKeys(sshAgentDeleteAllKeys);
                break;
            }
            case 204: {
                log.info("Listing agent keys");
                SshAgentListKeys sshAgentListKeys = new SshAgentListKeys();
                sshAgentListKeys.fromByteArray(byArray);
                this.onListKeys(sshAgentListKeys);
                break;
            }
            case 205: {
                log.info("Performing agent private key operation");
                SshAgentPrivateKeyOp sshAgentPrivateKeyOp = new SshAgentPrivateKeyOp();
                sshAgentPrivateKeyOp.fromByteArray(byArray);
                this.onPrivateKeyOp(sshAgentPrivateKeyOp);
                break;
            }
            case 207: {
                log.info("Deleting key from agent");
                SshAgentDeleteKey sshAgentDeleteKey = new SshAgentDeleteKey();
                sshAgentDeleteKey.fromByteArray(byArray);
                this.onDeleteKey(sshAgentDeleteKey);
                break;
            }
            case 208: {
                log.info("Locking agent");
                SshAgentLock sshAgentLock = new SshAgentLock();
                sshAgentLock.fromByteArray(byArray);
                this.onLock(sshAgentLock);
                break;
            }
            case 209: {
                log.info("Unlocking agent");
                SshAgentUnlock sshAgentUnlock = new SshAgentUnlock();
                sshAgentUnlock.fromByteArray(byArray);
                this.onUnlock(sshAgentUnlock);
                break;
            }
            case 212: {
                log.info("Ping Ping Ping Ping Ping");
                SshAgentPing sshAgentPing = new SshAgentPing();
                sshAgentPing.fromByteArray(byArray);
                this.onPing(sshAgentPing);
                break;
            }
            case 213: {
                log.info("Random message received");
                SshAgentRandom sshAgentRandom = new SshAgentRandom();
                sshAgentRandom.fromByteArray(byArray);
                this.onRandom(sshAgentRandom);
                break;
            }
            default: {
                throw new IOException("Unrecognized message type " + String.valueOf(byArray[0]) + " received");
            }
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

