/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.j2ssh.subsystem;

import com.sshtools.j2ssh.SshThread;
import com.sshtools.j2ssh.io.ByteArrayReader;
import com.sshtools.j2ssh.io.ByteArrayWriter;
import com.sshtools.j2ssh.session.SessionChannelClient;
import com.sshtools.j2ssh.subsystem.SubsystemMessage;
import com.sshtools.j2ssh.subsystem.SubsystemMessageStore;
import com.sshtools.j2ssh.transport.InvalidMessageException;
import com.sshtools.j2ssh.util.StartStopState;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class SubsystemClient
implements Runnable {
    private static Log log = LogFactory.getLog(class$com$sshtools$j2ssh$subsystem$SubsystemClient == null ? (class$com$sshtools$j2ssh$subsystem$SubsystemClient = SubsystemClient.class$("com.sshtools.j2ssh.subsystem.SubsystemClient")) : class$com$sshtools$j2ssh$subsystem$SubsystemClient);
    private InputStream in;
    private OutputStream out;
    private Thread thread;
    private String name;
    private StartStopState state = new StartStopState(2);
    protected SubsystemMessageStore messageStore;
    protected SessionChannelClient session;
    static /* synthetic */ Class class$com$sshtools$j2ssh$subsystem$SubsystemClient;

    public SubsystemClient(String string) {
        this.name = string;
        this.messageStore = new SubsystemMessageStore();
    }

    public SubsystemClient(String string, SubsystemMessageStore subsystemMessageStore) {
        this.name = string;
        this.messageStore = subsystemMessageStore;
    }

    public boolean isClosed() {
        return this.state.getValue() == 2;
    }

    public void setSessionChannel(SessionChannelClient sessionChannelClient) {
        this.session = sessionChannelClient;
        this.in = sessionChannelClient.getInputStream();
        this.out = sessionChannelClient.getOutputStream();
        sessionChannelClient.setName(this.name);
    }

    public SessionChannelClient getSessionChannel() {
        return this.session;
    }

    public boolean start() throws IOException {
        this.thread = new SshThread(this, this.name + " subsystem", true);
        if (this.session == null) {
            throw new IOException("No valid session is attached to the subsystem!");
        }
        if (this.session.getState().getValue() != 2) {
            throw new IOException("The session is not open!");
        }
        this.thread.start();
        return this.onStart();
    }

    protected abstract boolean onStart() throws IOException;

    public String getName() {
        return this.name;
    }

    protected void sendMessage(SubsystemMessage subsystemMessage) throws InvalidMessageException, IOException {
        if (log.isDebugEnabled()) {
            log.debug("Sending " + subsystemMessage.getMessageName() + " subsystem message");
        }
        byte[] byArray = subsystemMessage.toByteArray();
        this.out.write(ByteArrayWriter.encodeInt(byArray.length));
        this.out.write(byArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public void run() {
        block10: {
            var4_1 = new byte[4];
            this.state.setValue(1);
            try {
                if (true) ** GOTO lbl22
                do {
                    if ((var1_2 = this.in.read(var4_1)) > 0) {
                        var2_3 = (int)ByteArrayReader.readInt(var4_1, 0);
                        var5_5 = new byte[var2_3];
                        var3_4 = 0;
                        while (var3_4 < var2_3) {
                            var1_2 = this.in.read(var5_5, var3_4, var5_5.length - var3_4);
                            if (var1_2 > 0) {
                                var3_4 += var1_2;
                                continue;
                            }
                            if (var1_2 == -1) break;
                        }
                        this.messageStore.addMessage(var5_5);
                        var5_5 = null;
                    } else if (var1_2 == -1) break;
lbl22:
                    // 3 sources

                    if (this.state.getValue() != 1) break;
                } while (this.session.getState().getValue() == 2);
                var8_6 = null;
            }
            catch (Throwable var7_10) {
                var8_8 = null;
                this.state.setValue(2);
                throw var7_10;
            }
            this.state.setValue(2);
            {
                break block10;
                catch (IOException var6_9) {
                    SubsystemClient.log.fatal("Subsystem message loop failed!", var6_9);
                    var8_7 = null;
                    this.state.setValue(2);
                }
            }
        }
        this.thread = null;
    }

    public void stop() throws IOException {
        this.state.setValue(2);
        this.in.close();
        this.out.close();
        this.session.close();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

