/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.j2ssh.transport.publickey;

import com.sshtools.j2ssh.io.ByteArrayReader;
import com.sshtools.j2ssh.transport.AlgorithmNotSupportedException;
import com.sshtools.j2ssh.transport.publickey.InvalidSshKeyException;
import com.sshtools.j2ssh.transport.publickey.SshKeyPair;
import com.sshtools.j2ssh.transport.publickey.SshKeyPairFactory;
import com.sshtools.j2ssh.transport.publickey.SshPrivateKey;
import com.sshtools.j2ssh.transport.publickey.SshPrivateKeyFormat;
import com.sshtools.j2ssh.transport.publickey.SshPrivateKeyFormatFactory;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Iterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SshPrivateKeyFile {
    private static Log log = LogFactory.getLog(class$com$sshtools$j2ssh$transport$publickey$SshPrivateKeyFile == null ? (class$com$sshtools$j2ssh$transport$publickey$SshPrivateKeyFile = SshPrivateKeyFile.class$("com.sshtools.j2ssh.transport.publickey.SshPrivateKeyFile")) : class$com$sshtools$j2ssh$transport$publickey$SshPrivateKeyFile);
    private SshPrivateKeyFormat format;
    private byte[] keyblob;
    static /* synthetic */ Class class$com$sshtools$j2ssh$transport$publickey$SshPrivateKeyFile;

    protected SshPrivateKeyFile(byte[] byArray, SshPrivateKeyFormat sshPrivateKeyFormat) {
        this.keyblob = byArray;
        this.format = sshPrivateKeyFormat;
    }

    public byte[] getBytes() {
        return this.keyblob;
    }

    public byte[] getKeyBlob(String string) throws InvalidSshKeyException {
        return this.format.decryptKeyblob(this.keyblob, string);
    }

    public void changePassphrase(String string, String string2) throws InvalidSshKeyException {
        byte[] byArray = this.format.decryptKeyblob(this.keyblob, string);
        this.keyblob = this.format.encryptKeyblob(byArray, string2);
    }

    public static SshPrivateKeyFile parse(byte[] byArray) throws InvalidSshKeyException {
        if (byArray == null) {
            throw new InvalidSshKeyException("Key data is null");
        }
        log.info("Parsing private key file");
        SshPrivateKeyFormat sshPrivateKeyFormat = SshPrivateKeyFormatFactory.newInstance(SshPrivateKeyFormatFactory.getDefaultFormatType());
        boolean bl = sshPrivateKeyFormat.isFormatted(byArray);
        if (!bl) {
            log.info("Private key is not in the default format, attempting parse with other supported formats");
            Iterator iterator = SshPrivateKeyFormatFactory.getSupportedFormats().iterator();
            while (iterator.hasNext() && !bl) {
                String string = (String)iterator.next();
                log.debug("Attempting " + string);
                sshPrivateKeyFormat = SshPrivateKeyFormatFactory.newInstance(string);
                bl = sshPrivateKeyFormat.isFormatted(byArray);
            }
        }
        if (bl) {
            return new SshPrivateKeyFile(byArray, sshPrivateKeyFormat);
        }
        throw new InvalidSshKeyException("The key format is not a supported format");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SshPrivateKeyFile parse(File file) throws InvalidSshKeyException, IOException {
        FileInputStream fileInputStream = new FileInputStream(file);
        byte[] byArray = null;
        try {
            byArray = new byte[fileInputStream.available()];
            fileInputStream.read(byArray);
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            try {
                if (fileInputStream != null) {
                    fileInputStream.close();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw throwable;
        }
        try {
            if (fileInputStream != null) {
                fileInputStream.close();
            }
        }
        catch (IOException iOException) {}
        return SshPrivateKeyFile.parse(byArray);
    }

    public boolean isPassphraseProtected() {
        return this.format.isPassphraseProtected(this.keyblob);
    }

    public static SshPrivateKeyFile create(SshPrivateKey sshPrivateKey, String string, SshPrivateKeyFormat sshPrivateKeyFormat) throws InvalidSshKeyException {
        byte[] byArray = sshPrivateKeyFormat.encryptKeyblob(sshPrivateKey.getEncoded(), string);
        return new SshPrivateKeyFile(byArray, sshPrivateKeyFormat);
    }

    public void setFormat(SshPrivateKeyFormat sshPrivateKeyFormat, String string) throws InvalidSshKeyException {
        byte[] byArray = this.format.decryptKeyblob(this.keyblob, string);
        this.format = sshPrivateKeyFormat;
        this.keyblob = this.format.encryptKeyblob(byArray, string);
    }

    public SshPrivateKeyFormat getFormat() {
        return this.format;
    }

    public SshPrivateKey toPrivateKey(String string) throws InvalidSshKeyException {
        try {
            byte[] byArray = this.format.decryptKeyblob(this.keyblob, string);
            SshKeyPair sshKeyPair = SshKeyPairFactory.newInstance(this.getAlgorithm(byArray));
            return sshKeyPair.decodePrivateKey(byArray);
        }
        catch (AlgorithmNotSupportedException algorithmNotSupportedException) {
            throw new InvalidSshKeyException("The public key algorithm for this private key is not supported");
        }
    }

    public String toString() {
        return new String(this.keyblob);
    }

    private String getAlgorithm(byte[] byArray) {
        return ByteArrayReader.readString(byArray, 0);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

