/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.j2ssh.transport.publickey.dsa;

import com.sshtools.j2ssh.configuration.ConfigurationLoader;
import com.sshtools.j2ssh.transport.publickey.InvalidSshKeyException;
import com.sshtools.j2ssh.transport.publickey.SshKeyPair;
import com.sshtools.j2ssh.transport.publickey.SshPrivateKey;
import com.sshtools.j2ssh.transport.publickey.SshPublicKey;
import com.sshtools.j2ssh.transport.publickey.dsa.SshDssPrivateKey;
import com.sshtools.j2ssh.transport.publickey.dsa.SshDssPublicKey;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.interfaces.DSAPrivateKey;
import java.security.interfaces.DSAPublicKey;

public class SshDssKeyPair
extends SshKeyPair {
    public SshPrivateKey decodePrivateKey(byte[] byArray) throws InvalidSshKeyException {
        return new SshDssPrivateKey(byArray);
    }

    public SshPublicKey decodePublicKey(byte[] byArray) throws InvalidSshKeyException {
        return new SshDssPublicKey(byArray);
    }

    public void generate(int n) {
        try {
            KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance("DSA");
            keyPairGenerator.initialize(n, ConfigurationLoader.getRND());
            KeyPair keyPair = keyPairGenerator.generateKeyPair();
            DSAPrivateKey dSAPrivateKey = (DSAPrivateKey)keyPair.getPrivate();
            DSAPublicKey dSAPublicKey = (DSAPublicKey)keyPair.getPublic();
            this.setPrivateKey(new SshDssPrivateKey(dSAPrivateKey));
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            // empty catch block
        }
    }
}

