/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.j2ssh.transport.publickey.dsa;

import com.sshtools.j2ssh.io.ByteArrayReader;
import com.sshtools.j2ssh.io.ByteArrayWriter;
import com.sshtools.j2ssh.transport.publickey.InvalidSshKeyException;
import com.sshtools.j2ssh.transport.publickey.InvalidSshKeySignatureException;
import com.sshtools.j2ssh.transport.publickey.SshPublicKey;
import com.sshtools.j2ssh.util.SimpleASNWriter;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.Signature;
import java.security.SignatureException;
import java.security.interfaces.DSAPublicKey;
import java.security.spec.DSAPublicKeySpec;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SshDssPublicKey
extends SshPublicKey {
    private static Log log = LogFactory.getLog(class$com$sshtools$j2ssh$transport$publickey$dsa$SshDssPublicKey == null ? (class$com$sshtools$j2ssh$transport$publickey$dsa$SshDssPublicKey = SshDssPublicKey.class$("com.sshtools.j2ssh.transport.publickey.dsa.SshDssPublicKey")) : class$com$sshtools$j2ssh$transport$publickey$dsa$SshDssPublicKey);
    private DSAPublicKey pubkey;
    static /* synthetic */ Class class$com$sshtools$j2ssh$transport$publickey$dsa$SshDssPublicKey;

    public SshDssPublicKey(DSAPublicKey dSAPublicKey) {
        this.pubkey = dSAPublicKey;
    }

    public SshDssPublicKey(byte[] byArray) throws InvalidSshKeyException {
        try {
            ByteArrayReader byteArrayReader = new ByteArrayReader(byArray);
            String string = byteArrayReader.readString();
            if (!string.equals(this.getAlgorithmName())) {
                throw new InvalidSshKeyException();
            }
            BigInteger bigInteger = byteArrayReader.readBigInteger();
            BigInteger bigInteger2 = byteArrayReader.readBigInteger();
            BigInteger bigInteger3 = byteArrayReader.readBigInteger();
            BigInteger bigInteger4 = byteArrayReader.readBigInteger();
            DSAPublicKeySpec dSAPublicKeySpec = new DSAPublicKeySpec(bigInteger4, bigInteger, bigInteger2, bigInteger3);
            KeyFactory keyFactory = KeyFactory.getInstance("DSA");
            this.pubkey = (DSAPublicKey)keyFactory.generatePublic(dSAPublicKeySpec);
        }
        catch (Exception exception) {
            throw new InvalidSshKeyException();
        }
    }

    public String getAlgorithmName() {
        return "ssh-dss";
    }

    public int getBitLength() {
        return this.pubkey.getY().bitLength();
    }

    public byte[] getEncoded() {
        try {
            ByteArrayWriter byteArrayWriter = new ByteArrayWriter();
            byteArrayWriter.writeString(this.getAlgorithmName());
            byteArrayWriter.writeBigInteger(this.pubkey.getParams().getP());
            byteArrayWriter.writeBigInteger(this.pubkey.getParams().getQ());
            byteArrayWriter.writeBigInteger(this.pubkey.getParams().getG());
            byteArrayWriter.writeBigInteger(this.pubkey.getY());
            return byteArrayWriter.toByteArray();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public boolean verifySignature(byte[] byArray, byte[] byArray2) throws InvalidSshKeySignatureException {
        try {
            Object object;
            Object object2;
            Object object3;
            Closeable closeable;
            if (byArray.length != 40) {
                closeable = new ByteArrayReader(byArray);
                object3 = ((ByteArrayReader)closeable).readBinaryString();
                object2 = new String((byte[])object3);
                log.debug("Header is " + (String)object2);
                if (!((String)object2).equals("ssh-dss")) {
                    throw new InvalidSshKeySignatureException();
                }
                byArray = ((ByteArrayReader)closeable).readBinaryString();
            }
            closeable = new ByteArrayOutputStream();
            object3 = new ByteArrayOutputStream();
            object2 = new SimpleASNWriter();
            ((SimpleASNWriter)object2).writeByte(2);
            if ((byArray[0] & 0x80) == 128 && byArray[0] != 0) {
                ((ByteArrayOutputStream)closeable).write(0);
                ((ByteArrayOutputStream)closeable).write(byArray, 0, 20);
            } else {
                ((ByteArrayOutputStream)closeable).write(byArray, 0, 20);
            }
            ((SimpleASNWriter)object2).writeData(((ByteArrayOutputStream)closeable).toByteArray());
            ((SimpleASNWriter)object2).writeByte(2);
            if ((byArray[20] & 0x80) == 128 && byArray[20] != 0) {
                ((ByteArrayOutputStream)object3).write(0);
                ((ByteArrayOutputStream)object3).write(byArray, 20, 20);
            } else {
                ((ByteArrayOutputStream)object3).write(byArray, 20, 20);
            }
            ((SimpleASNWriter)object2).writeData(((ByteArrayOutputStream)object3).toByteArray());
            SimpleASNWriter simpleASNWriter = new SimpleASNWriter();
            simpleASNWriter.writeByte(48);
            simpleASNWriter.writeData(((SimpleASNWriter)object2).toByteArray());
            byte[] byArray3 = simpleASNWriter.toByteArray();
            if (log.isDebugEnabled()) {
                log.debug("Verifying host key signature");
                log.debug("Signature length is " + String.valueOf(byArray.length));
                object = "";
                int n = 0;
                while (n < byArray.length) {
                    object = (String)object + Integer.toHexString(byArray[n] & 0xFF) + " ";
                    ++n;
                }
                log.debug("SSH: " + (String)object);
                object = "";
                int n2 = 0;
                while (n2 < byArray3.length) {
                    object = (String)object + Integer.toHexString(byArray3[n2] & 0xFF) + " ";
                    ++n2;
                }
                log.debug("Encoded: " + (String)object);
            }
            object = Signature.getInstance("SHA1withDSA");
            ((Signature)object).initVerify(this.pubkey);
            ((Signature)object).update(byArray2);
            return ((Signature)object).verify(byArray3);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new InvalidSshKeySignatureException();
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new InvalidSshKeySignatureException();
        }
        catch (IOException iOException) {
            throw new InvalidSshKeySignatureException();
        }
        catch (SignatureException signatureException) {
            throw new InvalidSshKeySignatureException();
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

