/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.shift;

import com.sshtools.j2ssh.SftpClient;
import com.sshtools.j2ssh.sftp.FileAttributes;
import com.sshtools.j2ssh.sftp.SftpFile;
import com.sshtools.shift.ShiftSessionPanel;
import java.io.IOException;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.swing.table.AbstractTableModel;

public class DirectoryListingTableModel
extends AbstractTableModel {
    public static final String FILENAME = "Name";
    public static final String SIZE = "Size";
    public static final String PERMISSIONS = "Rights";
    public static final String MODIFIED = "Modified";
    public static final String OWNER = "Owner";
    public static final String GROUP = "Group";
    List files;
    SftpClient sftp;
    Object lock = new Object();
    ShiftSessionPanel browser;
    String[] columnNames = new String[]{"Name", "Size", "Rights", "Modified", "Owner", "Group"};

    public DirectoryListingTableModel(SftpClient sftpClient) {
        this.sftp = sftpClient;
    }

    public String getCurrentDirectory() throws IOException {
        if (this.sftp != null && !this.sftp.isClosed()) {
            return this.sftp.pwd();
        }
        throw new IOException("The SFTP connection has been closed!");
    }

    public void createFolder(String string) throws IOException {
        if (this.sftp == null || this.sftp.isClosed()) {
            throw new IOException("The SFTP connection has been closed!");
        }
        this.sftp.mkdir(string);
        this.refresh();
    }

    public void removeFile(int n) throws IOException {
        this.sftp.rm(this.getFilename(n));
        this.files.remove(n);
        this.fireTableRowsDeleted(n, n);
    }

    public void removeFile(int[] nArray) throws IOException {
        int n = 0;
        while (n < nArray.length) {
            this.sftp.rm(this.getFilename(nArray[n]), true, true);
            ++n;
        }
        this.refresh();
    }

    public void changeDirectory(String string) throws IOException {
        if (this.sftp == null || this.sftp.isClosed()) {
            throw new IOException("The SFTP connection has been closed!");
        }
        this.sftp.cd(string);
        this.refresh();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isDirectory(int n) {
        Object object = this.lock;
        synchronized (object) {
            if (n > this.files.size()) {
                throw new IndexOutOfBoundsException();
            }
            SftpFile sftpFile = (SftpFile)this.files.get(n);
            boolean bl = sftpFile.isDirectory();
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getFileSize(int n) {
        Object object = this.lock;
        synchronized (object) {
            if (n > this.files.size()) {
                throw new IndexOutOfBoundsException();
            }
            SftpFile sftpFile = (SftpFile)this.files.get(n);
            long l = sftpFile.getAttributes().getSize().longValue();
            return l;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getFilename(int n) {
        Object object = this.lock;
        synchronized (object) {
            if (n > this.files.size()) {
                throw new IndexOutOfBoundsException();
            }
            SftpFile sftpFile = (SftpFile)this.files.get(n);
            String string = sftpFile.getFilename();
            return string;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FileAttributes getFileAttributes(int n) {
        Object object = this.lock;
        synchronized (object) {
            if (n > this.files.size()) {
                throw new IndexOutOfBoundsException();
            }
            SftpFile sftpFile = (SftpFile)this.files.get(n);
            FileAttributes fileAttributes = sftpFile.getAttributes();
            return fileAttributes;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refresh() throws IOException {
        if (this.sftp != null && !this.sftp.isClosed()) {
            Object object = this.lock;
            synchronized (object) {
                if (this.files != null) {
                    this.fireTableRowsDeleted(1, this.files.size());
                    this.files.clear();
                }
                this.files = this.sftp.ls();
                Vector<SftpFile> vector = new Vector<SftpFile>();
                Iterator iterator = this.files.iterator();
                while (iterator.hasNext()) {
                    SftpFile sftpFile = (SftpFile)iterator.next();
                    if (!sftpFile.getFilename().equals(".") && !sftpFile.getFilename().equals("..")) continue;
                    vector.add(sftpFile);
                }
                this.files.removeAll(vector);
                Collections.sort(this.files, new FileComparator());
                this.fireTableRowsInserted(1, this.files.size());
            }
        } else {
            throw new IOException("The SFTP connection has been closed!");
        }
    }

    public int getRowCount() {
        return this.files == null ? 0 : this.files.size();
    }

    public int getColumnCount() {
        return this.columnNames.length;
    }

    public String getColumnName(int n) {
        return this.columnNames[n];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object getValueAt(int n, int n2) {
        Object object = this.lock;
        synchronized (object) {
            SftpFile sftpFile = (SftpFile)this.files.get(n);
            switch (n2) {
                case 0: {
                    return sftpFile.getFilename();
                }
                case 1: {
                    return String.valueOf(sftpFile.getAttributes().getSize());
                }
                case 2: {
                    return sftpFile.getAttributes().getPermissionsString();
                }
                case 3: {
                    return sftpFile.getAttributes().getModTimeString();
                }
                case 4: {
                    return String.valueOf(sftpFile.getAttributes().getUID().longValue());
                }
                case 5: {
                    return String.valueOf(sftpFile.getAttributes().getGID().longValue());
                }
            }
            return "";
        }
    }

    class FileComparator
    implements Comparator {
        FileComparator() {
        }

        public int compare(Object object, Object object2) {
            SftpFile sftpFile = (SftpFile)object;
            SftpFile sftpFile2 = (SftpFile)object2;
            if (sftpFile.isDirectory() && !sftpFile2.isDirectory()) {
                return -1;
            }
            if (sftpFile2.isDirectory() && !sftpFile.isDirectory()) {
                return 1;
            }
            return sftpFile.getFilename().compareTo(sftpFile2.getFilename());
        }
    }
}

