/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.shift;

import com.sshtools.common.ui.SshToolsApplicationPanel;
import com.sshtools.common.ui.UIUtil;
import com.sshtools.j2ssh.DirectoryOperation;
import com.sshtools.j2ssh.FileTransferProgress;
import com.sshtools.j2ssh.SftpClient;
import com.sshtools.j2ssh.TransferCancelledException;
import com.sshtools.j2ssh.sftp.FileAttributes;
import com.sshtools.shift.FileTransferDialog_cancel_actionAdapter;
import com.sshtools.shift.ShiftSessionPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.text.NumberFormat;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.Timer;

public class FileTransferDialog
extends JFrame
implements FileTransferProgress {
    boolean cancelled = false;
    boolean completed = false;
    long lastUpdate = System.currentTimeMillis();
    long bytesTransfered = 0L;
    long currentTime;
    long elaspedTime;
    double transfer;
    long fileSize = 0L;
    long bytesSoFar = 0L;
    long completedTransfers = 0L;
    int filesTransfered = 0;
    long totalBytes;
    JPanel mainPanel = new JPanel();
    JPanel informationPanel = new JPanel();
    JLabel lblEstimatedTime = new JLabel();
    JLabel lblTargetAction = new JLabel();
    JLabel lblTransferRate = new JLabel();
    JLabel lblTimeLeftValue = new JLabel();
    JLabel lblTargetValue = new JLabel();
    JLabel lblPathValue = new JLabel();
    JLabel lblTransferRateValue = new JLabel();
    JLabel lblAction = new JLabel("Saving:");
    JButton btnCancel = new JButton();
    JProgressBar progressbar = new JProgressBar();
    JCheckBox chkClose = new JCheckBox();
    Object lock = new Object();
    NumberFormat formatMb = NumberFormat.getNumberInstance();
    NumberFormat formatKb = NumberFormat.getNumberInstance();
    NumberFormat formatKb1 = NumberFormat.getNumberInstance();
    Timer lblTimeLeftValuer;
    String formattedTotal = "";
    String title;
    List files;
    List dirs;
    SftpClient sftp;
    String source;
    DirectoryOperation op;

    public FileTransferDialog(Frame frame, String string, int n) {
        super("0% Complete - " + string);
        this.setIconImage(ShiftSessionPanel.FILE_BROWSER_ICON.getImage());
        this.title = string;
        try {
            this.jbInit();
            this.pack();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                if (FileTransferDialog.this.cancelled || FileTransferDialog.this.completed) {
                    FileTransferDialog.this.setVisible(false);
                } else if (JOptionPane.showConfirmDialog(FileTransferDialog.this, "Cancel the file operation(s)?", "Close Window", 0, 0) == 0) {
                    FileTransferDialog.this.cancelOperation();
                    FileTransferDialog.this.hide();
                }
            }
        });
    }

    public FileTransferDialog() {
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public synchronized void notifyWaiting() {
        this.notifyAll();
    }

    public synchronized void waitForCompletion() throws InterruptedException {
        while (this.isVisible() && !this.cancelled) {
            this.wait(5000L);
        }
    }

    public synchronized void cancelOperation() {
        this.cancelled = true;
        this.setVisible(false);
        this.notifyAll();
    }

    public void putFiles(SftpClient sftpClient, final File file, final List list) throws IOException {
        this.files = list;
        this.sftp = sftpClient;
        this.totalBytes = 0L;
        this.lblTargetAction.setText("Uploading to:");
        int n = 0;
        while (n < list.size()) {
            File file2 = new File(file, (String)list.get(n));
            this.totalBytes += file2.length();
            ++n;
        }
        this.progressbar.setMaximum((int)this.totalBytes / 1024);
        this.formattedTotal = this.totalBytes / 0x100000L > 0L ? this.formatMb.format((double)this.totalBytes / 1048576.0) + " MB" : this.formatKb.format((double)this.totalBytes / 1024.0) + " KB";
        sftpClient.lcd(file.getAbsolutePath());
        Thread thread = new Thread(new Runnable(){

            public void run() {
                block3: {
                    try {
                        int n = 0;
                        while (n < FileTransferDialog.this.files.size()) {
                            FileTransferDialog.this.setSource(file.getAbsolutePath() + File.separator + list.get(n));
                            FileTransferDialog.this.setTarget(FileTransferDialog.this.sftp.pwd() + "/" + FileTransferDialog.this.files.get(n));
                            FileTransferDialog.this.sftp.put((String)FileTransferDialog.this.files.get(n), FileTransferDialog.this);
                            ++n;
                        }
                        FileTransferDialog.this.notifyWaiting();
                    }
                    catch (IOException iOException) {
                        if (FileTransferDialog.this.cancelled) break block3;
                        SshToolsApplicationPanel.showErrorMessage(FileTransferDialog.this, "The file operation failed!\n" + iOException.getMessage(), "File Transfer", iOException);
                        FileTransferDialog.this.setVisible(false);
                    }
                }
            }
        });
        thread.start();
        this.setVisible(true);
    }

    public void copyLocalDirectory(final SftpClient sftpClient, final List list, final List list2, final String string, final boolean bl, final boolean bl2) throws IOException {
        this.sftp = sftpClient;
        this.dirs = list2;
        this.files = list;
        this.lblTargetAction.setText("Uploading to:");
        this.lblAction.setText(bl2 ? "Synchronizing Directory:" : "Copying Directory:");
        this.lblPathValue.setText("Gathering file information from remote server");
        this.show();
        Thread thread = new Thread(new Runnable(){

            public void run() {
                try {
                    File file;
                    int n = 0;
                    while (n < list.size()) {
                        file = (File)list.get(n);
                        FileTransferDialog.this.totalBytes += file.length();
                        ++n;
                    }
                    FileTransferDialog.this.op = new DirectoryOperation();
                    int n2 = 0;
                    while (n2 < list2.size()) {
                        file = (File)list2.get(n2);
                        FileTransferDialog.this.op.addDirectoryOperation(sftpClient.copyLocalDirectory(file.getAbsolutePath(), string, bl, bl2, false, null), string + (string.endsWith("/") ? "" : "/") + file.getName());
                        ++n2;
                    }
                    FileTransferDialog.this.totalBytes += FileTransferDialog.this.op.getTransferSize();
                    FileTransferDialog.this.progressbar.setMaximum((int)FileTransferDialog.this.totalBytes / 1024);
                    FileTransferDialog.this.formattedTotal = FileTransferDialog.this.totalBytes / 0x100000L > 0L ? FileTransferDialog.this.formatMb.format((double)FileTransferDialog.this.totalBytes / 1048576.0) + " MB" : FileTransferDialog.this.formatKb.format((double)FileTransferDialog.this.totalBytes / 1024.0) + " KB";
                    int n3 = 0;
                    while (n3 < list2.size()) {
                        file = (File)list2.get(n3);
                        FileTransferDialog.this.setSource(file.getAbsolutePath());
                        FileTransferDialog.this.setTarget(string + (string.endsWith("/") ? "" : "/") + file.getName());
                        sftpClient.copyLocalDirectory(file.getAbsolutePath(), string, bl, bl2, true, FileTransferDialog.this);
                        ++n3;
                    }
                    int n4 = 0;
                    while (n4 < list.size()) {
                        file = (File)list.get(n4);
                        FileTransferDialog.this.setSource(file.getAbsolutePath());
                        FileTransferDialog.this.setTarget(string + (string.endsWith("/") ? "" : "/") + file.getName());
                        sftpClient.put(file.getAbsolutePath(), string + (string.endsWith("/") ? "" : "/") + file.getName(), (FileTransferProgress)FileTransferDialog.this);
                        ++n4;
                    }
                    FileTransferDialog.this.notifyWaiting();
                }
                catch (TransferCancelledException transferCancelledException) {
                    FileTransferDialog.this.notifyWaiting();
                }
                catch (IOException iOException) {
                    SshToolsApplicationPanel.showErrorMessage(FileTransferDialog.this, "An error occurred", "Copy Directories", iOException);
                }
            }
        }, "Copying Directory");
        thread.start();
    }

    public void copyRemoteDirectory(final SftpClient sftpClient, final List list, final List list2, final String string, final boolean bl, final boolean bl2) throws IOException {
        this.sftp = sftpClient;
        this.dirs = list;
        this.files = list2;
        this.lblTargetAction.setText("Downloading to:");
        this.lblAction.setText(bl2 ? "Synchronizing Directory:" : "Copying Directory:");
        this.lblPathValue.setText("Gathering file information from remote server");
        this.show();
        Thread thread = new Thread(new Runnable(){

            public void run() {
                try {
                    String string2;
                    int n = 0;
                    while (n < list2.size()) {
                        FileAttributes fileAttributes = sftpClient.stat((String)list2.get(n));
                        FileTransferDialog.this.totalBytes += fileAttributes.getSize().longValue();
                        ++n;
                    }
                    FileTransferDialog.this.op = new DirectoryOperation();
                    int n2 = 0;
                    while (n2 < list.size()) {
                        FileTransferDialog.this.op.addDirectoryOperation(sftpClient.copyRemoteDirectory((String)list.get(n2), string, bl, bl2, false, null), new File(string));
                        ++n2;
                    }
                    FileTransferDialog.this.totalBytes += FileTransferDialog.this.op.getTransferSize();
                    FileTransferDialog.this.progressbar.setMaximum((int)FileTransferDialog.this.totalBytes / 1024);
                    FileTransferDialog.this.formattedTotal = FileTransferDialog.this.totalBytes / 0x100000L > 0L ? FileTransferDialog.this.formatMb.format((double)FileTransferDialog.this.totalBytes / 1048576.0) + " MB" : FileTransferDialog.this.formatKb.format((double)FileTransferDialog.this.totalBytes / 1024.0) + " KB";
                    int n3 = 0;
                    while (n3 < list.size()) {
                        string2 = (String)list.get(n3);
                        FileTransferDialog.this.setSource(FileTransferDialog.this.sftp.pwd() + "/" + string2);
                        FileTransferDialog.this.setTarget(string + File.separator + string2);
                        sftpClient.copyRemoteDirectory(string2, string, bl, bl2, true, FileTransferDialog.this);
                        ++n3;
                    }
                    int n4 = 0;
                    while (n4 < list2.size()) {
                        string2 = (String)list2.get(n4);
                        FileTransferDialog.this.setSource(FileTransferDialog.this.sftp.pwd() + "/" + string2);
                        FileTransferDialog.this.setTarget(string + File.separator + string2);
                        sftpClient.get(string2, FileTransferDialog.this);
                        ++n4;
                    }
                    FileTransferDialog.this.notifyWaiting();
                }
                catch (TransferCancelledException transferCancelledException) {
                    FileTransferDialog.this.notifyWaiting();
                }
                catch (IOException iOException) {
                    SshToolsApplicationPanel.showErrorMessage(FileTransferDialog.this, "An error occurred", "Copy Directories", iOException);
                }
            }
        }, "Copying Directory");
        thread.start();
    }

    public void getRemoteFiles(SftpClient sftpClient, List list, long l) {
        this.files = list;
        this.totalBytes = l;
        this.sftp = sftpClient;
        this.lblTargetAction.setText("Downloading to:");
        this.progressbar.setMaximum((int)l / 1024);
        this.formattedTotal = l / 0x100000L > 0L ? this.formatMb.format((double)l / 1048576.0) + " MB" : this.formatKb.format((double)l / 1024.0) + " KB";
        Thread thread = new Thread(new Runnable(){
            int i;

            public void run() {
                try {
                    this.i = 0;
                    while (this.i < FileTransferDialog.this.files.size()) {
                        File file = new File(FileTransferDialog.this.sftp.lpwd() + File.separator + FileTransferDialog.this.files.get(this.i));
                        if (file.exists()) {
                            int n = JOptionPane.showConfirmDialog(FileTransferDialog.this, "This file already exists are you sure you wish to overwrite?\n\n" + file.getName(), "Confirm File Overwrite", 1);
                            if (n == 1) {
                                if (this.i == FileTransferDialog.this.files.size() - 1) {
                                    FileTransferDialog.this.cancelOperation();
                                } else {
                                    ++this.i;
                                }
                            }
                            if (n == 2) {
                                FileTransferDialog.this.cancelOperation();
                            }
                        }
                        FileTransferDialog.this.setSource(FileTransferDialog.this.sftp.pwd() + "/" + FileTransferDialog.this.files.get(this.i));
                        FileTransferDialog.this.setTarget(FileTransferDialog.this.sftp.lpwd() + File.separator + FileTransferDialog.this.files.get(this.i));
                        if (!FileTransferDialog.this.cancelled) {
                            FileTransferDialog.this.sftp.get((String)FileTransferDialog.this.files.get(this.i), FileTransferDialog.this);
                        }
                        ++this.i;
                    }
                    FileTransferDialog.this.notifyWaiting();
                }
                catch (IOException iOException) {
                    File file;
                    if (!FileTransferDialog.this.cancelled) {
                        SshToolsApplicationPanel.showErrorMessage(FileTransferDialog.this, "The file operation failed!\n" + iOException.getMessage(), "File Transfer", iOException);
                    }
                    if ((file = new File(FileTransferDialog.this.sftp.lpwd() + File.separator + FileTransferDialog.this.files.get(this.i))).exists()) {
                        file.delete();
                    }
                    FileTransferDialog.this.setVisible(false);
                }
            }
        });
        thread.start();
        this.setVisible(true);
    }

    private void jbInit() throws Exception {
        Object object;
        Object object2;
        this.getContentPane().setLayout(new BorderLayout());
        this.progressbar.setToolTipText("");
        this.progressbar.setValue(0);
        try {
            object2 = this.progressbar.getClass().getMethod("setIndeterminate", Boolean.TYPE);
            object = new Object[]{new Boolean(true)};
            ((Method)object2).invoke((Object)this.progressbar, (Object[])object);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.progressbar.setBounds(new Rectangle(8, 45, 336, 22));
        this.lblEstimatedTime.setText("Estimated time left: ");
        this.lblEstimatedTime.setBounds(new Rectangle(8, 74, 114, 17));
        this.lblTimeLeftValue.setText("");
        this.lblTimeLeftValue.setBounds(new Rectangle(109, 74, 235, 17));
        this.lblTargetAction.setText("Downloading to:");
        this.lblTargetAction.setBounds(new Rectangle(8, 92, 96, 17));
        this.lblTargetValue.setText("");
        this.lblTargetValue.setBounds(new Rectangle(109, 92, 235, 17));
        this.lblTransferRate.setText("Transfer rate: ");
        this.lblTransferRate.setBounds(new Rectangle(8, 110, 96, 17));
        this.lblTransferRateValue.setText("");
        this.lblTransferRateValue.setBounds(new Rectangle(109, 110, 235, 17));
        this.btnCancel.setText("Cancel");
        this.btnCancel.addActionListener(new FileTransferDialog_cancel_actionAdapter(this));
        this.chkClose.setText("Close this window when the transfer completes");
        this.chkClose.setBounds(new Rectangle(8, 132, 307, 18));
        this.chkClose.setSelected(true);
        object2 = new JPanel(null);
        this.lblAction.setBounds(new Rectangle(9, 5, 334, 21));
        this.lblPathValue.setText("");
        this.lblPathValue.setBounds(new Rectangle(10, 22, 329, 22));
        ((Container)object2).add(this.progressbar);
        ((Container)object2).add(this.lblEstimatedTime);
        ((Container)object2).add(this.lblTimeLeftValue);
        ((Container)object2).add(this.lblTargetAction);
        ((Container)object2).add(this.lblTransferRate);
        ((Container)object2).add(this.lblTransferRateValue);
        ((Container)object2).add(this.lblTargetValue);
        ((Container)object2).add(this.lblAction);
        ((Container)object2).add(this.lblPathValue);
        ((Container)object2).add(this.chkClose);
        object = new JPanel(new FlowLayout(2));
        ((Container)object).add(this.btnCancel);
        ((JComponent)object2).setMaximumSize(new Dimension(350, 185));
        ((JComponent)object2).setMinimumSize(new Dimension(350, 185));
        ((JComponent)object2).setPreferredSize(new Dimension(350, 185));
        this.getContentPane().add((Component)object2, "Center");
        this.getContentPane().add((Component)object, "South");
        this.elaspedTime = 0L;
        this.formatMb.setMaximumFractionDigits(2);
        this.formatKb.setMaximumFractionDigits(0);
        this.formatKb1.setMaximumFractionDigits(1);
        this.setResizable(true);
        this.setSize(new Dimension(350, 184));
        UIUtil.positionComponent(0, this);
    }

    public void setTarget(String string) {
        this.lblTargetValue.setText(string);
        this.lblTargetValue.setToolTipText(string);
    }

    public static void main(String[] stringArray) {
        FileTransferDialog fileTransferDialog = new FileTransferDialog();
        fileTransferDialog.show();
    }

    public void setSource(String string) {
        this.source = string;
    }

    private int getFileCount() {
        return (this.files == null ? 0 : this.files.size()) + (this.op == null ? 0 : this.op.getFileCount());
    }

    public void started(long l, String string) {
        Object object;
        try {
            object = this.progressbar.getClass().getMethod("setIndeterminate", Boolean.TYPE);
            Object[] objectArray = new Object[]{new Boolean(false)};
            ((Method)object).invoke((Object)this.progressbar, objectArray);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        object = this.source + (this.getFileCount() <= 1 ? "" : " (" + String.valueOf(this.filesTransfered + 1) + " of " + String.valueOf(this.getFileCount()) + " files)");
        this.lblPathValue.setText((String)object);
        this.lastUpdate = System.currentTimeMillis();
        this.fileSize = l;
        this.lblTimeLeftValuer = new Timer(1000, new ActionListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void actionPerformed(ActionEvent actionEvent) {
                Object object = FileTransferDialog.this.lock;
                synchronized (object) {
                    FileTransferDialog.this.transfer = FileTransferDialog.this.elaspedTime < 1000L ? (double)(FileTransferDialog.this.bytesSoFar + FileTransferDialog.this.completedTransfers) : (double)((FileTransferDialog.this.bytesSoFar + FileTransferDialog.this.completedTransfers) / (FileTransferDialog.this.elaspedTime / 1000L));
                    FileTransferDialog.this.lblTransferRateValue.setText(FileTransferDialog.this.formatKb1.format(FileTransferDialog.this.transfer / 1024.0) + " KB/Sec");
                    long l = FileTransferDialog.this.totalBytes - (FileTransferDialog.this.completedTransfers + FileTransferDialog.this.bytesSoFar);
                    long l2 = (long)((double)l / FileTransferDialog.this.transfer);
                    FileTransferDialog.this.setTitle(FileTransferDialog.this.formatKb.format((double)(FileTransferDialog.this.completedTransfers + FileTransferDialog.this.bytesSoFar) / (double)FileTransferDialog.this.totalBytes * 100.0) + "% Complete - " + FileTransferDialog.this.title);
                    String string = l2 < 60L ? String.valueOf(l2) + " sec" : (l2 < 3600L ? String.valueOf(l2 / 60L) + " min " + String.valueOf(l2 % 60L) + " sec" : String.valueOf(l2 / 3600L) + " hrs " + String.valueOf(l2 % 3600L / 60L) + " min " + String.valueOf(l2 % 3600L % 60L) + " sec");
                    if (FileTransferDialog.this.completedTransfers + FileTransferDialog.this.bytesSoFar / 0x100000L > 0L) {
                        FileTransferDialog.this.lblTimeLeftValue.setText(string + " (" + FileTransferDialog.this.formatMb.format((double)(FileTransferDialog.this.completedTransfers + FileTransferDialog.this.bytesSoFar) / 1048576.0) + " MB of " + FileTransferDialog.this.formattedTotal + " copied)");
                    } else {
                        FileTransferDialog.this.lblTimeLeftValue.setText(string + " (" + FileTransferDialog.this.formatKb.format((double)(FileTransferDialog.this.completedTransfers + FileTransferDialog.this.bytesSoFar) / 1024.0) + " KB of " + FileTransferDialog.this.formattedTotal + " copied)");
                    }
                }
            }
        });
        this.lblTimeLeftValuer.start();
    }

    public boolean isCancelled() {
        if (this.cancelled) {
            this.setVisible(false);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void progressed(long l) {
        Object object = this.lock;
        synchronized (object) {
            this.bytesSoFar = l;
        }
        this.progressbar.setValue((int)(this.completedTransfers + this.bytesSoFar) / 1024);
        this.currentTime = System.currentTimeMillis();
        this.elaspedTime += this.currentTime - this.lastUpdate;
        this.lastUpdate = this.currentTime;
    }

    public void completed() {
        ++this.filesTransfered;
        this.completedTransfers += this.bytesSoFar;
        this.bytesSoFar = 0L;
        if (this.getFileCount() == this.filesTransfered) {
            this.setTitle("100% Complete - " + this.title);
            this.lblTimeLeftValue.setText("Completed (" + this.formattedTotal + " of " + this.formattedTotal + " copied)");
            this.btnCancel.setText("Close");
            this.lblTimeLeftValuer.stop();
            this.completed = true;
            if (this.chkClose.isSelected()) {
                this.setVisible(false);
            }
        }
    }

    void cancel_actionPerformed(ActionEvent actionEvent) {
        if (this.btnCancel.getText().equals("Cancel")) {
            this.cancelled = true;
        } else {
            this.setVisible(false);
        }
    }
}

