/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.shift;

import com.sshtools.common.ui.DataNotificationListener;
import com.sshtools.common.ui.ResourceIcon;
import com.sshtools.common.ui.SshToolsApplication;
import com.sshtools.common.ui.SshToolsApplicationException;
import com.sshtools.common.ui.SshToolsApplicationPanel;
import com.sshtools.common.ui.SshToolsApplicationSessionPanel;
import com.sshtools.common.ui.SshToolsConnectionTab;
import com.sshtools.common.ui.StandardAction;
import com.sshtools.common.ui.StatusBar;
import com.sshtools.common.ui.UIUtil;
import com.sshtools.j2ssh.SftpClient;
import com.sshtools.j2ssh.connection.ChannelEventListener;
import com.sshtools.j2ssh.sftp.FileAttributes;
import com.sshtools.shift.BackAction;
import com.sshtools.shift.CopyFromAction;
import com.sshtools.shift.CopyToAction;
import com.sshtools.shift.DeleteAction;
import com.sshtools.shift.DirectoryListingTableModel;
import com.sshtools.shift.FileSizeTableCellRenderer;
import com.sshtools.shift.FileTransferDialog;
import com.sshtools.shift.ForwardAction;
import com.sshtools.shift.HomeAction;
import com.sshtools.shift.NewFolderAction;
import com.sshtools.shift.PropertiesAction;
import com.sshtools.shift.PropertiesDialog;
import com.sshtools.shift.RefreshAction;
import com.sshtools.shift.RenameAction;
import com.sshtools.shift.RootAction;
import com.sshtools.shift.SftpTableCellRenderer;
import com.sshtools.shift.UpAction;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.DateFormat;
import java.util.Iterator;
import java.util.List;
import java.util.Stack;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.ActionMap;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.Timer;

public class ShiftSessionPanel
extends SshToolsApplicationSessionPanel {
    public static final ResourceIcon FILE_BROWSER_ICON = new ResourceIcon(class$com$sshtools$shift$ShiftSessionPanel == null ? (class$com$sshtools$shift$ShiftSessionPanel = ShiftSessionPanel.class$("com.sshtools.shift.ShiftSessionPanel")) : class$com$sshtools$shift$ShiftSessionPanel, "sftpsession.png");
    SftpClient sftp;
    JScrollPane scrollPane = new JScrollPane();
    JTable listing = new JTable();
    DirectoryListingTableModel model;
    JPanel navigation = new JPanel(new GridBagLayout());
    JLabel address = new JLabel("Address");
    JComboBox addressDropdown = new JComboBox();
    Stack backStack = new Stack();
    Stack forwardStack = new Stack();
    CopyFromAction copyFrom;
    CopyToAction copyTo;
    DeleteAction delete;
    NewFolderAction newFolder;
    UpAction up;
    BackAction back;
    ForwardAction forward;
    HomeAction home;
    RootAction root;
    RefreshAction refresh;
    RenameAction rename;
    PropertiesAction properties;
    StatusBar statusBar;
    StandardAction cd;
    JPopupMenu popupMenu = new JPopupMenu();
    String lastDownloadPath = new String();
    String lastUploadPath = new String();
    Object lock = new Object();
    boolean isUpdating = false;
    ChannelEventListener eventListener;
    Vector activeOperations = new Vector();
    static /* synthetic */ Class class$com$sshtools$shift$ShiftSessionPanel;
    static /* synthetic */ Class class$java$awt$Frame;

    public ShiftSessionPanel() {
        super(new BorderLayout());
    }

    public SshToolsConnectionTab[] getAdditionalConnectionTabs() {
        return null;
    }

    public boolean requiresConfiguration() {
        return false;
    }

    public String getId() {
        return "shift";
    }

    public void addEventListener(ChannelEventListener channelEventListener) {
        this.eventListener = channelEventListener;
        if (this.sftp != null) {
            this.sftp.addEventListener(channelEventListener);
        }
    }

    public ResourceIcon getIcon() {
        return FILE_BROWSER_ICON;
    }

    public void init(SshToolsApplication sshToolsApplication) throws SshToolsApplicationException {
        super.init(sshToolsApplication);
        this.listing.setShowGrid(false);
        this.listing.setShowHorizontalLines(false);
        this.listing.setShowVerticalLines(false);
        this.listing.setIntercellSpacing(new Dimension(0, 0));
        this.listing.setColumnSelectionAllowed(false);
        this.model = new DirectoryListingTableModel(this.sftp);
        this.listing.setModel(this.model);
        this.scrollPane.getViewport().add(this.listing);
        this.scrollPane.getViewport().setBackground(Color.white);
        this.listing.setBackground(Color.white);
        Insets insets = new Insets(8, 2, 2, 2);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.insets = insets;
        gridBagConstraints.weightx = 0.0;
        UIUtil.jGridBagAdd(this.navigation, this.address, gridBagConstraints, -1);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        UIUtil.jGridBagAdd(this.navigation, this.addressDropdown, gridBagConstraints, 0);
        this.statusBar = new StatusBar();
        this.add((Component)this.navigation, "North");
        this.add((Component)this.scrollPane, "Center");
        this.add((Component)this.statusBar, "South");
        this.initActions();
        this.addressDropdown.setRenderer(new DefaultListCellRenderer(){

            public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
                this.setText(object.toString());
                this.setBackground(bl ? Color.black : Color.white);
                this.setForeground(bl ? Color.white : Color.black);
                this.setIcon(FILE_BROWSER_ICON);
                return this;
            }
        });
        this.deregisterAction(this.getAction("Options"));
        this.setActionVisible("New Window", false);
        this.setActionVisible("About", false);
    }

    protected void initActions() {
        this.registerActionMenu(new SshToolsApplicationPanel.ActionMenu("File", "File", 102, 0));
        this.registerActionMenu(new SshToolsApplicationPanel.ActionMenu("Edit", "Edit", 101, 10));
        this.registerActionMenu(new SshToolsApplicationPanel.ActionMenu("Navigate", "Navigate", 110, 20));
        this.registerActionMenu(new SshToolsApplicationPanel.ActionMenu("Help", "Help", 104, 90));
        ActionMap actionMap = new ActionMap();
        this.listing.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                if ((mouseEvent.getModifiers() & 4) > 0) {
                    ShiftSessionPanel.this.getContextMenu().show(ShiftSessionPanel.this.listing, mouseEvent.getX(), mouseEvent.getY());
                }
            }
        });
        this.home = new HomeAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                ShiftSessionPanel.this.changeDirectory("", true);
            }
        };
        this.registerAction(this.home);
        actionMap.put(KeyStroke.getKeyStroke(36, 0), this.home);
        this.refresh = new RefreshAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    ShiftSessionPanel.this.model.refresh();
                }
                catch (IOException iOException) {
                    SshToolsApplicationPanel.showErrorMessage(ShiftSessionPanel.this, "The operation failed", "Refresh Contents", iOException);
                }
            }
        };
        this.registerAction(this.refresh);
        actionMap.put(KeyStroke.getKeyStroke(116, 0), this.refresh);
        this.newFolder = new NewFolderAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                ShiftSessionPanel.this.createFolder();
            }
        };
        this.registerAction(this.newFolder);
        this.rename = new RenameAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                ShiftSessionPanel.this.rename();
            }
        };
        this.registerAction(this.rename);
        this.up = new UpAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                ShiftSessionPanel.this.moveToParent();
                ShiftSessionPanel.this.setAvailableActions();
            }
        };
        this.registerAction(this.up);
        actionMap.put(KeyStroke.getKeyStroke(85, 8), this.up);
        this.properties = new PropertiesAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                PropertiesDialog propertiesDialog = new PropertiesDialog(ShiftSessionPanel.this.model.getFileAttributes(ShiftSessionPanel.this.listing.getSelectedRow()), ShiftSessionPanel.this.sftp, ShiftSessionPanel.this.model.getFilename(ShiftSessionPanel.this.listing.getSelectedRow()), ShiftSessionPanel.this.model);
                propertiesDialog.show();
            }
        };
        this.registerAction(this.properties);
        this.copyFrom = new CopyFromAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                ShiftSessionPanel.this.copyLocalFiles();
            }
        };
        this.registerAction(this.copyFrom);
        this.copyTo = new CopyToAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                ShiftSessionPanel.this.copyRemoteFiles();
            }
        };
        this.registerAction(this.copyTo);
        this.delete = new DeleteAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                ShiftSessionPanel.this.removeSelected();
            }
        };
        this.registerAction(this.delete);
        this.listing.setActionMap(actionMap);
        int n = 1;
        this.listing.getInputMap(n).put(KeyStroke.getKeyStroke(10, 0, false), "Enter");
        this.listing.getActionMap().put("Enter", new StandardAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (ShiftSessionPanel.this.model.isDirectory(ShiftSessionPanel.this.listing.getSelectedRow()) && ShiftSessionPanel.this.listing.getSelectedRowCount() == 1) {
                    ShiftSessionPanel.this.changeDirectory(ShiftSessionPanel.this.model.getFilename(ShiftSessionPanel.this.listing.getSelectedRow()), false);
                    ShiftSessionPanel.this.setAvailableActions();
                }
            }
        });
        this.listing.getInputMap(n).put(KeyStroke.getKeyStroke(36, 8, false), "Root");
        this.root = new RootAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                ShiftSessionPanel.this.changeDirectory("/", true);
            }
        };
        this.registerAction(this.root);
        this.listing.getActionMap().put("Root", this.root);
        this.listing.getInputMap(n).put(KeyStroke.getKeyStroke(38, 0, false), "Up");
        this.listing.getActionMap().put("Up", new StandardAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (ShiftSessionPanel.this.listing.getSelectedRow() > 0) {
                    int n = ShiftSessionPanel.this.listing.getSelectedRow();
                    ShiftSessionPanel.this.listing.getSelectionModel().clearSelection();
                    ShiftSessionPanel.this.listing.getSelectionModel().setSelectionInterval(n - 1, n - 1);
                    ShiftSessionPanel.this.listing.repaint();
                    ShiftSessionPanel.this.setAvailableActions();
                } else if (ShiftSessionPanel.this.listing.getSelectedRowCount() == 0) {
                    ShiftSessionPanel.this.listing.getSelectionModel().setSelectionInterval(ShiftSessionPanel.this.listing.getRowCount(), ShiftSessionPanel.this.listing.getRowCount());
                    ShiftSessionPanel.this.listing.repaint();
                    ShiftSessionPanel.this.setAvailableActions();
                }
            }
        });
        this.listing.getInputMap(n).put(KeyStroke.getKeyStroke(40, 0, false), "Down");
        this.listing.getActionMap().put("Down", new StandardAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (ShiftSessionPanel.this.listing.getSelectedRow() < ShiftSessionPanel.this.listing.getRowCount()) {
                    int n = ShiftSessionPanel.this.listing.getSelectedRow();
                    ShiftSessionPanel.this.listing.getSelectionModel().clearSelection();
                    ShiftSessionPanel.this.listing.getSelectionModel().setSelectionInterval(n + 1, n + 1);
                    ShiftSessionPanel.this.listing.repaint();
                    ShiftSessionPanel.this.setAvailableActions();
                }
            }
        });
        this.listing.getInputMap(n).put(KeyStroke.getKeyStroke(37, 8, false), "Back");
        this.back = new BackAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (ShiftSessionPanel.this.backStack.size() > 0) {
                    ShiftSessionPanel.this.changeDirectory((String)ShiftSessionPanel.this.backStack.pop(), false);
                    ShiftSessionPanel.this.setAvailableActions();
                }
            }
        };
        this.registerAction(this.back);
        this.listing.getActionMap().put("Back", this.back);
        this.listing.getInputMap(n).put(KeyStroke.getKeyStroke(39, 8, false), "Forward");
        this.forward = new ForwardAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (ShiftSessionPanel.this.forwardStack.size() > 0) {
                    String string = (String)ShiftSessionPanel.this.forwardStack.pop();
                    ShiftSessionPanel.this.changeDirectory(string, true);
                    ShiftSessionPanel.this.setAvailableActions();
                }
            }
        };
        this.registerAction(this.forward);
        this.listing.getActionMap().put("Forward", this.forward);
    }

    private void copyLocalFiles() {
        Thread thread = new Thread(new Runnable(){

            public void run() {
                Object object;
                JFileChooser jFileChooser = new JFileChooser(System.getProperty("user.home"));
                jFileChooser.setMultiSelectionEnabled(true);
                jFileChooser.setDialogTitle("Select files to upload");
                jFileChooser.setFileSelectionMode(2);
                if (ShiftSessionPanel.this.lastUploadPath != null && !ShiftSessionPanel.this.lastUploadPath.equals("") && ((File)(object = new File(ShiftSessionPanel.this.lastUploadPath))).exists()) {
                    jFileChooser.setCurrentDirectory(new File(ShiftSessionPanel.this.lastUploadPath));
                }
                if (jFileChooser.showDialog(ShiftSessionPanel.this, "Upload") == 0) {
                    object = jFileChooser.getSelectedFiles();
                    ShiftSessionPanel.this.lastUploadPath = jFileChooser.getCurrentDirectory().getAbsolutePath();
                    Vector<Object> vector = new Vector<Object>();
                    Vector<Object> vector2 = new Vector<Object>();
                    int n = 0;
                    while (n < ((Object)object).length) {
                        if (((File)object[n]).isDirectory()) {
                            vector2.add(object[n]);
                        } else {
                            vector.add(object[n]);
                        }
                        ++n;
                    }
                    if (vector2.size() > 0) {
                        ShiftSessionPanel.this.copyLocalDirectories(vector2, vector);
                    } else if (((Object)object).length > 0) {
                        ShiftSessionPanel.this.copyLocalFiles((File[])object);
                    }
                }
            }
        });
        thread.start();
    }

    private void copyRemoteFiles() {
        Thread thread = new Thread(new Runnable(){

            public void run() {
                File file;
                Vector<String> vector = new Vector<String>();
                Vector<String> vector2 = new Vector<String>();
                int[] nArray = ShiftSessionPanel.this.listing.getSelectedRows();
                int n = 0;
                while (n < nArray.length) {
                    if (ShiftSessionPanel.this.model.isDirectory(nArray[n])) {
                        vector2.add(ShiftSessionPanel.this.model.getFilename(nArray[n]));
                    } else {
                        vector.add(ShiftSessionPanel.this.model.getFilename(nArray[n]));
                    }
                    ++n;
                }
                JFileChooser jFileChooser = new JFileChooser(System.getProperty("user.home"));
                jFileChooser.setMultiSelectionEnabled(false);
                jFileChooser.setDialogTitle("Select destination location");
                if (ShiftSessionPanel.this.lastDownloadPath != null && !ShiftSessionPanel.this.lastDownloadPath.equals("") && (file = new File(ShiftSessionPanel.this.lastDownloadPath)).exists()) {
                    jFileChooser.setCurrentDirectory(new File(ShiftSessionPanel.this.lastDownloadPath));
                }
                jFileChooser.setFileSelectionMode(1);
                if (jFileChooser.showDialog(ShiftSessionPanel.this, "Copy") == 0) {
                    try {
                        ShiftSessionPanel.this.sftp.lcd(jFileChooser.getSelectedFile().getAbsolutePath());
                        ShiftSessionPanel.this.lastDownloadPath = jFileChooser.getSelectedFile().getAbsolutePath();
                        if (vector.size() > 0 && vector2.size() == 0) {
                            ShiftSessionPanel.this.copyRemoteFiles(vector);
                        } else {
                            ShiftSessionPanel.this.copyRemoteDirectories(vector2, vector, jFileChooser.getSelectedFile());
                        }
                    }
                    catch (IOException iOException) {
                        SshToolsApplicationPanel.showErrorMessage(ShiftSessionPanel.this, "An error occured copying the remote files!", "Copy files", iOException);
                    }
                }
            }
        });
        thread.start();
    }

    protected void moveToParent() {
        try {
            String string = this.model.getCurrentDirectory();
            int n = string.lastIndexOf("/");
            if (n >= 0 && string.length() > 1) {
                this.changeDirectory(string.substring(0, n + 1), true);
            } else {
                Toolkit.getDefaultToolkit().beep();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public boolean onOpenSession() throws IOException {
        this.sftp = this.manager.openSftpClient();
        if (this.eventListener != null) {
            this.sftp.addEventListener(this.eventListener);
        }
        this.sftp.addEventListener(new DataNotificationListener(this.statusBar));
        this.statusBar.setHost("Connected to " + this.manager.getProfile().getHost());
        this.statusBar.setConnected(true);
        this.listing.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() == 2 && ShiftSessionPanel.this.listing.getSelectedRowCount() == 1) {
                    if (ShiftSessionPanel.this.model.isDirectory(ShiftSessionPanel.this.listing.getSelectedRow())) {
                        ShiftSessionPanel.this.changeDirectory(ShiftSessionPanel.this.model.getFilename(ShiftSessionPanel.this.listing.getSelectedRow()), true);
                    } else {
                        Vector<String> vector = new Vector<String>();
                        vector.add(ShiftSessionPanel.this.model.getFilename(ShiftSessionPanel.this.listing.getSelectedRow()));
                        ShiftSessionPanel.this.copyRemoteFiles(vector);
                    }
                }
                ShiftSessionPanel.this.setAvailableActions();
            }

            public void mouseReleased(MouseEvent mouseEvent) {
                ShiftSessionPanel.this.setAvailableActions();
            }
        });
        this.listing.addMouseListener(new PopupListener(this.popupMenu));
        this.model = new DirectoryListingTableModel(this.sftp);
        this.listing.setModel(this.model);
        this.listing.setAutoCreateColumnsFromModel(true);
        this.model.refresh();
        this.updateAddress(this.model.getCurrentDirectory());
        DateFormat dateFormat = DateFormat.getDateInstance(3);
        this.listing.getColumn("Name").setCellRenderer(new SftpTableCellRenderer());
        this.listing.getColumn("Size").setCellRenderer(new FileSizeTableCellRenderer());
        this.listing.setBackground(Color.white);
        this.addressDropdown.setEditable(true);
        this.addressDropdown.addItemListener(new ItemListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void itemStateChanged(ItemEvent itemEvent) {
                if (itemEvent.getStateChange() == 1) {
                    Object object = ShiftSessionPanel.this.lock;
                    synchronized (object) {
                        if (!ShiftSessionPanel.this.isUpdating) {
                            if (itemEvent.getItem() instanceof TokenizedPathElement) {
                                ShiftSessionPanel.this.changeDirectory(((TokenizedPathElement)itemEvent.getItem()).path, true);
                            } else if (itemEvent.getItem() instanceof String) {
                                ShiftSessionPanel.this.changeDirectory(itemEvent.getItem().toString(), true);
                            }
                        }
                    }
                }
            }
        });
        this.listing.getColumnModel().getColumn(0).setPreferredWidth(200);
        return true;
    }

    protected void copyLocalFiles(final File[] fileArray) {
        Runnable runnable = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                block11: {
                    FileTransferDialog fileTransferDialog = null;
                    try {
                        Vector<String> vector = new Vector<String>();
                        int n = 0;
                        while (n < fileArray.length) {
                            vector.add(fileArray[n].getName());
                            ++n;
                        }
                        fileTransferDialog = new FileTransferDialog((Frame)SwingUtilities.getAncestorOfClass(class$java$awt$Frame == null ? (class$java$awt$Frame = ShiftSessionPanel.class$("java.awt.Frame")) : class$java$awt$Frame, ShiftSessionPanel.this), "Uploading", vector.size());
                        Vector vector2 = ShiftSessionPanel.this.activeOperations;
                        synchronized (vector2) {
                            ShiftSessionPanel.this.activeOperations.add(fileTransferDialog);
                        }
                        fileTransferDialog.putFiles(ShiftSessionPanel.this.sftp, fileArray[0].getParentFile(), vector);
                        fileTransferDialog.waitForCompletion();
                        Vector vector3 = ShiftSessionPanel.this.activeOperations;
                        synchronized (vector3) {
                            ShiftSessionPanel.this.activeOperations.remove(fileTransferDialog);
                        }
                        System.out.println();
                        ShiftSessionPanel.this.model.refresh();
                    }
                    catch (Exception exception) {
                        if (fileTransferDialog == null || fileTransferDialog.isCancelled()) break block11;
                        try {
                            SwingUtilities.invokeAndWait(new Runnable(this, exception){
                                private final /* synthetic */ Exception val$ex;
                                private final /* synthetic */ 22 this$1;
                                {
                                    this.this$1 = var1_1;
                                    this.val$ex = exception;
                                }

                                public void run() {
                                    SshToolsApplicationPanel.showErrorMessage(22.access$200(this.this$1), "Failed to download files!", "SFTP Browser", this.val$ex);
                                }
                            });
                        }
                        catch (Exception exception2) {
                            ShiftSessionPanel.this.log.info("Failed to invoke message box through SwingUtilities", exception2);
                        }
                    }
                }
            }

            static /* synthetic */ ShiftSessionPanel access$200(22 var0) {
                return var0.ShiftSessionPanel.this;
            }
        };
        Thread thread = new Thread(runnable);
        thread.start();
    }

    protected void copyRemoteFiles(final List list) {
        Thread thread = new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                block11: {
                    FileTransferDialog fileTransferDialog = null;
                    try {
                        long l = 0L;
                        int n = 0;
                        while (n < list.size()) {
                            FileAttributes fileAttributes = ShiftSessionPanel.this.sftp.stat((String)list.get(n));
                            l += fileAttributes.getSize().longValue();
                            ++n;
                        }
                        fileTransferDialog = new FileTransferDialog((Frame)SwingUtilities.getAncestorOfClass(class$java$awt$Frame == null ? (class$java$awt$Frame = ShiftSessionPanel.class$("java.awt.Frame")) : class$java$awt$Frame, ShiftSessionPanel.this), "Downloading", 1);
                        fileTransferDialog.getRemoteFiles(ShiftSessionPanel.this.sftp, list, l);
                        Vector vector = ShiftSessionPanel.this.activeOperations;
                        synchronized (vector) {
                            ShiftSessionPanel.this.activeOperations.add(fileTransferDialog);
                        }
                        fileTransferDialog.waitForCompletion();
                        Vector vector2 = ShiftSessionPanel.this.activeOperations;
                        synchronized (vector2) {
                            ShiftSessionPanel.this.activeOperations.remove(fileTransferDialog);
                        }
                    }
                    catch (Exception exception) {
                        if (fileTransferDialog == null || fileTransferDialog.isCancelled()) break block11;
                        try {
                            SwingUtilities.invokeAndWait(new Runnable(this, exception){
                                private final /* synthetic */ Exception val$ex;
                                private final /* synthetic */ 24 this$1;
                                {
                                    this.this$1 = var1_1;
                                    this.val$ex = exception;
                                }

                                public void run() {
                                    SshToolsApplicationPanel.showErrorMessage(24.access$400(this.this$1), "Failed to download files!", "SFTP Browser", this.val$ex);
                                }
                            });
                        }
                        catch (Exception exception2) {
                            ShiftSessionPanel.this.log.info("Failed to invoke message box through SwingUtilities", exception2);
                        }
                    }
                }
            }

            static /* synthetic */ ShiftSessionPanel access$400(24 var0) {
                return var0.ShiftSessionPanel.this;
            }
        }, "Downloading files");
        thread.start();
    }

    protected void copyRemoteDirectories(final List list, final List list2, final File file) {
        Thread thread = new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                block12: {
                    FileTransferDialog fileTransferDialog = null;
                    try {
                        int n = JOptionPane.showOptionDialog(ShiftSessionPanel.this, "How would you like to download the contents of " + (list.size() > 1 ? "these directories?" : "this directory?"), "Copy Directory", -1, 3, null, new String[]{"Synchronize", "Recurse Copy", "Flat Copy", "Cancel"}, "Recurse");
                        if (n == 3) {
                            return;
                        }
                        if (n == 0 && file.isDirectory() && file.listFiles().length > 0 && (n = JOptionPane.showConfirmDialog(ShiftSessionPanel.this, "The directory you have chosen is not empty!  \nThe synchronize option will clear the contents of this directory!  \n\nAre you sure you wish to proceed?", "Confirm Synchronize Operation", 0)) == 1) {
                            return;
                        }
                        ShiftSessionPanel.this.statusBar.setRemoteId("");
                        fileTransferDialog = new FileTransferDialog((Frame)SwingUtilities.getAncestorOfClass(class$java$awt$Frame == null ? (class$java$awt$Frame = ShiftSessionPanel.class$("java.awt.Frame")) : class$java$awt$Frame, ShiftSessionPanel.this), "Downloading", 1);
                        fileTransferDialog.copyRemoteDirectory(ShiftSessionPanel.this.sftp, list, list2, file.getAbsolutePath(), n == 1 || n == 0, n == 0);
                        Vector vector = ShiftSessionPanel.this.activeOperations;
                        synchronized (vector) {
                            ShiftSessionPanel.this.activeOperations.add(fileTransferDialog);
                        }
                        fileTransferDialog.waitForCompletion();
                        Vector vector2 = ShiftSessionPanel.this.activeOperations;
                        synchronized (vector2) {
                            ShiftSessionPanel.this.activeOperations.remove(fileTransferDialog);
                        }
                    }
                    catch (Exception exception) {
                        if (fileTransferDialog == null || fileTransferDialog.isCancelled()) break block12;
                        try {
                            SwingUtilities.invokeAndWait(new Runnable(this, exception){
                                private final /* synthetic */ Exception val$ex;
                                private final /* synthetic */ 26 this$1;
                                {
                                    this.this$1 = var1_1;
                                    this.val$ex = exception;
                                }

                                public void run() {
                                    SshToolsApplicationPanel.showErrorMessage(26.access$600(this.this$1), "Failed to download directories!", "SFTP Browser", this.val$ex);
                                }
                            });
                        }
                        catch (Exception exception2) {
                            ShiftSessionPanel.this.log.info("Failed to invoke message box through SwingUtilities", exception2);
                        }
                    }
                }
            }

            static /* synthetic */ ShiftSessionPanel access$600(26 var0) {
                return var0.ShiftSessionPanel.this;
            }
        }, "Downloading directories");
        thread.start();
    }

    protected void copyLocalDirectories(final List list, final List list2) {
        Thread thread = new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                block12: {
                    FileTransferDialog fileTransferDialog = null;
                    try {
                        int n = JOptionPane.showOptionDialog(ShiftSessionPanel.this, "How would you like to upload the contents of " + (list.size() > 1 ? "these directories?" : "this directory?"), "Copy Directory", -1, 3, null, new String[]{"Synchronize", "Recurse Copy", "Flat Copy", "Cancel"}, "Recurse");
                        if (n == 3) {
                            return;
                        }
                        if (n == 0 && (n = JOptionPane.showConfirmDialog(ShiftSessionPanel.this, "The synchronize option will clear the contents of this directory!  \n\nAre you sure you wish to proceed?", "Confirm Synchronize Operation", 0)) == 1) {
                            return;
                        }
                        ShiftSessionPanel.this.statusBar.setRemoteId("");
                        fileTransferDialog = new FileTransferDialog((Frame)SwingUtilities.getAncestorOfClass(class$java$awt$Frame == null ? (class$java$awt$Frame = ShiftSessionPanel.class$("java.awt.Frame")) : class$java$awt$Frame, ShiftSessionPanel.this), "Uploading", 1);
                        fileTransferDialog.copyLocalDirectory(ShiftSessionPanel.this.sftp, list2, list, ShiftSessionPanel.this.sftp.pwd(), n == 1 || n == 0, n == 0);
                        Vector vector = ShiftSessionPanel.this.activeOperations;
                        synchronized (vector) {
                            ShiftSessionPanel.this.activeOperations.add(fileTransferDialog);
                        }
                        fileTransferDialog.waitForCompletion();
                        Vector vector2 = ShiftSessionPanel.this.activeOperations;
                        synchronized (vector2) {
                            ShiftSessionPanel.this.activeOperations.remove(fileTransferDialog);
                        }
                        ShiftSessionPanel.this.model.refresh();
                    }
                    catch (Exception exception) {
                        if (fileTransferDialog == null || fileTransferDialog.isCancelled()) break block12;
                        try {
                            SwingUtilities.invokeAndWait(new Runnable(this, exception){
                                private final /* synthetic */ Exception val$ex;
                                private final /* synthetic */ 28 this$1;
                                {
                                    this.this$1 = var1_1;
                                    this.val$ex = exception;
                                }

                                public void run() {
                                    SshToolsApplicationPanel.showErrorMessage(28.access$800(this.this$1), "Failed to upload directories!", "SFTP Browser", this.val$ex);
                                }
                            });
                        }
                        catch (Exception exception2) {
                            ShiftSessionPanel.this.log.info("Failed to invoke message box through SwingUtilities", exception2);
                        }
                    }
                }
            }

            static /* synthetic */ ShiftSessionPanel access$800(28 var0) {
                return var0.ShiftSessionPanel.this;
            }
        }, "Uploading directories");
        thread.start();
    }

    protected void createFolder() {
        Runnable runnable = new Runnable(){

            public void run() {
                try {
                    ShiftSessionPanel.this.statusBar.setStatusText("Creating folder");
                    String string = JOptionPane.showInputDialog(ShiftSessionPanel.this, "Enter new folder name", "Create Folder", 2);
                    if (string != null && !string.trim().equals("")) {
                        ShiftSessionPanel.this.model.createFolder(string);
                    }
                    ShiftSessionPanel.this.setAvailableActions();
                    ShiftSessionPanel.this.statusBar.setStatusText("Ready...");
                }
                catch (IOException iOException) {
                    ShiftSessionPanel.this.statusBar.setStatusText("Ready...");
                    SshToolsApplicationPanel.showErrorMessage(ShiftSessionPanel.this, "Failed to create directory!", "SFTP Browser", iOException);
                }
            }
        };
        Thread thread = new Thread(runnable);
        thread.start();
    }

    protected void rename() {
        Runnable runnable = new Runnable(){

            public void run() {
                try {
                    ShiftSessionPanel.this.statusBar.setStatusText("Renaming...");
                    String string = JOptionPane.showInputDialog(ShiftSessionPanel.this, "Enter new name", "Rename", 2);
                    if (string != null && !string.trim().equals("")) {
                        ShiftSessionPanel.this.sftp.rename(ShiftSessionPanel.this.model.getFilename(ShiftSessionPanel.this.listing.getSelectedRow()), string);
                        ShiftSessionPanel.this.model.refresh();
                    }
                    ShiftSessionPanel.this.setAvailableActions();
                    ShiftSessionPanel.this.statusBar.setStatusText("Ready...");
                }
                catch (IOException iOException) {
                    ShiftSessionPanel.this.statusBar.setStatusText("Ready...");
                    SshToolsApplicationPanel.showErrorMessage(ShiftSessionPanel.this, "Failed to rename!", "SFTP Browser", iOException);
                }
            }
        };
        Thread thread = new Thread(runnable);
        thread.start();
    }

    protected void changeDirectory(final String string, final boolean bl) {
        this.listing.getSelectionModel().clearSelection();
        this.setAvailableActions();
        Runnable runnable = new Runnable(){

            public void run() {
                ShiftSessionPanel.this.statusBar.setStatusText("Listing directory contents... ");
                try {
                    if (bl) {
                        ShiftSessionPanel.this.backStack.add(ShiftSessionPanel.this.model.getCurrentDirectory());
                    } else {
                        ShiftSessionPanel.this.forwardStack.add(ShiftSessionPanel.this.model.getCurrentDirectory());
                    }
                    ShiftSessionPanel.this.model.changeDirectory(string);
                    ShiftSessionPanel.this.updateAddress(ShiftSessionPanel.this.model.getCurrentDirectory());
                    ShiftSessionPanel.this.statusBar.setStatusText("Ready...");
                    ShiftSessionPanel.this.setAvailableActions();
                }
                catch (IOException iOException) {
                    SwingUtilities.invokeLater(new Runnable(this, iOException){
                        private final /* synthetic */ IOException val$ex;
                        private final /* synthetic */ 32 this$1;
                        {
                            this.this$1 = var1_1;
                            this.val$ex = iOException;
                        }

                        public void run() {
                            JOptionPane.showMessageDialog(32.access$1100(this.this$1), "Failed to change directory!\n" + this.val$ex.getMessage(), "SFTP Browser", 0);
                        }
                    });
                }
            }

            static /* synthetic */ ShiftSessionPanel access$1100(32 var0) {
                return var0.ShiftSessionPanel.this;
            }
        };
        Thread thread = new Thread(runnable);
        thread.start();
    }

    protected void removeSelected() {
        try {
            String string;
            if (this.listing.getSelectedRowCount() == 1 && JOptionPane.showConfirmDialog(this, string = this.model.isDirectory(this.listing.getSelectedRow()) ? "Are you sure you wish to remove the selected folder and all its contents?" : "Are you sure you wish to remove this file?", "Confirm Delete", 0) == 0) {
                this.statusBar.setStatusText("Deleting...");
                this.model.removeFile(this.listing.getSelectedRows());
            }
            if (this.listing.getSelectedRowCount() > 1) {
                boolean bl = false;
                int[] nArray = this.listing.getSelectedRows();
                int n = 0;
                while (n < nArray.length) {
                    if (this.model.isDirectory(nArray[n])) {
                        bl = true;
                        break;
                    }
                    ++n;
                }
                string = bl ? "Are you sure you wish to delete these " + String.valueOf(this.listing.getSelectedRowCount()) + " items and their contents?" : "Are you sure you wish to delete these " + String.valueOf(this.listing.getSelectedRowCount()) + " items?";
                if (JOptionPane.showConfirmDialog(this, string, "Confirm Multiple File Delete", 0) == 0) {
                    this.model.removeFile(this.listing.getSelectedRows());
                    this.setAvailableActions();
                }
            }
            this.statusBar.setStatusText("Ready...");
        }
        catch (IOException iOException) {
            this.statusBar.setStatusText("Ready...");
            JOptionPane.showMessageDialog(this, "Failed to change directory!\n" + iOException.getMessage(), "SFTP Browser", 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateAddress(String string) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (string.startsWith("/")) {
                this.isUpdating = true;
                StringTokenizer stringTokenizer = new StringTokenizer(string, "/");
                String string2 = "/";
                this.addressDropdown.removeAllItems();
                this.addressDropdown.addItem(new TokenizedPathElement("/", string2));
                String string3 = "  ";
                while (stringTokenizer.hasMoreElements()) {
                    String string4 = (String)stringTokenizer.nextElement();
                    string2 = string2 + (string2.trim().length() > 1 ? "/" : "") + string4;
                    this.addressDropdown.addItem(new TokenizedPathElement(string3 + string4, string2));
                    string3 = string3 + string3;
                }
            } else {
                throw new IOException("Path must be absolute!!!");
            }
            this.addressDropdown.setSelectedIndex(this.addressDropdown.getModel().getSize() - 1);
            this.isUpdating = false;
        }
    }

    public boolean postConnection() {
        return true;
    }

    public void setAvailableActions() {
        if (this.listing.getSelectedRowCount() == 0) {
            this.delete.setEnabled(false);
            this.properties.setEnabled(false);
            this.rename.setEnabled(false);
        } else {
            this.delete.setEnabled(true);
            this.properties.setEnabled(true);
            this.rename.setEnabled(true);
        }
        this.copyTo.setEnabled(true);
        this.copyFrom.setEnabled(true);
        this.up.setEnabled(true);
        this.newFolder.setEnabled(true);
        if (this.backStack.size() > 0) {
            this.back.setEnabled(true);
        } else {
            this.back.setEnabled(false);
        }
        if (this.forwardStack.size() > 0) {
            this.forward.setEnabled(true);
        } else {
            this.forward.setEnabled(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void close() {
        if (this.sftp == null) return;
        if (this.sftp.isClosed()) return;
        try {
            try {
                this.sftp.quit();
            }
            catch (Exception exception) {
                Object var3_2 = null;
                this.manager.requestDisconnect();
                return;
            }
            Object var3_1 = null;
            this.manager.requestDisconnect();
            return;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.manager.requestDisconnect();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean canClose() {
        Vector vector = this.activeOperations;
        synchronized (vector) {
            block7: {
                block8: {
                    block9: {
                        if (this.sftp == null || this.sftp.isClosed()) break block7;
                        if (this.activeOperations.size() <= 0) break block8;
                        if (JOptionPane.showConfirmDialog(this, "There are " + String.valueOf(this.activeOperations.size()) + " active file operations in progress!\n" + "Do you want to cancel these operations and close the session?", "Terminate Operations", 0, 3) != 0) break block9;
                        Iterator iterator = this.activeOperations.iterator();
                        while (iterator.hasNext()) {
                            FileTransferDialog fileTransferDialog = (FileTransferDialog)iterator.next();
                            fileTransferDialog.cancelOperation();
                        }
                        boolean bl = true;
                        return bl;
                    }
                    boolean bl = false;
                    return bl;
                }
                if (JOptionPane.showConfirmDialog(this, "Close the current session?", "Close Session", 0, 3) != 1) break block7;
                boolean bl = false;
                return bl;
            }
            boolean bl = true;
            return bl;
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    class TokenizedPathElement {
        String name;
        String path;

        TokenizedPathElement(String string, String string2) {
            this.name = string;
            this.path = string2;
        }

        public String toString() {
            return this.path;
        }
    }

    public class OutputStreamMonitor
    extends OutputStream
    implements ActionListener {
        Timer timer;
        OutputStream out;

        OutputStreamMonitor(OutputStream outputStream) {
            this.out = outputStream;
            this.timer = new Timer(500, this);
            this.timer.setRepeats(false);
        }

        public void write(int n) throws IOException {
            this.out.write(n);
            this.dataWritten(1);
        }

        public void write(byte[] byArray) throws IOException {
            this.out.write(byArray);
            this.dataWritten(byArray.length);
        }

        public void write(byte[] byArray, int n, int n2) throws IOException {
            this.out.write(byArray, n, n2);
            this.dataWritten(n2);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            ShiftSessionPanel.this.statusBar.setSending(false);
        }

        void dataWritten(int n) {
            if (!this.timer.isRunning()) {
                ShiftSessionPanel.this.statusBar.setSending(true);
                this.timer.start();
            }
        }
    }

    public class InputStreamMonitor
    extends InputStream
    implements ActionListener {
        Timer timer;
        InputStream in;

        InputStreamMonitor(InputStream inputStream) {
            this.in = inputStream;
            this.timer = new Timer(500, this);
            this.timer.setRepeats(false);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            ShiftSessionPanel.this.statusBar.setReceiving(false);
        }

        public int read() throws IOException {
            int n = this.in.read();
            this.dataRead(1);
            return n;
        }

        public int read(byte[] byArray) throws IOException {
            int n = this.in.read(byArray);
            this.dataRead(n);
            return n;
        }

        public int read(byte[] byArray, int n, int n2) throws IOException {
            int n3 = this.in.read(byArray, n, n2);
            this.dataRead(n3);
            return n3;
        }

        void dataRead(int n) {
            if (!this.timer.isRunning()) {
                ShiftSessionPanel.this.statusBar.setReceiving(true);
                this.timer.start();
            }
        }
    }

    class PopupListener
    extends MouseAdapter {
        JPopupMenu popup;

        PopupListener(JPopupMenu jPopupMenu) {
            this.popup = jPopupMenu;
        }

        public void mousePressed(MouseEvent mouseEvent) {
            this.maybeShowPopup(mouseEvent);
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            this.maybeShowPopup(mouseEvent);
        }

        private void maybeShowPopup(MouseEvent mouseEvent) {
            if (mouseEvent.isPopupTrigger()) {
                ShiftSessionPanel.this.back.setEnabled(ShiftSessionPanel.this.backStack.size() > 0);
                ShiftSessionPanel.this.forward.setEnabled(ShiftSessionPanel.this.forwardStack.size() > 0);
                ShiftSessionPanel.this.up.setEnabled(true);
                if (ShiftSessionPanel.this.listing.getSelectedRowCount() > 0) {
                    ShiftSessionPanel.this.delete.setEnabled(true);
                } else {
                    ShiftSessionPanel.this.delete.setEnabled(false);
                }
                this.popup.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
            }
        }
    }
}

