/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.sshterm;

import com.sshtools.common.ui.ResourceIcon;
import com.sshtools.common.ui.SshToolsApplication;
import com.sshtools.common.ui.SshToolsApplicationContainer;
import com.sshtools.common.ui.SshToolsApplicationException;
import com.sshtools.common.ui.SshToolsApplicationFrame;
import com.sshtools.common.ui.SshToolsApplicationPanel;
import com.sshtools.common.ui.StandardAction;
import com.sshtools.j2ssh.configuration.ConfigurationLoader;
import com.sshtools.sshterm.FullScreenAction;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SshTermFrame
extends SshToolsApplicationFrame {
    protected static Log log = LogFactory.getLog(class$com$sshtools$sshterm$SshTermFrame == null ? (class$com$sshtools$sshterm$SshTermFrame = SshTermFrame.class$("com.sshtools.sshterm.SshTermFrame")) : class$com$sshtools$sshterm$SshTermFrame);
    private StandardAction fullScreenAction;
    static /* synthetic */ Class class$com$sshtools$sshterm$SshTermFrame;

    public SshTermFrame() {
        this.setIconImage(new ResourceIcon("/com/sshtools/sshterm/sshframeicon.gif").getImage());
    }

    public void init(SshToolsApplication sshToolsApplication, SshToolsApplicationPanel sshToolsApplicationPanel) throws SshToolsApplicationException {
        super.init(sshToolsApplication, sshToolsApplicationPanel);
        GraphicsDevice graphicsDevice = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice();
        log.debug("Testing if " + graphicsDevice.getIDstring() + " can go full screen");
        try {
            Method method = graphicsDevice.getClass().getMethod("isFullScreenSupported", new Class[0]);
            if (((Boolean)method.invoke((Object)graphicsDevice, new Object[0])).booleanValue() || ConfigurationLoader.checkAndGetProperty("sshterm.enableFullScreen", "true").equals("true")) {
                log.info(graphicsDevice.getIDstring() + " can go full screen");
                this.addFullScreenActions();
            }
        }
        catch (SecurityException securityException) {
        }
        catch (NoSuchMethodException noSuchMethodException) {
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (InvocationTargetException invocationTargetException) {
            // empty catch block
        }
    }

    private void addFullScreenActions() {
        this.fullScreenAction = new FullScreenActionImpl(this.getApplication(), this);
        this.getApplicationPanel().registerAction(this.fullScreenAction);
        this.getApplicationPanel().rebuildActionComponents();
    }

    public void closeContainer() {
        this.getApplicationPanel().deregisterAction(this.fullScreenAction);
        super.closeContainer();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    class FullScreenActionImpl
    extends FullScreenAction {
        public FullScreenActionImpl(SshToolsApplication sshToolsApplication, SshToolsApplicationContainer sshToolsApplicationContainer) {
            super(sshToolsApplication, sshToolsApplicationContainer);
            this.putValue("onContextMenu", Boolean.TRUE);
            this.putValue("contextMenuGroup", new Integer(50));
            this.putValue("contextMenuWeight", new Integer(30));
        }
    }
}

