/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.sshterm;

import com.sshtools.common.configuration.InvalidProfileFileException;
import com.sshtools.common.configuration.SshToolsConnectionProfile;
import com.sshtools.common.keygen.Main;
import com.sshtools.common.mru.MRUAction;
import com.sshtools.common.mru.MRUListModel;
import com.sshtools.common.mru.MRUMenu;
import com.sshtools.common.ui.CloseAction;
import com.sshtools.common.ui.ConnectionPropertiesAction;
import com.sshtools.common.ui.DataNotificationListener;
import com.sshtools.common.ui.EditAction;
import com.sshtools.common.ui.OpenAction;
import com.sshtools.common.ui.Option;
import com.sshtools.common.ui.OptionsDialog;
import com.sshtools.common.ui.PreferencesStore;
import com.sshtools.common.ui.PrintPreview;
import com.sshtools.common.ui.RecordAction;
import com.sshtools.common.ui.RefreshAction;
import com.sshtools.common.ui.ResourceIcon;
import com.sshtools.common.ui.SaveAction;
import com.sshtools.common.ui.SaveAsAction;
import com.sshtools.common.ui.SessionProvider;
import com.sshtools.common.ui.SessionProviderAction;
import com.sshtools.common.ui.SessionProviderFactory;
import com.sshtools.common.ui.SessionProviderFrame;
import com.sshtools.common.ui.SshToolsApplication;
import com.sshtools.common.ui.SshToolsApplicationClientPanel;
import com.sshtools.common.ui.SshToolsApplicationContainer;
import com.sshtools.common.ui.SshToolsApplicationException;
import com.sshtools.common.ui.SshToolsApplicationPanel;
import com.sshtools.common.ui.SshToolsConnectionPanel;
import com.sshtools.common.ui.SshToolsConnectionTab;
import com.sshtools.common.ui.StandardAction;
import com.sshtools.common.ui.StatusBar;
import com.sshtools.common.ui.StopAction;
import com.sshtools.common.ui.UIUtil;
import com.sshtools.common.util.X11Util;
import com.sshtools.j2ssh.SshEventAdapter;
import com.sshtools.j2ssh.SshException;
import com.sshtools.j2ssh.connection.Channel;
import com.sshtools.j2ssh.connection.ChannelEventAdapter;
import com.sshtools.j2ssh.session.SessionChannelClient;
import com.sshtools.j2ssh.transport.TransportProtocol;
import com.sshtools.sshterm.ClearAction;
import com.sshtools.sshterm.CopyAction;
import com.sshtools.sshterm.KeygenAction;
import com.sshtools.sshterm.NewAction;
import com.sshtools.sshterm.PasteAction;
import com.sshtools.sshterm.PlayAction;
import com.sshtools.sshterm.PrintAction;
import com.sshtools.sshterm.PrintPreviewAction;
import com.sshtools.sshterm.SshTerm;
import com.sshtools.sshterm.SshTermCommandTab;
import com.sshtools.sshterm.SshTermTerminalTab;
import com.sshtools.sshterm.emulation.TerminalEmulation;
import com.sshtools.sshterm.emulation.TerminalListener;
import com.sshtools.sshterm.emulation.TerminalPanel;
import java.awt.AWTEvent;
import java.awt.AWTPermission;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.awt.print.PageFormat;
import java.awt.print.Paper;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilePermission;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StringReader;
import java.lang.reflect.Method;
import java.security.AccessControlException;
import java.security.AccessController;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JSeparator;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.TitledBorder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SshTerminalPanel
extends SshToolsApplicationClientPanel
implements ActionListener,
ClipboardOwner,
TerminalListener,
MouseMotionListener {
    public static final String PREF_SHIFT_GEOMETRY = "sshterm.shift.geometry";
    public static final String PREF_PORT_FORWARDING_GEOMETRY = "sshterm.portForwarding.geometry";
    public static final String PREF_PORT_FORWARDING_DIVIDER_LOCATION = "sshterm.portForwarding.dividerLocation";
    public static final String PREF_PORT_FORWARDING_FORWARDS_TABLE_METRICS = "sshterm.portForwarding.forwards.tableMetrics";
    public static final String PREF_PORT_FORWARDING_ACTIVE_TABLE_METRICS = "sshterm.portForwarding.active.tableMetrics";
    public static final String PREF_PAGE_FORMAT_IMAGEABLE_X = "sshterm.pageFormat.imageable.x";
    public static final String PREF_PAGE_FORMAT_IMAGEABLE_Y = "sshterm.pageFormat.imageable.y";
    public static final String PREF_PAGE_FORMAT_IMAGEABLE_W = "sshterm.pageFormat.imageable.w";
    public static final String PREF_PAGE_FORMAT_IMAGEABLE_H = "sshterm.pageFormat.imageable.h";
    public static final String PREF_PAGE_FORMAT_SIZE_W = "sshterm.pageFormat.size.w";
    public static final String PREF_PAGE_FORMAT_SIZE_H = "sshterm.pageFormat.size.h";
    public static final String PREF_PAGE_FORMAT_ORIENTATION = "sshterm.pageFormat.orientation";
    public static final String PREF_X11_FORWARDING = "sshterm.xForwarding";
    public static final String PREF_X11_FORWARDING_LOCAL_DISPLAY = "sshterm.xForwarding.localDisplay";
    public static final String PREF_X11_FORWARDING_REMOTE_DISPLAY_NUMBER = "sshterm.xForwarding.remoteDisplayNumber";
    public static final String PREF_MOUSE_WHEEL_INCREMENT = "sshterm.mouseWheelIncrement";
    public static final String PROFILE_PROPERTY_TERMINAL = "TERM";
    public static final String PROFILE_PROPERTY_EOL = "EOL";
    public static final String PROFILE_PROPERTY_SCREEN_SIZE = "TERM_SCREEN_SIZE";
    public static final String PROFILE_PROPERTY_RESIZE_STRATEGY = "RESIZE_STRATEGY";
    public static final String PROFILE_PROPERTY_ANTIALIAS = "ANTIALIAS";
    public static final String PROFILE_PROPERTY_FONT_SIZE = "FONT_SIZE";
    public static final String PROFILE_PROPERTY_BACKGROUND_COLOR = "BACKGROUND_COLOR";
    public static final String PROFILE_PROPERTY_FOREGROUND_COLOR = "FOREGROUND_COLOR";
    public static final String PROFILE_PROPERTY_COLOR_PRINTING = "COLOR_PRINTING";
    public static final int PROFILE_SCREEN_640_480 = 0;
    public static final int PROFILE_SCREEN_800_600 = 1;
    public static final int PROFILE_SCREEN_1024_768 = 2;
    private static final long VDU_EVENTS = 252L;
    static final String ABOUT_ICON = "/com/sshtools/sshterm/largessh.png";
    protected static Log log = LogFactory.getLog(class$com$sshtools$sshterm$SshTerminalPanel == null ? (class$com$sshtools$sshterm$SshTerminalPanel = SshTerminalPanel.class$("com.sshtools.sshterm.SshTerminalPanel")) : class$com$sshtools$sshterm$SshTerminalPanel);
    private JScrollBar scrollBar;
    private SessionChannelClient session;
    private int eol;
    private TerminalPanel terminal;
    private Main keygenFrame;
    private Vector actionMenus;
    private DataNotificationListener dataListener;
    private Vector sessionFrames = new Vector();
    private HashMap sessionActions = new HashMap();
    protected TerminalEmulation emulation;
    private NewAction newAction;
    private PrintPreviewAction printPreviewAction;
    private PrintAction printAction;
    private CloseAction closeAction;
    private CopyAction copyAction;
    private PasteAction pasteAction;
    private KeygenAction keygenAction;
    private ClearAction clearAction;
    private RefreshAction refreshAction;
    private PlayAction playAction;
    private StopAction stopAction;
    private RecordAction recordAction;
    private StandardAction shiftAction;
    private StandardAction tunnelingAction;
    private Vector actions;
    private PageFormat pageFormat;
    private OpenAction openAction;
    private EditAction editAction;
    private SaveAction saveAction;
    private SaveAsAction saveAsAction;
    private MRUActionImpl mruAction;
    private ConnectionPropertiesAction connectionPropertiesAction;
    private JSeparator toolSeparator;
    JPanel contentPane;
    private OutputStream recordingOutputStream;
    private File recordingFile;
    private StatusBar statusBar;
    private TitledBorder titledBorder1;
    private BorderLayout borderLayout1 = new BorderLayout();
    private boolean anyHost = true;
    private boolean anyUser = true;
    private boolean anyPort = true;
    private boolean dialogActionsEnabled;
    private boolean fullScreenMode;
    private boolean autoHideTools;
    private SshToolsConnectionTab[] additionalTabs;
    public static final ResourceIcon SSHTERM_ICON = new ResourceIcon(class$com$sshtools$sshterm$SshTerminalPanel == null ? (class$com$sshtools$sshterm$SshTerminalPanel = SshTerminalPanel.class$("com.sshtools.sshterm.SshTerminalPanel")) : class$com$sshtools$sshterm$SshTerminalPanel, "sshframeicon.gif");
    static /* synthetic */ Class class$com$sshtools$sshterm$SshTerminalPanel;
    static /* synthetic */ Class class$com$sshtools$sshterm$SshTermFrame;
    static /* synthetic */ Class class$com$sshtools$sshterm$SshTermFullScreenWindowContainer;
    static /* synthetic */ Class class$java$awt$Window;

    public void init(SshToolsApplication sshToolsApplication) throws SshToolsApplicationException {
        Object object;
        super.init(sshToolsApplication);
        this.additionalTabs = new SshToolsConnectionTab[]{new SshTermCommandTab(), new SshTermTerminalTab()};
        try {
            if (System.getSecurityManager() != null) {
                AccessController.checkPermission(new RuntimePermission("queuePrintJob"));
            }
            try {
                object = PrinterJob.getPrinterJob();
                if (object == null) {
                    throw new IOException("Could not get print page format.");
                }
                this.pageFormat = ((PrinterJob)object).defaultPage();
                if (PreferencesStore.preferenceExists(PREF_PAGE_FORMAT_ORIENTATION)) {
                    this.pageFormat.setOrientation(PreferencesStore.getInt(PREF_PAGE_FORMAT_ORIENTATION, 0));
                    Paper paper = new Paper();
                    paper.setImageableArea(PreferencesStore.getDouble(PREF_PAGE_FORMAT_IMAGEABLE_X, 0.0), PreferencesStore.getDouble(PREF_PAGE_FORMAT_IMAGEABLE_Y, 0.0), PreferencesStore.getDouble(PREF_PAGE_FORMAT_IMAGEABLE_W, 0.0), PreferencesStore.getDouble(PREF_PAGE_FORMAT_IMAGEABLE_H, 0.0));
                    paper.setSize(PreferencesStore.getDouble(PREF_PAGE_FORMAT_SIZE_W, 0.0), PreferencesStore.getDouble(PREF_PAGE_FORMAT_SIZE_H, 0.0));
                    this.pageFormat.setPaper(paper);
                }
            }
            catch (Exception exception) {
                this.showExceptionMessage("Error", exception.getMessage());
            }
        }
        catch (AccessControlException accessControlException) {
            accessControlException.printStackTrace();
        }
        this.enableEvents(252L);
        this.initActions();
        this.statusBar = new StatusBar();
        this.dataListener = new DataNotificationListener(this.statusBar);
        try {
            this.emulation = this.createEmulation();
        }
        catch (IOException iOException) {
            throw new SshToolsApplicationException(iOException);
        }
        this.emulation.addTerminalListener(this);
        this.scrollBar = new JScrollBar(1);
        this.emulation.setBufferSize(1000);
        this.terminal = new TerminalPanel(this.emulation){

            public void processEvent(AWTEvent aWTEvent) {
                if (aWTEvent instanceof MouseEvent && aWTEvent.getID() == 507) {
                    try {
                        Method method = aWTEvent.getClass().getMethod("getWheelRotation", new Class[0]);
                        SshTerminalPanel.this.scrollBar.setValue(SshTerminalPanel.this.scrollBar.getValue() + SshTerminalPanel.this.scrollBar.getUnitIncrement() * (Integer)method.invoke((Object)aWTEvent, new Object[0]) * PreferencesStore.getInt(SshTerminalPanel.PREF_MOUSE_WHEEL_INCREMENT, 1));
                    }
                    catch (Throwable throwable) {}
                } else {
                    super.processEvent(aWTEvent);
                }
            }
        };
        this.terminal.requestFocus();
        this.terminal.setScrollbar(this.scrollBar);
        this.terminal.addMouseMotionListener(this);
        object = new JPanel(new BorderLayout());
        ((JComponent)object).setBackground(Color.red);
        ((Container)object).add((Component)this.terminal, "Center");
        ((Container)object).add((Component)this.scrollBar, "East");
        this.terminal.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                if ((mouseEvent.getModifiers() & 4) > 0) {
                    SshTerminalPanel.this.getContextMenu().setLabel(SshTerminalPanel.this.getCurrentConnectionFile() == null ? SshTerminalPanel.this.getApplication().getApplicationName() : SshTerminalPanel.this.getCurrentConnectionFile().getName());
                    SshTerminalPanel.this.getContextMenu().show(SshTerminalPanel.this.terminal, mouseEvent.getX(), mouseEvent.getY());
                }
            }
        });
        this.setLayout(new BorderLayout());
        this.add((Component)object, "Center");
        this.terminal.requestFocus();
    }

    public StatusBar getStatusBar() {
        return this.statusBar;
    }

    public boolean setAutoHideTools(boolean bl) {
        if (this.autoHideTools != bl) {
            this.setToolBarVisible(!bl);
            this.setMenuBarVisible(!bl);
            this.setStatusBarVisible(!bl);
            this.setScrollBarVisible(!bl);
            this.autoHideTools = bl;
            return true;
        }
        return false;
    }

    public boolean isAutoHideTools() {
        return this.autoHideTools;
    }

    public boolean isScrollBarVisible() {
        return this.scrollBar != null && this.scrollBar.isVisible();
    }

    public void setScrollBarVisible(boolean bl) {
        if (this.scrollBar != null && this.scrollBar.isVisible() != bl) {
            this.scrollBar.setVisible(bl);
        }
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        if (this.isAutoHideTools()) {
            if (!this.isToolsVisible() && mouseEvent.getY() < 4) {
                this.setToolsVisible(true);
            } else if (this.isToolsVisible() && mouseEvent.getY() > 12) {
                this.setToolsVisible(false);
            }
            if (!this.scrollBar.isVisible() && mouseEvent.getX() > this.getWidth() - 4) {
                this.setScrollBarVisible(true);
            } else if (this.scrollBar.isVisible() && mouseEvent.getX() < this.getWidth() - 12) {
                this.setScrollBarVisible(false);
            }
        }
    }

    public void mouseDragged(MouseEvent mouseEvent) {
    }

    public void setFullScreenMode(boolean bl) {
        if (this.fullScreenMode != bl) {
            try {
                if (!bl) {
                    this.application.convertContainer(this.getContainer(), class$com$sshtools$sshterm$SshTermFrame == null ? (class$com$sshtools$sshterm$SshTermFrame = SshTerminalPanel.class$("com.sshtools.sshterm.SshTermFrame")) : class$com$sshtools$sshterm$SshTermFrame);
                } else {
                    this.application.convertContainer(this.getContainer(), class$com$sshtools$sshterm$SshTermFullScreenWindowContainer == null ? (class$com$sshtools$sshterm$SshTermFullScreenWindowContainer = SshTerminalPanel.class$("com.sshtools.sshterm.SshTermFullScreenWindowContainer")) : class$com$sshtools$sshterm$SshTermFullScreenWindowContainer);
                }
                this.requestFocus();
                this.fullScreenMode = bl;
            }
            catch (SshToolsApplicationException sshToolsApplicationException) {
                sshToolsApplicationException.printStackTrace();
                log.error(sshToolsApplicationException);
            }
            this.setAvailableActions();
        }
    }

    public ResourceIcon getIcon() {
        return SSHTERM_ICON;
    }

    public boolean isFullScreenMode() {
        return this.fullScreenMode;
    }

    public void requestFocus() {
        this.terminal.requestFocus();
    }

    public void registerAction(StandardAction standardAction) {
        super.registerAction(standardAction);
        standardAction.addActionListener(this);
    }

    public void lostOwnership(Clipboard clipboard, Transferable transferable) {
    }

    public void setAnyHost(boolean bl) {
        this.anyHost = bl;
    }

    public void setAnyUser(boolean bl) {
        this.anyUser = bl;
    }

    public void setAnyPort(boolean bl) {
        this.anyPort = bl;
    }

    public void screenResized(int n, int n2) {
        try {
            if (this.session != null) {
                this.session.changeTerminalDimensions(this.emulation);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void setToolsVisible(boolean bl) {
        super.setToolsVisible(bl);
        this.setScrollBarVisible(bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public void actionPerformed(ActionEvent var1_1) {
        block36: {
            var2_2 = var1_1.getActionCommand();
            if (this.sessionActions.containsKey(var1_1.getActionCommand())) {
                var3_3 = (SessionProviderAction)this.sessionActions.get(var1_1.getActionCommand());
                var5_4 = this.sessionFrames.iterator();
                while (var5_4.hasNext()) {
                    var4_6 = (SessionProviderFrame)var5_4.next();
                    if (!var3_3.getProvider().getProviderClass().isInstance(var4_6)) continue;
                    var4_6.show();
                    return;
                }
                try {
                    var4_6 = new SessionProviderFrame(this.getCurrentConnectionProfile(), this.ssh, var3_3.getProvider());
                    if (var4_6.initFrame(this.getApplication())) {
                        var4_6.show();
                        this.sessionFrames.add(var4_6);
                    }
                }
                catch (Throwable var6_9) {
                    // empty catch block
                }
            }
            if (this.stopAction != null && var2_2.equals(this.stopAction.getActionCommand())) {
                this.stopRecording();
            }
            if (this.recordAction != null && var2_2.equals(this.recordAction.getActionCommand())) {
                this.setFullScreenMode(false);
                var3_3 = new JFileChooser(System.getProperty("user.home"));
                var4_7 = var3_3.showSaveDialog(this);
                if (var4_7 == 0) {
                    this.recordingFile = var3_3.getSelectedFile();
                    if (this.recordingFile.exists() && JOptionPane.showConfirmDialog(this, "File exists. Are you sure?", "File exists", 0, 2) == 1) {
                        return;
                    }
                    try {
                        this.recordingOutputStream = new FileOutputStream(this.recordingFile);
                        this.statusBar.setStatusText("Recording to " + this.recordingFile.getName());
                        this.setAvailableActions();
                    }
                    catch (IOException var5_5) {
                        this.showExceptionMessage("Error", "Could not open file for recording\n\n" + var5_5.getMessage());
                    }
                }
            }
            if (this.playAction != null && var2_2.equals(this.playAction.getActionCommand())) {
                this.setFullScreenMode(false);
                var3_3 = new JFileChooser(System.getProperty("user.home"));
                var4_8 = var3_3.showOpenDialog(this);
                if (var4_8 == 0) {
                    var5_4 = var3_3.getSelectedFile();
                    var6_10 = null;
                    try {
                        this.statusBar.setStatusText("Playing from " + var5_4.getName());
                        var6_10 = new FileInputStream((File)var5_4);
                        var7_11 = null;
                        var8_13 = 0;
                        while ((var8_13 = var6_10.available()) != -1) {
                            if (var8_13 == 0) {
                                var8_13 = 1;
                            }
                            if ((var8_13 = var6_10.read(var7_11 = new byte[var8_13])) == -1) break;
                            this.emulation.getOutputStream().write(var7_11);
                        }
                        this.statusBar.setStatusText("Finished playing " + var5_4.getName());
                        this.setAvailableActions();
                        var10_14 = null;
                        ** if (var6_10 == null) goto lbl-1000
                    }
                    catch (Throwable var9_20) {
                        var10_16 = null;
                        if (var6_10 != null) {
                            try {
                                var6_10.close();
                            }
                            catch (IOException var11_19) {
                                SshTerminalPanel.log.error(var11_19);
                            }
                        }
                        throw var9_20;
                    }
lbl-1000:
                    // 1 sources

                    {
                        try {
                            var6_10.close();
                        }
                        catch (IOException var11_17) {
                            SshTerminalPanel.log.error(var11_17);
                        }
                    }
lbl-1000:
                    // 2 sources

                    {
                        break block36;
                        catch (IOException var7_12) {
                            this.statusBar.setStatusText("Error playing " + var5_4.getName());
                            this.showExceptionMessage("Error", "Could not open file for playback\n\n" + var7_12.getMessage());
                            var10_15 = null;
                            if (var6_10 != null) {
                                try {
                                    var6_10.close();
                                }
                                catch (IOException var11_18) {
                                    SshTerminalPanel.log.error(var11_18);
                                }
                            }
                        }
                    }
                }
            }
        }
        if (this.newAction != null && var2_2.equals(this.newAction.getActionCommand())) {
            this.setFullScreenMode(false);
            this.emulation.clearScreen();
            this.emulation.setCursorPosition(0, 0);
            this.terminal.refresh();
            var3_3 = SshToolsConnectionPanel.showConnectionDialog(this, this.getCurrentConnectionProfile(), this.getAdditionalConnectionTabs());
            if (var3_3 != null) {
                this.setContainerTitle(null);
                this.setNeedSave(true);
                this.connect((SshToolsConnectionProfile)var3_3, true);
            } else {
                SshTerminalPanel.log.info("New connection cancelled");
            }
            return;
        }
        if (this.closeAction != null && var2_2.equals(this.closeAction.getActionCommand()) && this.ssh != null && this.performVerifiedDisconnect(true)) {
            this.ssh.disconnect();
        }
        if (this.openAction != null && var2_2.equals(this.openAction.getActionCommand())) {
            this.open();
        }
        if (this.saveAction != null && var2_2.equals(this.saveAction.getActionCommand())) {
            this.saveConnection(false);
        }
        if (this.saveAsAction != null && var2_2.equals(this.saveAsAction.getActionCommand())) {
            this.saveConnection(true);
        }
        if (this.keygenAction != null && var1_1.getActionCommand().equals(this.keygenAction.getActionCommand())) {
            if (this.keygenFrame == null) {
                this.keygenFrame = new Main();
                this.keygenFrame.setDefaultCloseOperation(1);
                this.keygenFrame.pack();
                UIUtil.positionComponent(0, this.keygenFrame);
            }
            if (!this.keygenFrame.isVisible()) {
                this.setFullScreenMode(false);
            }
            this.keygenFrame.setVisible(this.keygenFrame.isVisible() == false);
        }
    }

    private boolean performVerifiedDisconnect(boolean bl) {
        SshToolsConnectionProfile sshToolsConnectionProfile = this.getCurrentConnectionProfile();
        if (sshToolsConnectionProfile.disconnectOnSessionClose()) {
            if (this.ssh.getForwardingClient().hasActiveConfigurations()) {
                return JOptionPane.showConfirmDialog(this, "There are currently active forwarding channels!\n\nThe profile is configured to disconnect when the session is closed. Closing\nthe connection will terminate these forwarding channels with unexpected results.\n\nDo you want to disconnect now?", "Auto disconnect", 0) == 0;
            }
            return true;
        }
        return bl;
    }

    public void open() {
        this.setFullScreenMode(false);
        super.open();
    }

    public void open(File file) {
        Object object;
        if (log.isDebugEnabled()) {
            log.debug("Opening connection file " + file);
        }
        if (this.isConnected()) {
            object = new Option("New", "New create a new terminal", 110);
            Option option = new Option("Close", "Close current connection", 108);
            Option option2 = new Option("Cancel", "Cancel the opening of this connection", 99);
            OptionsDialog optionsDialog = OptionsDialog.createOptionDialog(this, new Option[]{object, option, option2}, "You already have a connection open. Select\nClose to close the current connection, New\nto create a new terminal or Cancel to abort.", "Existing connection", (Option)object, null, UIManager.getIcon("OptionPane.warningIcon"));
            UIUtil.positionComponent(0, optionsDialog);
            optionsDialog.setVisible(true);
            Option option3 = optionsDialog.getSelectedOption();
            if (option3 == null || option3 == option2) {
                return;
            }
            if (option3 == object) {
                try {
                    SshToolsApplicationContainer sshToolsApplicationContainer = this.application.newContainer();
                    SshTerminalPanel sshTerminalPanel = (SshTerminalPanel)sshToolsApplicationContainer.getApplicationPanel();
                    sshTerminalPanel.open(file);
                    return;
                }
                catch (SshToolsApplicationException sshToolsApplicationException) {
                    log.error(sshToolsApplicationException);
                }
            } else {
                this.closeConnection(true);
            }
        }
        if (this.getApplication() instanceof SshTerm && ((SshTerm)this.getApplication()).getMRUModel() != null) {
            ((SshTerm)this.getApplication()).getMRUModel().add(file);
        }
        if (file != null) {
            object = new SshToolsConnectionProfile();
            try {
                ((SshToolsConnectionProfile)object).open(file.getAbsolutePath());
                this.setNeedSave(false);
                this.setCurrentConnectionFile(file);
                this.setContainerTitle(file);
                this.connect((SshToolsConnectionProfile)object, false);
            }
            catch (InvalidProfileFileException invalidProfileFileException) {
                this.showExceptionMessage("Open Connection", invalidProfileFileException.getMessage());
            }
            catch (SshException sshException) {
                sshException.printStackTrace();
                this.showExceptionMessage("Open Connection", "An unexpected error occured!");
            }
        } else {
            this.showExceptionMessage("Open Connection", "Invalid file specified");
        }
    }

    public void stopRecording() {
        try {
            this.recordingOutputStream.flush();
            this.recordingOutputStream.close();
            this.statusBar.setStatusText("Stopped recording to " + this.recordingFile.getName());
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.recordingOutputStream = null;
        this.setAvailableActions();
    }

    public boolean isConnected() {
        return this.session != null && super.isConnected();
    }

    public void closeConnection(boolean bl) {
        if (this.isConnected()) {
            super.closeConnection(bl);
        }
        if (bl) {
            try {
                if (this.session != null) {
                    this.session.close();
                }
                if (this.ssh != null && this.ssh.isConnected()) {
                    this.ssh.disconnect();
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
                this.showExceptionMessage("Disconnect", "An unexpected error occured!\n\n" + exception.getMessage());
            }
        }
        if (this.recordingOutputStream != null) {
            this.stopRecording();
        }
        this.emulation.reset();
        this.setAvailableActions();
        this.statusBar.setStatusText("Disconnected");
        this.statusBar.setHost("");
        this.statusBar.setUser("");
        this.statusBar.setRemoteId("");
        this.statusBar.setConnected(false);
        this.ssh = null;
        this.session = null;
        Iterator iterator = this.sessionFrames.iterator();
        while (iterator.hasNext()) {
            try {
                SessionProviderFrame sessionProviderFrame = (SessionProviderFrame)iterator.next();
                sessionProviderFrame.exit();
                sessionProviderFrame.dispose();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        this.sessionFrames.clear();
        this.setCurrentConnectionProfile(null);
        this.setNeedSave(false);
        this.setCurrentConnectionFile(null);
        this.setContainerTitle(this.getCurrentConnectionFile());
    }

    public File saveConnection(boolean bl, File file, SshToolsConnectionProfile sshToolsConnectionProfile) {
        if (sshToolsConnectionProfile != null && (file == null || bl)) {
            this.setFullScreenMode(false);
        }
        return super.saveConnection(bl, file, sshToolsConnectionProfile);
    }

    private void saveConnection(boolean bl) {
        File file = this.saveConnection(bl, this.getCurrentConnectionFile(), this.getCurrentConnectionProfile());
        if (file != null) {
            ((SshTerm)this.getApplication()).getMRUModel().add(file);
            this.setCurrentConnectionFile(file);
            this.setContainerTitle(file);
        }
    }

    public SshToolsConnectionTab[] getAdditionalConnectionTabs() {
        return this.additionalTabs;
    }

    public void editConnection() {
        this.setFullScreenMode(false);
        super.editConnection();
    }

    public boolean canClose() {
        if (this.session != null) {
            this.setFullScreenMode(false);
            if (JOptionPane.showConfirmDialog(this, "Close the current session and exit?", "Exit Application", 0, 3) == 1) {
                return false;
            }
        }
        return true;
    }

    public void printScreen() {
        try {
            PrinterJob printerJob = PrinterJob.getPrinterJob();
            printerJob.setPrintable(this.terminal, this.pageFormat);
            if (printerJob.printDialog()) {
                this.setCursor(Cursor.getPredefinedCursor(3));
                printerJob.print();
                this.setCursor(Cursor.getPredefinedCursor(0));
            }
        }
        catch (PrinterException printerException) {
            JOptionPane.showMessageDialog(this, printerException.getMessage(), "Error", 0);
        }
    }

    public void connect(SshToolsConnectionProfile sshToolsConnectionProfile, boolean bl) {
        this.emulation.clearScreen();
        this.emulation.setCursorPosition(0, 0);
        this.terminal.refresh();
        this.setTerminalProperties(sshToolsConnectionProfile);
        super.connect(sshToolsConnectionProfile, bl);
    }

    public boolean postConnection() {
        Window window = (Window)SwingUtilities.getAncestorOfClass(class$java$awt$Window == null ? (class$java$awt$Window = SshTerminalPanel.class$("java.awt.Window")) : class$java$awt$Window, this);
        if (window != null) {
            window.toFront();
        }
        this.terminal.requestFocus();
        return true;
    }

    public void authenticationComplete(boolean bl) throws SshException, IOException {
        SshToolsConnectionProfile sshToolsConnectionProfile = this.getCurrentConnectionProfile();
        this.statusBar.setStatusText("Connected");
        this.statusBar.setConnected(true);
        this.setAvailableActions();
        this.terminal.requestFocus();
        this.ssh.addEventHandler(new SshEventAdapter(){

            public void onDisconnect(TransportProtocol transportProtocol) {
                log.info("The connection has disconnected cleaning up");
                SshTerminalPanel.this.closeConnection(false);
            }
        });
        if (this.eol == 0) {
            if (this.ssh.getRemoteEOL() == 1) {
                this.emulation.setEOL(1);
            } else {
                this.emulation.setEOL(2);
            }
        }
        if (sshToolsConnectionProfile.getOnceAuthenticatedCommand() != 1) {
            if (sshToolsConnectionProfile.getOnceAuthenticatedCommand() == 3) {
                String string;
                BufferedReader bufferedReader = new BufferedReader(new StringReader(sshToolsConnectionProfile.getCommandsToExecute() + "\n"));
                while ((string = bufferedReader.readLine()) != null) {
                    if (string.trim().length() <= 0) continue;
                    log.info("Executing " + string);
                    this.session = this.createNewSession(false);
                    if (!this.session.executeCommand(string)) continue;
                    this.session.bindInputStream(this.emulation.getTerminalInputStream());
                    this.session.bindOutputStream(this.emulation.getTerminalOutputStream());
                    try {
                        this.session.getState().waitForState(3);
                    }
                    catch (InterruptedException interruptedException) {
                        JOptionPane.showMessageDialog(this, "The command was interrupted!", "Interrupted Exception", 0);
                    }
                }
                if (sshToolsConnectionProfile.disconnectOnSessionClose()) {
                    this.ssh.disconnect();
                }
            } else {
                this.session = this.createNewSession(true);
                if (this.session.startShell()) {
                    this.session.bindInputStream(this.emulation.getTerminalInputStream());
                    this.session.bindOutputStream(this.emulation.getTerminalOutputStream());
                }
            }
        }
    }

    private SessionChannelClient createNewSession(boolean bl) throws IOException {
        String string;
        int n;
        SessionChannelClient sessionChannelClient = this.ssh.openSessionChannel();
        sessionChannelClient.addEventListener(this.dataListener);
        if (bl) {
            sessionChannelClient.addEventListener(new ChannelEventAdapter(){

                public void onChannelClose(Channel channel) {
                    if (SshTerminalPanel.this.ssh != null && SshTerminalPanel.this.performVerifiedDisconnect(false)) {
                        SshTerminalPanel.this.ssh.disconnect();
                    }
                }
            });
        }
        if (this.getCurrentConnectionProfile().getApplicationPropertyBoolean(PREF_X11_FORWARDING, false) && !sessionChannelClient.requestX11Forwarding(n = this.getCurrentConnectionProfile().getApplicationPropertyInt(PREF_X11_FORWARDING_LOCAL_DISPLAY, 0), string = X11Util.getCookie(n))) {
            JOptionPane.showMessageDialog(this, "The server refused to start start X11 forwarding!", "Start X11 Forwarding", 0);
        }
        if (this.getCurrentConnectionProfile().getAllowAgentForwarding() && !sessionChannelClient.requestAgentForwarding()) {
            JOptionPane.showMessageDialog(this, "The server failed to open an agent listener", "Allow Agent Forwarding", 0, (Icon)UIManager.get("OptionPane.informationIcon"));
        }
        if (this.getCurrentConnectionProfile().requiresPseudoTerminal() && !sessionChannelClient.requestPseudoTerminal(this.emulation)) {
            JOptionPane.showMessageDialog(this, "The server refused to allocate a pseudo terminal!", "Request Pseudo Terminal", 0);
        }
        return sessionChannelClient;
    }

    private void setTerminalProperties(SshToolsConnectionProfile sshToolsConnectionProfile) {
        this.eol = sshToolsConnectionProfile.getApplicationPropertyInt(PROFILE_PROPERTY_EOL, 0);
        if (this.eol != 0) {
            this.emulation.setEOL(this.eol);
        }
        this.emulation.setTerminalType(sshToolsConnectionProfile.getApplicationProperty(PROFILE_PROPERTY_TERMINAL, "vt100"));
        this.terminal.setBackground(sshToolsConnectionProfile.getApplicationPropertyColor(PROFILE_PROPERTY_BACKGROUND_COLOR, Color.black));
        this.terminal.setForeground(sshToolsConnectionProfile.getApplicationPropertyColor(PROFILE_PROPERTY_FOREGROUND_COLOR, Color.white));
        this.terminal.setColorPrinting(sshToolsConnectionProfile.getApplicationPropertyBoolean(PROFILE_PROPERTY_COLOR_PRINTING, false));
        this.terminal.setAntialias(sshToolsConnectionProfile.getApplicationPropertyBoolean(PROFILE_PROPERTY_ANTIALIAS, false));
        int n = sshToolsConnectionProfile.getApplicationPropertyInt(PROFILE_PROPERTY_RESIZE_STRATEGY, 2);
        this.terminal.setResizeStrategy(n);
        if (n == 2) {
            this.terminal.setFont(this.terminal.getFont().deriveFont((float)sshToolsConnectionProfile.getApplicationPropertyInt(PROFILE_PROPERTY_FONT_SIZE, 12)));
        }
    }

    private void initActions() {
        this.registerActionMenu(new SshToolsApplicationPanel.ActionMenu("File", "File", 102, 0));
        this.registerActionMenu(new SshToolsApplicationPanel.ActionMenu("Edit", "Edit", 101, 10));
        this.registerActionMenu(new SshToolsApplicationPanel.ActionMenu("View", "View", 118, 20));
        this.registerActionMenu(new SshToolsApplicationPanel.ActionMenu("Help", "Help", 104, 90));
        this.actions = new Vector();
        if (this.getApplication().getMRUModel() != null) {
            this.mruAction = new MRUActionImpl(this.getApplication().getMRUModel());
            this.registerAction(this.mruAction);
        }
        this.connectionPropertiesAction = new ConnectionPropertiesActionImpl();
        this.registerAction(this.connectionPropertiesAction);
        this.newAction = new NewAction();
        this.registerAction(this.newAction);
        try {
            if (System.getSecurityManager() != null) {
                AccessController.checkPermission(new FilePermission("<<ALL FILES>>", "read"));
            }
            this.openAction = new OpenAction();
            this.registerAction(this.openAction);
            this.playAction = new PlayAction();
            this.registerAction(this.playAction);
        }
        catch (AccessControlException accessControlException) {
            log.warn("File reading actions are not available");
        }
        try {
            if (System.getSecurityManager() != null) {
                AccessController.checkPermission(new FilePermission("<<ALL FILES>>", "write"));
            }
            this.saveAction = new SaveAction();
            this.registerAction(this.saveAction);
            this.saveAsAction = new SaveAsAction();
            this.registerAction(this.saveAsAction);
            this.recordAction = new RecordAction();
            this.registerAction(this.recordAction);
            this.stopAction = new StopAction();
            this.registerAction(this.stopAction);
        }
        catch (AccessControlException accessControlException) {
            log.warn("File write actions are not available");
        }
        try {
            if (System.getSecurityManager() != null) {
                AccessController.checkPermission(new FilePermission("<<ALL FILES>>", "write"));
            }
            if (System.getSecurityManager() != null) {
                AccessController.checkPermission(new FilePermission("<<ALL FILES>>", "read"));
            }
            this.editAction = new EditActionImpl();
            this.registerAction(this.editAction);
        }
        catch (AccessControlException accessControlException) {
            log.warn("Read / write actions are not available");
        }
        if (this.pageFormat != null) {
            try {
                if (System.getSecurityManager() != null) {
                    AccessController.checkPermission(new RuntimePermission("queuePrintJob"));
                }
                this.printAction = new PrintActionImpl();
                this.registerAction(this.printAction);
                this.printPreviewAction = new PrintPreviewActionImpl();
                this.registerAction(this.printPreviewAction);
            }
            catch (AccessControlException accessControlException) {
                log.warn("Print actions are not available");
            }
        }
        this.refreshAction = new RefreshActionImpl();
        this.registerAction(this.refreshAction);
        this.closeAction = new CloseAction();
        this.registerAction(this.closeAction);
        try {
            if (System.getSecurityManager() != null) {
                AccessController.checkPermission(new AWTPermission("accessClipboard"));
            }
            this.copyAction = new CopyActionImpl();
            this.registerAction(this.copyAction);
            this.pasteAction = new PasteActionImpl();
            this.registerAction(this.pasteAction);
        }
        catch (AccessControlException accessControlException) {
            // empty catch block
        }
        try {
            if (System.getSecurityManager() != null) {
                AccessController.checkPermission(new FilePermission("<<ALL FILES>>", "write"));
            }
            this.keygenAction = new KeygenAction();
            this.registerAction(this.keygenAction);
        }
        catch (AccessControlException accessControlException) {
            log.warn("Keygen actions is not available");
        }
        this.clearAction = new ClearActionImpl();
        this.registerAction(this.clearAction);
        List list = SessionProviderFactory.getInstance().getSessionProviders();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            SessionProvider sessionProvider = (SessionProvider)iterator.next();
            SessionProviderAction sessionProviderAction = new SessionProviderAction(sessionProvider);
            this.sessionActions.put(sessionProviderAction.getActionCommand(), sessionProviderAction);
            this.registerAction(sessionProviderAction);
        }
    }

    public void setDialogActionsEnabled(boolean bl) {
        this.dialogActionsEnabled = bl;
        this.setAvailableActions();
    }

    public void setAvailableActions() {
        boolean bl = this.isConnected();
        Iterator iterator = this.sessionActions.values().iterator();
        while (iterator.hasNext()) {
            SessionProviderAction sessionProviderAction = (SessionProviderAction)iterator.next();
            sessionProviderAction.setEnabled(bl);
        }
        if (this.newAction != null) {
            this.newAction.setEnabled(!bl);
        }
        if (this.openAction != null) {
            this.openAction.setEnabled(true);
        }
        if (this.connectionPropertiesAction != null) {
            this.connectionPropertiesAction.setEnabled(bl);
        }
        if (this.closeAction != null) {
            this.closeAction.setEnabled(bl);
        }
        if (this.saveAction != null) {
            this.saveAction.setEnabled(bl && this.isNeedSave());
        }
        if (this.saveAsAction != null) {
            this.saveAsAction.setEnabled(bl);
        }
        if (this.recordAction != null) {
            this.recordAction.setEnabled(bl && this.recordingOutputStream == null);
        }
        if (this.recordAction != null) {
            this.playAction.setEnabled(bl);
        }
        if (this.recordAction != null) {
            this.stopAction.setEnabled(this.recordingOutputStream != null);
        }
        if (this.shiftAction != null) {
            this.shiftAction.setEnabled(bl);
        }
        if (this.tunnelingAction != null) {
            this.tunnelingAction.setEnabled(bl);
        }
    }

    private TerminalEmulation createEmulation() throws IOException {
        return new TerminalEmulation("vt320");
    }

    public void showExceptionMessage(String string, String string2) {
        this.setFullScreenMode(false);
        super.showExceptionMessage(string, string2);
    }

    public void close() {
        if (this.pageFormat != null) {
            PreferencesStore.putDouble(PREF_PAGE_FORMAT_IMAGEABLE_X, this.pageFormat.getImageableX());
            PreferencesStore.putDouble(PREF_PAGE_FORMAT_IMAGEABLE_Y, this.pageFormat.getImageableY());
            PreferencesStore.putDouble(PREF_PAGE_FORMAT_IMAGEABLE_W, this.pageFormat.getImageableWidth());
            PreferencesStore.putDouble(PREF_PAGE_FORMAT_IMAGEABLE_H, this.pageFormat.getImageableHeight());
            PreferencesStore.putDouble(PREF_PAGE_FORMAT_SIZE_W, this.pageFormat.getWidth());
            PreferencesStore.putDouble(PREF_PAGE_FORMAT_SIZE_H, this.pageFormat.getHeight());
            PreferencesStore.putInt(PREF_PAGE_FORMAT_ORIENTATION, this.pageFormat.getOrientation());
        }
        if (this.mruAction != null) {
            this.mruAction.cleanUp();
        }
        if (this.ssh != null && this.ssh.isConnected()) {
            this.ssh.disconnect();
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    class RefreshActionImpl
    extends RefreshAction {
        RefreshActionImpl() {
            this.putValue("onContextMenu", Boolean.TRUE);
            this.putValue("contextMenuGroup", new Integer(50));
            this.putValue("contextMenuWeight", new Integer(20));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            SshTerminalPanel.this.emulation.update[0] = true;
            SshTerminalPanel.this.terminal.redraw();
        }
    }

    class ClearActionImpl
    extends ClearAction {
        ClearActionImpl() {
            this.putValue("onContextMenu", Boolean.TRUE);
            this.putValue("contextMenuGroup", new Integer(20));
            this.putValue("contextMenuWeight", new Integer(0));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            SshTerminalPanel.this.emulation.clearScreen();
            SshTerminalPanel.this.emulation.setCursorPosition(0, 0);
            SshTerminalPanel.this.terminal.refresh();
        }
    }

    class PasteActionImpl
    extends PasteAction {
        PasteActionImpl() {
            this.putValue("onContextMenu", Boolean.TRUE);
            this.putValue("contextMenuGroup", new Integer(10));
            this.putValue("contextMenuWeight", new Integer(10));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Transferable transferable = Toolkit.getDefaultToolkit().getSystemClipboard().getContents(SshTerminalPanel.this);
            if (transferable.isDataFlavorSupported(DataFlavor.stringFlavor)) {
                try {
                    SshTerminalPanel.this.emulation.getOutputStream().write(transferable.getTransferData(DataFlavor.stringFlavor).toString().getBytes());
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    class CopyActionImpl
    extends CopyAction {
        CopyActionImpl() {
            this.putValue("onContextMenu", Boolean.TRUE);
            this.putValue("contextMenuGroup", new Integer(10));
            this.putValue("contextMenuWeight", new Integer(0));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Toolkit.getDefaultToolkit().getSystemClipboard().setContents(new StringSelection(SshTerminalPanel.this.terminal.getSelection()), SshTerminalPanel.this);
        }
    }

    class ConnectionPropertiesActionImpl
    extends ConnectionPropertiesAction {
        public ConnectionPropertiesActionImpl() {
            this.putValue("onContextMenu", Boolean.TRUE);
            this.putValue("contextMenuGroup", new Integer(50));
            this.putValue("contextMenuWeight", new Integer(45));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (SshTerminalPanel.this.editConnection(SshTerminalPanel.this.getCurrentConnectionProfile())) {
                SshTerminalPanel.this.setTerminalProperties(SshTerminalPanel.this.getCurrentConnectionProfile());
            }
        }
    }

    class EditActionImpl
    extends EditAction {
        EditActionImpl() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            SshTerminalPanel.this.editConnection();
        }
    }

    class PrintActionImpl
    extends PrintAction {
        PrintActionImpl() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            SshTerminalPanel.this.printScreen();
        }
    }

    class MRUActionImpl
    extends MRUAction {
        public MRUActionImpl(MRUListModel mRUListModel) {
            super(mRUListModel);
        }

        public void cleanUp() {
            ((MRUMenu)this.getValue("menu")).cleanUp();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            SshTerminalPanel.this.open(new File(actionEvent.getActionCommand()));
        }
    }

    class PrintPreviewActionImpl
    extends PrintPreviewAction {
        PrintPreviewActionImpl() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            PrintPreview printPreview = new PrintPreview(SshTerminalPanel.this.terminal, SshTerminalPanel.this.pageFormat);
            Option option = new Option("Print", "Print the screen", 112);
            Option option2 = new Option("Close", "Close this dialog", 99);
            OptionsDialog optionsDialog = OptionsDialog.createOptionDialog(SshTerminalPanel.this, new Option[]{option, option2}, printPreview, "Print Preview", option2, null, null);
            optionsDialog.pack();
            UIUtil.positionComponent(0, optionsDialog);
            optionsDialog.setVisible(true);
            if (optionsDialog.getSelectedOption() == option) {
                SshTerminalPanel.this.printScreen();
            }
        }
    }
}

