/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.sshterm.emulation;

import com.sshtools.sshterm.emulation.SoftFont;
import com.sshtools.sshterm.emulation.VDUBuffer;
import com.sshtools.sshterm.emulation.VDUDisplay;
import com.sshtools.sshterm.emulation.VDUInput;
import java.awt.AWTEventMulticaster;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import javax.swing.JComponent;
import javax.swing.JScrollBar;

public class TerminalPanel
extends JComponent
implements VDUDisplay,
KeyListener,
MouseListener,
MouseMotionListener,
Printable {
    private static final int debug = 0;
    private static final long VDU_EVENTS = 131260L;
    public static final int RESIZE_NONE = 0;
    public static final int RESIZE_FONT = 1;
    public static final int RESIZE_SCREEN = 2;
    public static final int COLOR_BOLD = 8;
    public static final int COLOR_INVERT = 9;
    private static final int COLOR_FG_STD = 7;
    private static final int COLOR_BG_STD = 0;
    private VDUBuffer buffer;
    private Insets insets;
    private boolean raised;
    private Font normalFont;
    private FontMetrics fm;
    private int charWidth;
    private int charHeight;
    private int charDescent;
    private int resizeStrategy;
    private Point selectBegin;
    private Point selectEnd;
    private String selection;
    protected JScrollBar scrollBar;
    private SoftFont sf = new SoftFont();
    private boolean colorPrinting = false;
    private Image backingStore = null;
    private boolean antialias;
    private Color[] color = new Color[]{Color.black, Color.red, Color.green, Color.yellow, Color.blue, Color.magenta, Color.cyan, Color.white, null, null};
    private Color cursorColorFG = null;
    private Color cursorColorBG = null;
    private MouseListener mouseListener;
    private MouseMotionListener mouseMotionListener;
    private KeyListener keyListener;
    FocusListener focusListener;
    static /* synthetic */ Class class$com$sshtools$sshterm$emulation$TerminalPanel;

    public TerminalPanel(VDUBuffer vDUBuffer, Font font) {
        this.setVDUBuffer(vDUBuffer);
        this.addKeyListener(this);
        String string = System.getProperty("java.version");
        if (string.startsWith("1.4")) {
            try {
                Class[] classArray = new Class[]{Boolean.TYPE};
                (class$com$sshtools$sshterm$emulation$TerminalPanel == null ? (class$com$sshtools$sshterm$emulation$TerminalPanel = TerminalPanel.class$("com.sshtools.sshterm.emulation.TerminalPanel")) : class$com$sshtools$sshterm$emulation$TerminalPanel).getMethod("setFocusable", classArray).invoke((Object)this, new Boolean(true));
                (class$com$sshtools$sshterm$emulation$TerminalPanel == null ? (class$com$sshtools$sshterm$emulation$TerminalPanel = TerminalPanel.class$("com.sshtools.sshterm.emulation.TerminalPanel")) : class$com$sshtools$sshterm$emulation$TerminalPanel).getMethod("setFocusTraversalKeysEnabled", classArray).invoke((Object)this, new Boolean(false));
            }
            catch (Exception exception) {
                System.err.println("vt320: unable to reset focus handling for java version " + string);
                exception.printStackTrace();
            }
        }
        this.enableEvents(131260L);
        this.setResizeStrategy(1);
        this.setFont(font);
        this.setForeground(Color.white);
        this.setBackground(Color.black);
        this.cursorColorFG = this.color[7];
        this.cursorColorBG = this.color[0];
        this.clearSelection();
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.selection = null;
    }

    public TerminalPanel(VDUBuffer vDUBuffer) {
        this(vDUBuffer, new Font("Monospaced", 0, 11));
    }

    private Color brighten(Color color) {
        int n = (int)this.min((double)color.getRed() * 1.2, 255.0);
        int n2 = (int)this.min((double)color.getGreen() * 1.2, 255.0);
        int n3 = (int)this.min((double)color.getBlue() * 1.2, 255.0);
        return new Color(n, n2, n3);
    }

    private Color darken(Color color) {
        int n = (int)this.max((double)color.getRed() * 0.8, 0.0);
        int n2 = (int)this.max((double)color.getGreen() * 0.8, 0.0);
        int n3 = (int)this.max((double)color.getBlue() * 0.8, 0.0);
        return new Color(n, n2, n3);
    }

    protected double max(double d, double d2) {
        return d < d2 ? d2 : d;
    }

    protected double min(double d, double d2) {
        return d < d2 ? d : d2;
    }

    public void setAntialias(boolean bl) {
        this.antialias = bl;
        this.repaint();
    }

    public boolean isAntialias() {
        return this.antialias;
    }

    public void setVDUBuffer(VDUBuffer vDUBuffer) {
        this.buffer = vDUBuffer;
        vDUBuffer.setDisplay(this);
    }

    public VDUBuffer getVDUBuffer() {
        return this.buffer;
    }

    public void setColorSet(Color[] colorArray) {
        System.arraycopy(colorArray, 0, this.color, 0, 10);
        this.buffer.update[0] = true;
        this.redraw();
    }

    public Color[] getColorSet() {
        return this.color;
    }

    public void setFont(Font font) {
        this.normalFont = font;
        super.setFont(this.normalFont);
        this.fm = this.getFontMetrics(font);
        if (this.fm != null) {
            this.charWidth = this.fm.charWidth('@');
            this.charHeight = this.fm.getHeight();
            this.charDescent = this.fm.getDescent();
        }
        if (this.buffer.update != null) {
            this.buffer.update[0] = true;
        }
        this.redraw();
    }

    public void setResizeStrategy(int n) {
        this.resizeStrategy = n;
        this.setBounds(this.getBounds());
    }

    public void setBorder(int n, boolean bl) {
        this.insets = n == 0 ? null : new Insets(n + 1, n + 1, n + 1, n + 1);
        this.raised = bl;
    }

    public void setScrollbar(JScrollBar jScrollBar) {
        if (jScrollBar == null) {
            return;
        }
        this.scrollBar = jScrollBar;
        this.scrollBar.setValues(this.buffer.windowBase, this.buffer.height, 0, this.buffer.bufSize - this.buffer.height - 1);
        this.scrollBar.addAdjustmentListener(new AdjustmentListener(){

            public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
                TerminalPanel.this.buffer.setWindowBase(adjustmentEvent.getValue());
            }
        });
    }

    public void redraw() {
        if (this.backingStore != null) {
            this.redraw(this.backingStore.getGraphics());
            this.repaint();
        }
    }

    /*
     * Unable to fully structure code
     */
    protected void redraw(Graphics var1_1) {
        var2_2 = (Graphics2D)var1_1;
        if (this.isAntialias()) {
            var2_2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        }
        var3_3 = (super.getSize().width - this.buffer.width * this.charWidth) / 2;
        var4_4 = (super.getSize().height - this.buffer.height * this.charHeight) / 2;
        var5_5 = this.selectBegin.y - this.buffer.windowBase;
        var6_6 = this.selectEnd.y - this.buffer.windowBase;
        var7_7 = this.color[7];
        var8_8 = this.color[0];
        var2_2.setFont(this.normalFont);
        var9_9 = 0;
        while (var9_9 < this.buffer.height) {
            block24: {
                if (!this.buffer.update[0] && !this.buffer.update[var9_9 + 1]) break block24;
                this.buffer.update[var9_9 + 1] = false;
                var10_10 = 0;
                while (var10_10 < this.buffer.width) {
                    block25: {
                        var11_11 = 0;
                        var12_12 = this.buffer.charAttributes[this.buffer.windowBase + var9_9][var10_10];
                        var7_7 = this.getForeground();
                        var8_8 = this.getBackground();
                        if ((var12_12 & 240) != 0) {
                            var7_7 = this.darken(this.color[((var12_12 & 240) >> 4) - 1]);
                        }
                        if ((var12_12 & 3840) != 0) {
                            var8_8 = this.darken(this.darken(this.color[((var12_12 & 3840) >> 8) - 1]));
                        }
                        if ((var12_12 & 1) != 0) {
                            var2_2.setFont(new Font(this.normalFont.getName(), 1, this.normalFont.getSize()));
                            if (null != this.color[8]) {
                                var7_7 = this.color[8];
                            }
                        } else {
                            var2_2.setFont(this.normalFont);
                        }
                        if ((var12_12 & 8) != 0) {
                            var7_7 = this.darken(var7_7);
                        }
                        if ((var12_12 & 4) != 0) {
                            if (null == this.color[9]) {
                                var13_13 = var8_8;
                                var8_8 = var7_7;
                                var7_7 = var13_13;
                            } else {
                                var7_7 = null == this.color[8] ? var8_8 : this.color[8];
                                var8_8 = this.color[9];
                            }
                        }
                        if (!this.sf.inSoftFont(this.buffer.charArray[this.buffer.windowBase + var9_9][var10_10])) ** GOTO lbl58
                        var2_2.setColor(var8_8);
                        var2_2.fillRect(var10_10 * this.charWidth + var3_3, var9_9 * this.charHeight + var4_4, this.charWidth, this.charHeight);
                        var2_2.setColor(var7_7);
                        this.sf.drawChar(var2_2, this.buffer.charArray[this.buffer.windowBase + var9_9][var10_10], var3_3 + var10_10 * this.charWidth, var9_9 * this.charHeight + var4_4, this.charWidth, this.charHeight);
                        if ((var12_12 & 2) == 0) break block25;
                        var2_2.drawLine(var10_10 * this.charWidth + var3_3, (var9_9 + 1) * this.charHeight - this.charDescent / 2 + var4_4, var10_10 * this.charWidth + this.charWidth + var3_3, (var9_9 + 1) * this.charHeight - this.charDescent / 2 + var4_4);
                        break block25;
lbl-1000:
                        // 1 sources

                        {
                            if (this.buffer.charArray[this.buffer.windowBase + var9_9][var10_10 + var11_11] < ' ') {
                                this.buffer.charArray[this.buffer.windowBase + var9_9][var10_10 + var11_11] = 32;
                                this.buffer.charAttributes[this.buffer.windowBase + var9_9][var10_10 + var11_11] = 0;
                                continue;
                            }
                            ++var11_11;
lbl58:
                            // 3 sources

                            ** while (var10_10 + var11_11 < this.buffer.width && (this.buffer.charArray[this.buffer.windowBase + var9_9][var10_10 + var11_11] < ' ' || this.buffer.charAttributes[this.buffer.windowBase + var9_9][var10_10 + var11_11] == var12_12) && !this.sf.inSoftFont((char)this.buffer.charArray[this.buffer.windowBase + var9_9][var10_10 + var11_11]))
                        }
lbl59:
                        // 1 sources

                        var2_2.setColor(var8_8);
                        var2_2.fillRect(var10_10 * this.charWidth + var3_3, var9_9 * this.charHeight + var4_4, var11_11 * this.charWidth, this.charHeight);
                        var2_2.setColor(var7_7);
                        var2_2.drawChars(this.buffer.charArray[this.buffer.windowBase + var9_9], var10_10, var11_11, var10_10 * this.charWidth + var3_3, (var9_9 + 1) * this.charHeight - this.charDescent + var4_4);
                        if ((var12_12 & 2) != 0) {
                            var2_2.drawLine(var10_10 * this.charWidth + var3_3, (var9_9 + 1) * this.charHeight - this.charDescent / 2 + var4_4, var10_10 * this.charWidth + var11_11 * this.charWidth + var3_3, (var9_9 + 1) * this.charHeight - this.charDescent / 2 + var4_4);
                        }
                        var10_10 += var11_11 - 1;
                    }
                    ++var10_10;
                }
                if (var9_9 >= var5_5 && var9_9 <= var6_6) {
                    v0 = var11_11 = var9_9 == var5_5 ? this.selectBegin.x : 0;
                    v1 = var9_9 == var6_6 ? (var9_9 == var5_5 ? this.selectEnd.x : this.selectEnd.x) : (var12_12 = this.buffer.width);
                    if (var11_11 != var12_12) {
                        var2_2.setXORMode(var8_8);
                        var2_2.fillRect(var11_11 * this.charWidth + var3_3, var9_9 * this.charHeight + var4_4, (var12_12 - var11_11) * this.charWidth, this.charHeight);
                        var2_2.setPaintMode();
                    }
                }
            }
            ++var9_9;
        }
        if (this.buffer.showcursor && this.buffer.screenBase + this.buffer.cursorY >= this.buffer.windowBase && this.buffer.screenBase + this.buffer.cursorY < this.buffer.windowBase + this.buffer.height) {
            var2_2.setColor(this.cursorColorFG);
            var2_2.setXORMode(this.cursorColorBG);
            var2_2.fillRect(this.buffer.cursorX * this.charWidth + var3_3, (this.buffer.cursorY + this.buffer.screenBase - this.buffer.windowBase) * this.charHeight + var4_4, this.charWidth, this.charHeight);
            var2_2.setPaintMode();
            var2_2.setColor(this.color[7]);
        }
        if (this.insets != null) {
            var2_2.setColor(this.getBackground());
            --var3_3;
            --var4_4;
            var10_10 = this.insets.top - 1;
            while (var10_10 >= 0) {
                var2_2.draw3DRect(var3_3 - var10_10, var4_4 - var10_10, this.charWidth * this.buffer.width + 1 + var10_10 * 2, this.charHeight * this.buffer.height + 1 + var10_10 * 2, this.raised);
                --var10_10;
            }
        }
        this.buffer.update[0] = false;
    }

    public void paint(Graphics graphics) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        if (this.isAntialias()) {
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        }
        if (this.backingStore == null) {
            Dimension dimension = super.getSize();
            this.backingStore = this.createImage(dimension.width, dimension.height);
            this.buffer.update[0] = true;
            this.redraw();
            Graphics graphics2 = this.backingStore.getGraphics();
            graphics2.setColor(this.getBackground());
            graphics2.fillRect(0, 0, super.getSize().width, super.getSize().height);
        }
        graphics2D.drawImage(this.backingStore, 0, 0, this);
    }

    public void setColorPrinting(boolean bl) {
        this.colorPrinting = bl;
    }

    public int print(Graphics graphics, PageFormat pageFormat, int n) throws PrinterException {
        this.print(graphics);
        return n == 0 ? 0 : 1;
    }

    public void print(Graphics graphics) {
        int n = 0;
        while (n <= this.buffer.height) {
            this.buffer.update[n] = true;
            ++n;
        }
        Color color = null;
        Color color2 = null;
        Color[] colorArray = null;
        if (!this.colorPrinting) {
            color = this.getForeground();
            color2 = this.getBackground();
            this.setForeground(Color.black);
            this.setBackground(Color.white);
            colorArray = this.color;
            this.color = new Color[]{Color.black, Color.black, Color.black, Color.black, Color.black, Color.black, Color.black, Color.white, null, null};
        }
        this.redraw(graphics);
        if (!this.colorPrinting) {
            this.color = colorArray;
            this.setForeground(color);
            this.setBackground(color2);
        }
    }

    public Point mouseGetPos(Point point) {
        Point point2 = new Point(0, 0);
        int n = (super.getSize().width - this.buffer.width * this.charWidth) / 2;
        int n2 = (super.getSize().height - this.buffer.height * this.charHeight) / 2;
        point2.x = (point.x - n) / this.charWidth;
        if (point2.x < 0) {
            point2.x = 0;
        }
        if (point2.x >= this.buffer.width) {
            point2.x = this.buffer.width - 1;
        }
        point2.y = (point.y - n2) / this.charHeight;
        if (point2.y < 0) {
            point2.y = 0;
        }
        if (point2.y >= this.buffer.height) {
            point2.y = this.buffer.height - 1;
        }
        return point2;
    }

    public void setCursorColors(Color color, Color color2) {
        this.cursorColorFG = color == null ? this.color[7] : color;
        this.cursorColorBG = color2 == null ? this.color[0] : color2;
        this.repaint();
    }

    public void setBounds(int n, int n2, int n3, int n4) {
        super.setBounds(n, n2, n3, n4);
        if (n == 0 && n2 == 0 && n3 == 0 && n4 == 0) {
            return;
        }
        if (this.insets != null) {
            n3 -= this.insets.left + this.insets.right;
            n4 -= this.insets.top + this.insets.bottom;
        }
        Font font = this.normalFont;
        String string = font.getName();
        int n5 = font.getStyle();
        this.fm = this.getFontMetrics(this.normalFont);
        if (this.fm != null) {
            this.charWidth = this.fm.charWidth('@');
            this.charHeight = this.fm.getHeight();
        }
        switch (this.resizeStrategy) {
            case 2: {
                this.buffer.setScreenSize(n3 / this.charWidth, n4 / this.charHeight);
                break;
            }
            case 1: {
                int n6 = n4 / this.buffer.height;
                int n7 = n3 / this.buffer.width;
                this.normalFont = new Font(string, n5, this.charHeight);
                this.fm = this.getFontMetrics(this.normalFont);
                if (this.fm.getHeight() < n6 || this.fm.charWidth('@') < n7) {
                    do {
                        this.normalFont = new Font(string, n5, ++this.charHeight);
                        this.fm = this.getFontMetrics(this.normalFont);
                    } while (this.fm.getHeight() < n6 || this.fm.charWidth('@') < n7);
                }
                if (this.fm.getHeight() > n6 || this.fm.charWidth('@') > n7) {
                    do {
                        this.normalFont = new Font(string, n5, --this.charHeight);
                        this.fm = this.getFontMetrics(this.normalFont);
                    } while (this.charHeight > 1 && (this.fm.getHeight() > n6 || this.fm.charWidth('@') > n7));
                }
                if (this.charHeight <= 1) {
                    System.err.println("VDU: error during resize, resetting to default");
                    this.normalFont = new Font(string, n5, 10);
                    System.err.println("VDU: disabling font/screen resize");
                }
                this.setFont(this.normalFont);
                this.fm = this.getFontMetrics(this.normalFont);
                this.charWidth = this.fm.charWidth('@');
                this.charHeight = this.fm.getHeight();
                this.charDescent = this.fm.getDescent();
                break;
            }
        }
        Dimension dimension = super.getSize();
        if (dimension.width <= 0) {
            dimension.width = 1;
        }
        if (dimension.height <= 0) {
            dimension.height = 1;
        }
        this.backingStore = this.createImage(dimension.width, dimension.height);
        if (this.backingStore != null) {
            Graphics graphics = this.backingStore.getGraphics();
            graphics.setColor(this.getBackground());
            graphics.fillRect(0, 0, dimension.width, dimension.height);
            this.buffer.update[0] = true;
            this.redraw();
        }
    }

    public void refresh() {
        this.backingStore = null;
        this.repaint();
    }

    public Dimension getSize() {
        int n = 0;
        int n2 = 0;
        if (this.insets != null) {
            n = this.insets.left + this.insets.right;
            n2 = this.insets.top + this.insets.bottom;
        }
        return new Dimension(this.buffer.width * this.charWidth + n, this.buffer.height * this.charHeight + n2);
    }

    public Dimension getPreferredSize() {
        return this.getSize();
    }

    public Insets getInsets() {
        return this.insets;
    }

    public void clearSelection() {
        this.selectBegin = new Point(0, 0);
        this.selectEnd = new Point(0, 0);
        this.selection = null;
    }

    public String getSelection() {
        return this.selection;
    }

    public JScrollBar getScrollBar() {
        return this.scrollBar;
    }

    private boolean buttonCheck(int n, int n2) {
        return (n & n2) == n2;
    }

    public void mouseMoved(MouseEvent mouseEvent) {
    }

    private void selectWord(int n, int n2) {
        int n3 = (super.getSize().width - this.buffer.width * this.charWidth) / 2;
        int n4 = (super.getSize().height - this.buffer.height * this.charHeight) / 2;
        n = (n - n3) / this.charWidth;
        n2 = (n2 - n4) / this.charHeight + this.buffer.windowBase;
        char[] cArray = this.buffer.charArray[n2];
        int n5 = n;
        while (n5 >= 0 && cArray[n5] != ' ') {
            --n5;
        }
        if (n5 != n) {
            this.selectBegin.y = n2;
            this.selectBegin.x = n5 + 1;
            this.selectEnd.y = n2;
            int n6 = n;
            while (n6 < cArray.length && cArray[n6] != ' ') {
                ++n6;
            }
            this.selectEnd.x = n6;
            this.buildSelectionText();
            this.buffer.update[0] = true;
            this.redraw();
        }
    }

    private void selectLine(int n, int n2) {
        int n3 = (super.getSize().width - this.buffer.width * this.charWidth) / 2;
        int n4 = (super.getSize().height - this.buffer.height * this.charHeight) / 2;
        n = (n - n3) / this.charWidth;
        n2 = (n2 - n4) / this.charHeight + this.buffer.windowBase;
        char[] cArray = this.buffer.charArray[n2];
        int n5 = 0;
        while (n5 < cArray.length && cArray[n5] == ' ') {
            ++n5;
        }
        if (n5 < cArray.length) {
            int n6 = cArray.length - 1;
            this.selectBegin.y = n2;
            this.selectEnd.y = n2;
            this.selectBegin.x = n5;
            while (n6 >= 0 && cArray[n6] == ' ') {
                --n6;
            }
            this.selectEnd.x = n6 + 1;
            this.buildSelectionText();
            this.buffer.update[0] = true;
            this.redraw();
        }
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        if (this.buttonCheck(mouseEvent.getModifiers(), 16) || mouseEvent.getModifiers() == 0) {
            int n = (super.getSize().width - this.buffer.width * this.charWidth) / 2;
            int n2 = (super.getSize().height - this.buffer.height * this.charHeight) / 2;
            int n3 = (mouseEvent.getX() - n) / this.charWidth;
            int n4 = (mouseEvent.getY() - n2) / this.charHeight + this.buffer.windowBase;
            int n5 = this.selectEnd.x;
            int n6 = this.selectEnd.y;
            if (n3 <= this.selectBegin.x && n4 <= this.selectBegin.y && n3 >= 0) {
                this.selectBegin.x = n3;
                this.selectBegin.y = n4;
            } else {
                if (n3 <= this.buffer.width && n3 >= 0) {
                    this.selectEnd.x = n3;
                }
                this.selectEnd.y = n4;
            }
            if (n5 != n3 || n6 != n4) {
                this.buffer.update[0] = true;
                this.redraw();
            }
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        if (mouseEvent.getClickCount() == 2) {
            this.selectWord(mouseEvent.getX(), mouseEvent.getY());
        } else if (mouseEvent.getClickCount() == 3) {
            this.selectLine(mouseEvent.getX(), mouseEvent.getY());
        } else {
            this.requestFocus();
        }
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
        this.requestFocus();
        int n = (super.getSize().width - this.buffer.width * this.charWidth) / 2;
        int n2 = (super.getSize().height - this.buffer.height * this.charHeight) / 2;
        if (this.buffer instanceof VDUInput) {
            ((VDUInput)((Object)this.buffer)).mousePressed(n, n2, mouseEvent.getModifiers());
        }
        if (this.buttonCheck(mouseEvent.getModifiers(), 16)) {
            this.selectBegin.x = (mouseEvent.getX() - n) / this.charWidth;
            this.selectBegin.y = (mouseEvent.getY() - n2) / this.charHeight + this.buffer.windowBase;
            this.selectEnd.x = this.selectBegin.x;
            this.selectEnd.y = this.selectBegin.y;
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        int n = (super.getSize().width - this.buffer.width * this.charWidth) / 2;
        int n2 = (super.getSize().height - this.buffer.height * this.charHeight) / 2;
        if (this.buffer instanceof VDUInput) {
            ((VDUInput)((Object)this.buffer)).mousePressed(n, n2, mouseEvent.getModifiers());
        }
        if (this.buttonCheck(mouseEvent.getModifiers(), 16)) {
            this.mouseDragged(mouseEvent);
            if (this.selectBegin.x == this.selectEnd.x && this.selectBegin.y == this.selectEnd.y) {
                this.buffer.update[0] = true;
                this.redraw();
                return;
            }
            if (this.selectEnd.x < 0) {
                this.selectEnd.x = 0;
            }
            if (this.selectEnd.y < 0) {
                this.selectEnd.y = 0;
            }
            if (this.selectEnd.y >= this.buffer.charArray.length) {
                this.selectEnd.y = this.buffer.charArray.length - 1;
            }
            if (this.selectEnd.x > this.buffer.charArray[0].length) {
                this.selectEnd.x = this.buffer.charArray[0].length;
            }
            this.buildSelectionText();
        }
    }

    private void buildSelectionText() {
        this.selection = "";
        int n = this.selectBegin.y;
        while (n <= this.selectEnd.y) {
            int n2;
            int n3;
            n3 = n == this.selectBegin.y ? (n3 = this.selectBegin.x) : 0;
            n2 = n == this.selectEnd.y ? (n2 = this.selectEnd.x) : this.buffer.charArray[n].length;
            this.selection = this.selection + ("-" + new String(this.buffer.charArray[n]).substring(n3, n2)).trim().substring(1);
            if (n2 == this.buffer.charArray[n].length) {
                this.selection = this.selection + "\n";
            }
            ++n;
        }
    }

    public void keyTyped(KeyEvent keyEvent) {
        if (this.buffer != null) {
            ((VDUInput)((Object)this.buffer)).keyTyped(keyEvent.getKeyCode(), keyEvent.getKeyChar(), this.getModifiers(keyEvent));
        }
    }

    public void keyPressed(KeyEvent keyEvent) {
        if (this.buffer != null) {
            ((VDUInput)((Object)this.buffer)).keyPressed(keyEvent.getKeyCode(), keyEvent.getKeyChar(), this.getModifiers(keyEvent));
        }
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    public void addMouseListener(MouseListener mouseListener) {
        this.mouseListener = AWTEventMulticaster.add(this.mouseListener, mouseListener);
        this.enableEvents(16L);
    }

    public void removeMouseListener(MouseListener mouseListener) {
        this.mouseListener = AWTEventMulticaster.remove(this.mouseListener, mouseListener);
    }

    public void addMouseMotionListener(MouseMotionListener mouseMotionListener) {
        this.mouseMotionListener = AWTEventMulticaster.add(this.mouseMotionListener, mouseMotionListener);
        this.enableEvents(16L);
    }

    public void removeMouseMotionListener(MouseMotionListener mouseMotionListener) {
        this.mouseMotionListener = AWTEventMulticaster.remove(this.mouseMotionListener, mouseMotionListener);
    }

    public void processMouseEvent(MouseEvent mouseEvent) {
        if (this.mouseListener != null) {
            switch (mouseEvent.getID()) {
                case 500: {
                    this.mouseListener.mouseClicked(mouseEvent);
                    break;
                }
                case 504: {
                    this.mouseListener.mouseEntered(mouseEvent);
                    break;
                }
                case 505: {
                    this.mouseListener.mouseExited(mouseEvent);
                    break;
                }
                case 501: {
                    this.mouseListener.mousePressed(mouseEvent);
                    break;
                }
                case 502: {
                    this.mouseListener.mouseReleased(mouseEvent);
                }
            }
        }
        super.processMouseEvent(mouseEvent);
    }

    public void processMouseMotionEvent(MouseEvent mouseEvent) {
        if (this.mouseMotionListener != null) {
            switch (mouseEvent.getID()) {
                case 506: {
                    this.mouseMotionListener.mouseDragged(mouseEvent);
                    break;
                }
                case 503: {
                    this.mouseMotionListener.mouseMoved(mouseEvent);
                }
            }
        }
        super.processMouseMotionEvent(mouseEvent);
    }

    public void addKeyListener(KeyListener keyListener) {
        this.keyListener = AWTEventMulticaster.add(this.keyListener, keyListener);
        this.enableEvents(8L);
    }

    public void removeKeyListener(KeyListener keyListener) {
        this.keyListener = AWTEventMulticaster.remove(this.keyListener, keyListener);
    }

    public void processKeyEvent(KeyEvent keyEvent) {
        if (this.keyListener != null) {
            switch (keyEvent.getID()) {
                case 401: {
                    this.keyListener.keyPressed(keyEvent);
                    break;
                }
                case 402: {
                    this.keyListener.keyReleased(keyEvent);
                    break;
                }
                case 400: {
                    this.keyListener.keyTyped(keyEvent);
                }
            }
        }
        if (keyEvent.getKeyCode() == 9 && keyEvent.getSource() == this) {
            keyEvent.consume();
        }
        super.processKeyEvent(keyEvent);
    }

    public void addFocusListener(FocusListener focusListener) {
        this.focusListener = AWTEventMulticaster.add(this.focusListener, focusListener);
    }

    public void removeFocusListener(FocusListener focusListener) {
        this.focusListener = AWTEventMulticaster.remove(this.focusListener, focusListener);
    }

    public void processFocusEvent(FocusEvent focusEvent) {
        if (this.focusListener != null) {
            switch (focusEvent.getID()) {
                case 1004: {
                    this.focusListener.focusGained(focusEvent);
                    break;
                }
                case 1005: {
                    this.focusListener.focusLost(focusEvent);
                }
            }
        }
        super.processFocusEvent(focusEvent);
    }

    private int getModifiers(KeyEvent keyEvent) {
        return (keyEvent.isControlDown() ? 1 : 0) | (keyEvent.isShiftDown() ? 2 : 0) | (keyEvent.isAltDown() ? 4 : 0) | (keyEvent.isActionKey() ? 8 : 0);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

