/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.j2ssh.agent;

import com.sshtools.j2ssh.io.ByteArrayReader;
import com.sshtools.j2ssh.io.ByteArrayWriter;
import com.sshtools.j2ssh.subsystem.SubsystemMessage;
import com.sshtools.j2ssh.transport.InvalidMessageException;
import com.sshtools.j2ssh.transport.publickey.SshKeyPairFactory;
import com.sshtools.j2ssh.transport.publickey.SshPublicKey;
import java.io.IOException;

public class SshAgentPrivateKeyOp
extends SubsystemMessage {
    public static final int SSH_AGENT_PRIVATE_KEY_OP = 205;
    SshPublicKey pubkey;
    String operation;
    byte[] data;

    public SshAgentPrivateKeyOp() {
        super(205);
    }

    public SshAgentPrivateKeyOp(SshPublicKey sshPublicKey, String string, byte[] byArray) {
        super(205);
        this.pubkey = sshPublicKey;
        this.operation = string;
        this.data = byArray;
    }

    public SshPublicKey getPublicKey() {
        return this.pubkey;
    }

    public String getOperation() {
        return this.operation;
    }

    public byte[] getOperationData() {
        return this.data;
    }

    public String getMessageName() {
        return "SSH_AGENT_PRIVATE_KEY_OP";
    }

    public void constructByteArray(ByteArrayWriter byteArrayWriter) throws InvalidMessageException, IOException {
        try {
            byteArrayWriter.writeString(this.operation);
            byteArrayWriter.writeBinaryString(this.pubkey.getEncoded());
            byteArrayWriter.write(this.data);
        }
        catch (IOException iOException) {
            throw new InvalidMessageException(iOException.getMessage());
        }
    }

    public void constructMessage(ByteArrayReader byteArrayReader) throws InvalidMessageException, IOException {
        try {
            this.operation = byteArrayReader.readString();
            this.pubkey = SshKeyPairFactory.decodePublicKey(byteArrayReader.readBinaryString());
            this.data = new byte[byteArrayReader.available()];
            byteArrayReader.read(this.data);
        }
        catch (IOException iOException) {
            throw new InvalidMessageException(iOException.getMessage());
        }
    }
}

