/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.j2ssh.ant;

import com.sshtools.j2ssh.SshClient;
import com.sshtools.j2ssh.ant.Exec;
import com.sshtools.j2ssh.ant.Sftp;
import com.sshtools.j2ssh.authentication.PasswordAuthenticationClient;
import com.sshtools.j2ssh.authentication.PublicKeyAuthenticationClient;
import com.sshtools.j2ssh.authentication.SshAuthenticationClient;
import com.sshtools.j2ssh.configuration.ConfigurationLoader;
import com.sshtools.j2ssh.configuration.SshConnectionProperties;
import com.sshtools.j2ssh.connection.Channel;
import com.sshtools.j2ssh.session.SessionChannelClient;
import com.sshtools.j2ssh.sftp.FileAttributes;
import com.sshtools.j2ssh.sftp.SftpFile;
import com.sshtools.j2ssh.sftp.SftpFileInputStream;
import com.sshtools.j2ssh.sftp.SftpFileOutputStream;
import com.sshtools.j2ssh.sftp.SftpSubsystemClient;
import com.sshtools.j2ssh.subsystem.SubsystemClient;
import com.sshtools.j2ssh.transport.AbstractHostKeyVerification;
import com.sshtools.j2ssh.transport.HostKeyVerification;
import com.sshtools.j2ssh.transport.InvalidHostFileException;
import com.sshtools.j2ssh.transport.cipher.SshCipherFactory;
import com.sshtools.j2ssh.transport.hmac.SshHmacFactory;
import com.sshtools.j2ssh.transport.publickey.SshPrivateKey;
import com.sshtools.j2ssh.transport.publickey.SshPrivateKeyFile;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.AbstractList;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;

public class Ssh
extends Task {
    protected String host;
    protected int port = 22;
    protected String username;
    protected String password;
    protected String keyfile;
    protected String passphrase;
    protected String cipher;
    protected String mac;
    protected String fingerprint;
    protected String logfile = "ssh.log";
    protected boolean verifyhost = true;
    protected boolean always = false;
    protected SshClient ssh;
    protected Vector tasks = new Vector();
    protected String sshtoolsHome;

    public void addConfiguredSftp(Sftp sftp) {
        this.tasks.add(sftp);
    }

    public void addConfiguredExec(Exec exec) {
        this.tasks.add(exec);
    }

    public void execute() throws BuildException {
        try {
            Object object;
            Object object2;
            Object object3;
            if (this.host == null) {
                throw new BuildException("You must provide a host to connect to!");
            }
            if (this.username == null) {
                throw new BuildException("You must supply a username for authentication!");
            }
            if (this.password == null && this.keyfile == null) {
                throw new BuildException("You must supply either a password or keyfile/passphrase to authenticate!");
            }
            if (this.verifyhost && this.fingerprint == null) {
                throw new BuildException("Public key fingerprint required to verify the host");
            }
            if (System.getProperty("sshtools.home") == null && this.sshtoolsHome == null) {
                throw new BuildException("System property sshtools.home is not set either use");
            }
            if (this.sshtoolsHome != null) {
                System.setProperty("sshtools.home", this.sshtoolsHome);
            }
            this.log("Initializing J2SSH");
            if (this.logfile != null) {
                System.setProperty("sshtools.logfile", this.logfile);
            }
            ConfigurationLoader.initialize(false);
            this.log(String.valueOf(String.valueOf(new StringBuffer("Creating connection to ").append(this.host).append(":").append(String.valueOf(this.port)))));
            if (this.ssh == null) {
                int n;
                this.ssh = new SshClient();
                object3 = new SshConnectionProperties();
                ((SshConnectionProperties)object3).setHost(this.host);
                ((SshConnectionProperties)object3).setPort(this.port);
                ((SshConnectionProperties)object3).setUsername(this.username);
                if (this.cipher != null) {
                    if (SshCipherFactory.getSupportedCiphers().contains(this.cipher)) {
                        ((SshConnectionProperties)object3).setPrefSCEncryption(this.cipher);
                        ((SshConnectionProperties)object3).setPrefCSEncryption(this.cipher);
                    } else {
                        this.log(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(this.cipher))).append(" is not a supported cipher, using default ").append(SshCipherFactory.getDefaultCipher()))));
                    }
                }
                if (this.mac != null) {
                    if (SshHmacFactory.getSupportedMacs().contains(this.mac)) {
                        ((SshConnectionProperties)object3).setPrefCSMac(this.mac);
                        ((SshConnectionProperties)object3).setPrefSCMac(this.mac);
                    } else {
                        this.log(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(this.mac))).append(" is not a supported mac, using default ").append(SshHmacFactory.getDefaultHmac()))));
                    }
                }
                this.log("Connecting....");
                this.ssh.connect((SshConnectionProperties)object3, (HostKeyVerification)new AbstractHostKeyVerification(){

                    public void onUnknownHost(String string, String string2) throws InvalidHostFileException {
                        if (Ssh.this.verifyhost) {
                            if (string2.equalsIgnoreCase(Ssh.this.fingerprint)) {
                                this.allowHost(string, string2, Ssh.this.always);
                            }
                        } else {
                            this.allowHost(string, string2, Ssh.this.always);
                        }
                    }

                    public void onHostKeyMismatch(String string, String string2, String string3) throws InvalidHostFileException {
                        if (Ssh.this.verifyhost) {
                            if (string3.equalsIgnoreCase(Ssh.this.fingerprint)) {
                                this.allowHost(string, string3, Ssh.this.always);
                            }
                        } else {
                            this.allowHost(string, string3, Ssh.this.always);
                        }
                    }

                    public void onDeniedHost(String string) {
                        Ssh.this.log("The server host key is denied!");
                    }
                });
                boolean bl = false;
                this.log("Authenticating ".concat(String.valueOf(String.valueOf(this.username))));
                if (this.keyfile != null) {
                    this.log("Performing public key authentication");
                    object2 = new PublicKeyAuthenticationClient();
                    object = SshPrivateKeyFile.parse(new File(this.keyfile));
                    if (((SshPrivateKeyFile)object).isPassphraseProtected() && this.passphrase == null) {
                        throw new BuildException("Private key file is passphrase protected, please supply a valid passphrase!");
                    }
                    SshPrivateKey sshPrivateKey = ((SshPrivateKeyFile)object).toPrivateKey(this.passphrase);
                    ((SshAuthenticationClient)object2).setUsername(this.username);
                    ((PublicKeyAuthenticationClient)object2).setKey(sshPrivateKey);
                    n = this.ssh.authenticate((SshAuthenticationClient)object2);
                    if (n == 4) {
                        bl = true;
                    } else if (n == 3) {
                        this.log("Public key authentication completed, attempting password authentication");
                    } else {
                        throw new BuildException("Public Key Authentication failed!");
                    }
                }
                if (this.password != null && !bl) {
                    this.log("Performing password authentication");
                    object2 = new PasswordAuthenticationClient();
                    ((SshAuthenticationClient)object2).setUsername(this.username);
                    ((PasswordAuthenticationClient)object2).setPassword(this.password);
                    n = this.ssh.authenticate((SshAuthenticationClient)object2);
                    if (n == 4) {
                        this.log("Authentication complete");
                    } else {
                        if (n == 3) {
                            throw new BuildException("Password Authentication succeeded but further authentication required!");
                        }
                        throw new BuildException("Password Authentication failed!");
                    }
                }
            }
            object3 = this.ssh.openSessionChannel();
            Channel channel = null;
            SubsystemClient subsystemClient = null;
            object2 = ((AbstractList)this.tasks).iterator();
            while (object2.hasNext()) {
                object = object2.next();
                if (object instanceof Exec) {
                    object3 = this.ssh.openSessionChannel();
                    this.executeCommand((SessionChannelClient)object3, (Exec)object);
                    if (!((Channel)object3).isClosed()) {
                        ((Channel)object3).close();
                    }
                }
                if (!(object instanceof Sftp)) continue;
                if (subsystemClient == null && !((SessionChannelClient)(channel = this.ssh.openSessionChannel())).startSubsystem(subsystemClient = new SftpSubsystemClient())) {
                    throw new BuildException("Failed to start the SFTP subsystem");
                }
                this.executeSFTP((SftpSubsystemClient)subsystemClient, (Sftp)object);
            }
            if (subsystemClient != null) {
                subsystemClient.stop();
            }
            if (channel != null) {
                channel.close();
            }
            this.log("Disconnecting from ".concat(String.valueOf(String.valueOf(this.host))));
            this.ssh.disconnect();
        }
        catch (IOException iOException) {
            throw new BuildException("SSH Connection failed: ".concat(String.valueOf(String.valueOf(iOException.getMessage()))));
        }
    }

    public void setUsername(String string) {
        this.username = string;
    }

    public void setPassword(String string) {
        this.password = string;
    }

    public void setPort(int n) {
        this.port = n;
    }

    public void setHost(String string) {
        this.host = string;
    }

    public void setKeyfile(String string) {
        this.keyfile = string;
    }

    public void setPassphrase(String string) {
        this.passphrase = string;
    }

    public void setCipher(String string) {
        this.cipher = string;
    }

    public void setMac(String string) {
        this.mac = string;
    }

    public void setLogfile(String string) {
        this.logfile = string;
    }

    public void setVerifyhost(boolean bl) {
        this.verifyhost = bl;
    }

    public void setAlways(boolean bl) {
        this.always = bl;
    }

    public void setSshtoolshome(String string) {
        this.sshtoolsHome = string;
    }

    public void executeSFTP(SftpSubsystemClient sftpSubsystemClient, Sftp sftp) throws BuildException {
        Closeable closeable;
        Object object;
        Object object2;
        Object object3;
        Object object4;
        String string;
        Object object5;
        sftp.validate();
        String string2 = sftp.getRmdir();
        if (string2 != null) {
            this.log("Deleting directory ".concat(String.valueOf(String.valueOf(string2))));
            try {
                object5 = sftpSubsystemClient.openDirectory(string2);
                ((SftpFile)object5).close();
                sftpSubsystemClient.removeDirectory(string2);
                this.log("Deleted directory");
            }
            catch (IOException iOException) {
                this.log("Directory does not exist!");
            }
        }
        if ((object5 = sftp.getMkdir()) != null) {
            this.log("Creating directory ".concat(String.valueOf(String.valueOf(object5))));
            try {
                sftpSubsystemClient.openDirectory((String)object5);
                this.log("Directory already exists!");
            }
            catch (IOException iOException) {
                try {
                    sftpSubsystemClient.makeDirectory((String)object5);
                    this.log("Directory created");
                }
                catch (IOException iOException2) {
                    this.log("mkdir failed: ".concat(String.valueOf(String.valueOf(iOException2.getMessage()))));
                }
            }
        }
        if ((string = sftp.getDelete()) != null) {
            this.log("Deleting file ".concat(String.valueOf(String.valueOf(string))));
            try {
                object4 = sftpSubsystemClient.openFile(string, 1);
                ((SftpFile)object4).close();
                sftpSubsystemClient.removeFile(string);
                this.log("File deleted");
            }
            catch (IOException iOException) {
                this.log("File does not exist!");
            }
        }
        object4 = sftp.getGet();
        String string3 = sftp.getDest();
        String string4 = sftp.getPut();
        String string5 = sftp.getPermissions();
        if (object4 != null && string3 != null) {
            this.log(String.valueOf(String.valueOf(new StringBuffer("Getting ").append((String)object4).append(" into ").append(string3))));
            try {
                int n;
                object3 = sftpSubsystemClient.openFile((String)object4, 1);
                object2 = new byte[65535];
                object = new BufferedInputStream(new SftpFileInputStream((SftpFile)object3));
                closeable = new BufferedOutputStream(new FileOutputStream(string3));
                while ((n = ((FilterInputStream)object).read((byte[])object2)) != -1) {
                    ((BufferedOutputStream)closeable).write((byte[])object2, 0, n);
                }
                ((BufferedInputStream)object).close();
                ((FilterOutputStream)closeable).close();
                this.log("Get complete");
            }
            catch (IOException iOException) {
                this.log("get failed: ".concat(String.valueOf(String.valueOf(iOException.getMessage()))));
            }
        }
        if (string4 != null && string3 != null) {
            this.log(String.valueOf(String.valueOf(new StringBuffer("Putting ").append(string4).append(" into ").append(string3))));
            try {
                int n;
                object3 = new FileAttributes();
                this.log(String.valueOf(String.valueOf(new StringBuffer("Creating ").append(string3).append(" with default rw permissions"))));
                ((FileAttributes)object3).setPermissions("rw");
                object2 = sftpSubsystemClient.openFile(string3, 26, (FileAttributes)object3);
                if (string5 != null) {
                    this.log(String.valueOf(String.valueOf(new StringBuffer("Setting ").append(string4).append(" permissions to ").append(string5))));
                    object3 = sftpSubsystemClient.getAttributes((SftpFile)object2);
                    ((FileAttributes)object3).setPermissions(string5);
                    sftpSubsystemClient.setAttributes((SftpFile)object2, (FileAttributes)object3);
                }
                object = new byte[65535];
                closeable = new BufferedInputStream(new FileInputStream(string4));
                BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new SftpFileOutputStream((SftpFile)object2));
                while ((n = ((FilterInputStream)closeable).read((byte[])object)) != -1) {
                    bufferedOutputStream.write((byte[])object, 0, n);
                }
                ((BufferedInputStream)closeable).close();
                bufferedOutputStream.close();
                this.log("Put complete");
            }
            catch (IOException iOException) {
                this.log("put failed: ".concat(String.valueOf(String.valueOf(iOException.getMessage()))));
            }
        }
    }

    public void executeCommand(SessionChannelClient sessionChannelClient, Exec exec) throws BuildException {
        try {
            try {
                String string;
                exec.validate();
                this.log("Executing ".concat(String.valueOf(String.valueOf(exec.getCmd()))));
                sessionChannelClient.executeCommand(exec.getCmd());
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(sessionChannelClient.getInputStream()));
                while ((string = bufferedReader.readLine()) != null && !sessionChannelClient.isClosed()) {
                    this.log(string);
                }
                Integer n = sessionChannelClient.getExitCode();
                if (n != null && n != 0) {
                    throw new BuildException("Exit code ".concat(String.valueOf(String.valueOf(n.toString()))));
                }
                Object var7_7 = null;
            }
            catch (IOException iOException) {
                throw new BuildException("The session failed: ".concat(String.valueOf(String.valueOf(iOException.getMessage()))));
            }
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            throw throwable;
        }
    }
}

