/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.j2ssh.authentication;

import com.sshtools.j2ssh.authentication.AuthenticationProtocolException;
import com.sshtools.j2ssh.authentication.SshAuthenticationClient;
import com.sshtools.j2ssh.authentication.SshMsgUserAuthBanner;
import com.sshtools.j2ssh.authentication.SshMsgUserAuthFailure;
import com.sshtools.j2ssh.authentication.SshMsgUserAuthRequest;
import com.sshtools.j2ssh.authentication.SshMsgUserAuthSuccess;
import com.sshtools.j2ssh.authentication.TerminatedStateException;
import com.sshtools.j2ssh.transport.MessageNotAvailableException;
import com.sshtools.j2ssh.transport.MessageStoreEOFException;
import com.sshtools.j2ssh.transport.Service;
import com.sshtools.j2ssh.transport.ServiceOperationException;
import com.sshtools.j2ssh.transport.SshMessage;
import java.io.IOException;
import java.util.List;
import org.apache.log4j.Logger;

public class AuthenticationProtocolClient
extends Service {
    private static Logger log = Logger.getLogger((Class)(class$com$sshtools$j2ssh$authentication$AuthenticationProtocolClient == null ? (class$com$sshtools$j2ssh$authentication$AuthenticationProtocolClient = AuthenticationProtocolClient.class$("com.sshtools.j2ssh.authentication.AuthenticationProtocolClient")) : class$com$sshtools$j2ssh$authentication$AuthenticationProtocolClient));
    private int[] resultFilter = new int[2];
    private int[] singleIdFilter = new int[3];
    static /* synthetic */ Class class$com$sshtools$j2ssh$authentication$AuthenticationProtocolClient;
    static /* synthetic */ Class class$com$sshtools$j2ssh$authentication$SshMsgUserAuthBanner;
    static /* synthetic */ Class class$com$sshtools$j2ssh$authentication$SshMsgUserAuthFailure;
    static /* synthetic */ Class class$com$sshtools$j2ssh$authentication$SshMsgUserAuthPwdChangeReq;
    static /* synthetic */ Class class$com$sshtools$j2ssh$authentication$SshMsgUserAuthSuccess;

    public AuthenticationProtocolClient() {
        super("ssh-userauth");
        this.resultFilter[0] = 52;
        this.resultFilter[1] = 51;
        this.singleIdFilter[0] = 52;
        this.singleIdFilter[1] = 51;
    }

    protected void onServiceAccept() throws IOException {
    }

    protected void onStart() {
    }

    protected void onServiceInit(int n) throws IOException {
        if (n == 2) {
            throw new ServiceOperationException("The Authentication Protocol client cannot be accepted");
        }
        this.messageStore.registerMessage(51, class$com$sshtools$j2ssh$authentication$SshMsgUserAuthFailure == null ? (class$com$sshtools$j2ssh$authentication$SshMsgUserAuthFailure = AuthenticationProtocolClient.class$("com.sshtools.j2ssh.authentication.SshMsgUserAuthFailure")) : class$com$sshtools$j2ssh$authentication$SshMsgUserAuthFailure);
        this.messageStore.registerMessage(52, class$com$sshtools$j2ssh$authentication$SshMsgUserAuthSuccess == null ? (class$com$sshtools$j2ssh$authentication$SshMsgUserAuthSuccess = AuthenticationProtocolClient.class$("com.sshtools.j2ssh.authentication.SshMsgUserAuthSuccess")) : class$com$sshtools$j2ssh$authentication$SshMsgUserAuthSuccess);
        this.messageStore.registerMessage(53, class$com$sshtools$j2ssh$authentication$SshMsgUserAuthBanner == null ? (class$com$sshtools$j2ssh$authentication$SshMsgUserAuthBanner = AuthenticationProtocolClient.class$("com.sshtools.j2ssh.authentication.SshMsgUserAuthBanner")) : class$com$sshtools$j2ssh$authentication$SshMsgUserAuthBanner);
        this.messageStore.registerMessage(60, class$com$sshtools$j2ssh$authentication$SshMsgUserAuthPwdChangeReq == null ? (class$com$sshtools$j2ssh$authentication$SshMsgUserAuthPwdChangeReq = AuthenticationProtocolClient.class$("com.sshtools.j2ssh.authentication.SshMsgUserAuthPwdChangeReq")) : class$com$sshtools$j2ssh$authentication$SshMsgUserAuthPwdChangeReq);
    }

    protected void onServiceRequest() throws IOException {
        throw new ServiceOperationException("This class implements the client protocol only!");
    }

    public List getAvailableAuths(String string, String string2) throws IOException {
        log.info((Object)"Requesting authentication methods");
        SshMessage sshMessage = new SshMsgUserAuthRequest(string, string2, "none", null);
        this.transport.sendMessage(sshMessage, this);
        sshMessage = this.messageStore.getMessage(this.resultFilter);
        if (sshMessage instanceof SshMsgUserAuthFailure) {
            return ((SshMsgUserAuthFailure)sshMessage).getAvailableAuthentications();
        }
        throw new ServiceOperationException("None request returned success! Insecure feature not supported");
    }

    public int authenticate(SshAuthenticationClient sshAuthenticationClient, Service service) throws IOException {
        try {
            Object object;
            if (!sshAuthenticationClient.canAuthenticate() && sshAuthenticationClient.canPrompt() && !(object = sshAuthenticationClient.getAuthenticationPrompt()).showPrompt()) {
                int n = 5;
                return n;
            }
            sshAuthenticationClient.authenticate(this, service.getServiceName());
            object = this.parseMessage(this.messageStore.getMessage(this.resultFilter));
            throw new AuthenticationProtocolException("Unexpected authentication message ".concat(String.valueOf(String.valueOf(((SshMessage)object).getMessageName()))));
        }
        catch (TerminatedStateException terminatedStateException) {
            if (terminatedStateException.getState() == 4) {
                service.init(2, this.transport);
                service.start();
            }
            int n = terminatedStateException.getState();
            return n;
        }
    }

    public void sendMessage(SshMessage sshMessage) throws IOException {
        this.transport.sendMessage(sshMessage, this);
    }

    public byte[] getSessionIdentifier() {
        return this.transport.getSessionIdentifier();
    }

    public void registerMessage(Class clazz, int n) {
        this.messageStore.registerMessage(n, clazz);
    }

    public SshMessage readMessage(int n) throws AuthenticationProtocolException, TerminatedStateException {
        this.singleIdFilter[2] = n;
        return this.internalReadMessage(this.singleIdFilter);
    }

    private SshMessage internalReadMessage(int[] nArray) throws AuthenticationProtocolException, TerminatedStateException {
        try {
            SshMessage sshMessage = this.messageStore.getMessage(nArray);
            SshMessage sshMessage2 = this.parseMessage(sshMessage);
            return sshMessage2;
        }
        catch (MessageStoreEOFException messageStoreEOFException) {
            throw new AuthenticationProtocolException("Failed to read messages");
        }
    }

    public SshMessage readMessage(int[] nArray) throws AuthenticationProtocolException, TerminatedStateException {
        int[] nArray2 = new int[nArray.length + this.resultFilter.length];
        System.arraycopy(this.resultFilter, 0, nArray2, 0, this.resultFilter.length);
        System.arraycopy(nArray, 0, nArray2, this.resultFilter.length, nArray.length);
        return this.internalReadMessage(nArray2);
    }

    private SshMessage parseMessage(SshMessage sshMessage) throws TerminatedStateException {
        if (sshMessage instanceof SshMsgUserAuthFailure) {
            if (((SshMsgUserAuthFailure)sshMessage).getPartialSuccess()) {
                throw new TerminatedStateException(3);
            }
            throw new TerminatedStateException(2);
        }
        if (sshMessage instanceof SshMsgUserAuthSuccess) {
            throw new TerminatedStateException(4);
        }
        return sshMessage;
    }

    public String getBannerMessage(int n) {
        try {
            log.debug((Object)"getBannerMessage is attempting to read the authentication banner");
            SshMessage sshMessage = this.messageStore.peekMessage(53, n);
            String string = ((SshMsgUserAuthBanner)sshMessage).getBanner();
            return string;
        }
        catch (MessageNotAvailableException messageNotAvailableException) {
            String string = "";
            return string;
        }
        catch (MessageStoreEOFException messageStoreEOFException) {
            log.error((Object)"Failed to retreive banner becasue the message store is EOF");
            String string = "";
            return string;
        }
    }

    static Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

