/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.j2ssh.authentication;

import com.sshtools.j2ssh.authentication.AuthenticationProtocolException;
import com.sshtools.j2ssh.authentication.PublicKeyVerification;
import com.sshtools.j2ssh.configuration.Authorization;
import com.sshtools.j2ssh.configuration.ConfigurationLoader;
import com.sshtools.j2ssh.configuration.ServerConfiguration;
import com.sshtools.j2ssh.io.ByteArrayWriter;
import com.sshtools.j2ssh.platform.NativeAuthenticationProvider;
import com.sshtools.j2ssh.transport.publickey.SshKeyPair;
import com.sshtools.j2ssh.transport.publickey.SshKeyPairFactory;
import com.sshtools.j2ssh.transport.publickey.SshPublicKey;
import com.sshtools.j2ssh.transport.publickey.SshPublicKeyFile;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Iterator;
import org.apache.log4j.Logger;

public class AuthorizationFileVerification
implements PublicKeyVerification {
    private static Logger log = Logger.getLogger((Class)(class$com$sshtools$j2ssh$authentication$AuthorizationFileVerification == null ? (class$com$sshtools$j2ssh$authentication$AuthorizationFileVerification = AuthorizationFileVerification.class$("com.sshtools.j2ssh.authentication.AuthorizationFileVerification")) : class$com$sshtools$j2ssh$authentication$AuthorizationFileVerification));
    static /* synthetic */ Class class$com$sshtools$j2ssh$authentication$AuthorizationFileVerification;

    public boolean verifyKeySignature(String string, String string2, byte[] byArray, String string3, byte[] byArray2, byte[] byArray3) throws IOException {
        Authorization authorization;
        String string4;
        File file;
        NativeAuthenticationProvider nativeAuthenticationProvider = NativeAuthenticationProvider.getInstance();
        String string5 = nativeAuthenticationProvider.getHomeDirectory(string);
        if (string5 == null) {
            log.warn((Object)String.valueOf(String.valueOf(new StringBuffer("There is no home directory for ").append(string).append(" is available"))));
        }
        string5 = string5.replace('\\', '/');
        ServerConfiguration serverConfiguration = ConfigurationLoader.getServerConfiguration();
        String string6 = serverConfiguration.getUserConfigDirectory();
        if ((string6 = string6.replace('\\', '/')).indexOf("%D") > -1 && string5 == null) {
            log.error((Object)"<UserConfigDirectory> requires home directory, but none available for ".concat(String.valueOf(String.valueOf(string))));
            return false;
        }
        string6 = string6.replaceAll("%D", string5);
        string6 = string6.replaceAll("%U", string);
        if (!(string6 = string6.replace('/', File.separatorChar).trim()).endsWith(File.separator)) {
            string6 = String.valueOf(String.valueOf(string6)).concat(String.valueOf(String.valueOf(File.separator)));
        }
        if (!(file = new File(string4 = String.valueOf(String.valueOf(string6)).concat(String.valueOf(String.valueOf(serverConfiguration.getAuthorizationFile()))))).exists()) {
            log.info((Object)String.valueOf(String.valueOf(new StringBuffer("authorizationFile: ").append(string4).append(" does not exist."))));
            log.info((Object)"Authentication failed because no authorization file is available");
            return false;
        }
        FileInputStream fileInputStream = new FileInputStream(file);
        try {
            authorization = new Authorization(fileInputStream);
        }
        catch (Exception exception) {
            throw new AuthenticationProtocolException("Failed to load authorized keys file ".concat(String.valueOf(String.valueOf(string4))));
        }
        Iterator iterator = authorization.getAuthorizedKeys().iterator();
        SshKeyPair sshKeyPair = SshKeyPairFactory.newInstance(string2);
        SshPublicKey sshPublicKey = null;
        SshPublicKey sshPublicKey2 = sshKeyPair.decodePublicKey(byArray);
        boolean bl = false;
        while (iterator.hasNext()) {
            String string7 = (String)iterator.next();
            file = new File(String.valueOf(String.valueOf(string6)).concat(String.valueOf(String.valueOf(string7))));
            if (!file.exists()) {
                file = new File(string7);
            }
            if (file.exists()) {
                SshPublicKeyFile sshPublicKeyFile = SshPublicKeyFile.parse(file);
                sshPublicKey = sshPublicKeyFile.toPublicKey();
                if (!sshPublicKey.getFingerprint().equals(sshPublicKey2.getFingerprint())) continue;
                ByteArrayWriter byteArrayWriter = new ByteArrayWriter();
                byteArrayWriter.writeBinaryString(byArray2);
                byteArrayWriter.write(50);
                byteArrayWriter.writeString(string);
                byteArrayWriter.writeString(string3);
                byteArrayWriter.writeString("publickey");
                byteArrayWriter.write(1);
                byteArrayWriter.writeString(sshPublicKey2.getAlgorithmName());
                byteArrayWriter.writeBinaryString(sshPublicKey2.getEncoded());
                if (!sshPublicKey2.verifySignature(byArray3, byteArrayWriter.toByteArray())) continue;
                return true;
            }
            log.info((Object)"Failed attempt to load key file ".concat(String.valueOf(String.valueOf(string7))));
        }
        return false;
    }

    static Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

