/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.j2ssh.authentication;

import com.sshtools.j2ssh.authentication.SshAuthenticationClient;
import com.sshtools.j2ssh.configuration.ConfigurationException;
import com.sshtools.j2ssh.configuration.ConfigurationLoader;
import com.sshtools.j2ssh.configuration.ExtensionAlgorithm;
import com.sshtools.j2ssh.configuration.SshAPIConfiguration;
import com.sshtools.j2ssh.transport.AlgorithmNotSupportedException;
import java.io.FilePermission;
import java.security.AccessControlException;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class SshAuthenticationClientFactory {
    private static Map auths;
    private static Logger log;
    public static final String AUTH_PASSWORD = "password";
    public static final String AUTH_PK = "publickey";
    public static final String AUTH_KBI = "keyboard-interactive";
    public static final String AUTH_HOSTBASED = "hostbased";
    static /* synthetic */ Class class$com$sshtools$j2ssh$authentication$KBIAuthenticationClient;
    static /* synthetic */ Class class$com$sshtools$j2ssh$authentication$PasswordAuthenticationClient;
    static /* synthetic */ Class class$com$sshtools$j2ssh$authentication$PublicKeyAuthenticationClient;
    static /* synthetic */ Class class$com$sshtools$j2ssh$authentication$SshAuthenticationClientFactory;

    protected SshAuthenticationClientFactory() {
    }

    public static void initialize() {
    }

    public static List getSupportedMethods() {
        ArrayList arrayList = new ArrayList(auths.keySet());
        return arrayList;
    }

    public static SshAuthenticationClient newInstance(String string) throws AlgorithmNotSupportedException {
        try {
            SshAuthenticationClient sshAuthenticationClient = (SshAuthenticationClient)((Class)auths.get(string)).newInstance();
            return sshAuthenticationClient;
        }
        catch (Exception exception) {
            throw new AlgorithmNotSupportedException(String.valueOf(String.valueOf(string)).concat(" is not supported!"));
        }
    }

    static Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        log = Logger.getLogger((Class)(class$com$sshtools$j2ssh$authentication$SshAuthenticationClientFactory == null ? (class$com$sshtools$j2ssh$authentication$SshAuthenticationClientFactory = SshAuthenticationClientFactory.class$("com.sshtools.j2ssh.authentication.SshAuthenticationClientFactory")) : class$com$sshtools$j2ssh$authentication$SshAuthenticationClientFactory));
        auths = new HashMap();
        log.info((Object)"Loading supported authentication methods");
        auths.put(AUTH_PASSWORD, class$com$sshtools$j2ssh$authentication$PasswordAuthenticationClient == null ? (class$com$sshtools$j2ssh$authentication$PasswordAuthenticationClient = SshAuthenticationClientFactory.class$("com.sshtools.j2ssh.authentication.PasswordAuthenticationClient")) : class$com$sshtools$j2ssh$authentication$PasswordAuthenticationClient);
        try {
            if (System.getSecurityManager() != null) {
                AccessController.checkPermission(new FilePermission("<<ALL FILES>>", "read"));
            }
            auths.put(AUTH_PK, class$com$sshtools$j2ssh$authentication$PublicKeyAuthenticationClient == null ? (class$com$sshtools$j2ssh$authentication$PublicKeyAuthenticationClient = SshAuthenticationClientFactory.class$("com.sshtools.j2ssh.authentication.PublicKeyAuthenticationClient")) : class$com$sshtools$j2ssh$authentication$PublicKeyAuthenticationClient);
        }
        catch (AccessControlException accessControlException) {
            log.info((Object)"The security manager prevents use of Public Key Authentication on the client");
        }
        auths.put(AUTH_KBI, class$com$sshtools$j2ssh$authentication$KBIAuthenticationClient == null ? (class$com$sshtools$j2ssh$authentication$KBIAuthenticationClient = SshAuthenticationClientFactory.class$("com.sshtools.j2ssh.authentication.KBIAuthenticationClient")) : class$com$sshtools$j2ssh$authentication$KBIAuthenticationClient);
        try {
            SshAPIConfiguration sshAPIConfiguration = ConfigurationLoader.getAPIConfiguration();
            if (sshAPIConfiguration != null) {
                List list = sshAPIConfiguration.getAuthenticationExtensions();
                Iterator iterator = list.iterator();
                while (iterator.hasNext()) {
                    ExtensionAlgorithm extensionAlgorithm = (ExtensionAlgorithm)iterator.next();
                    String string = extensionAlgorithm.getAlgorithmName();
                    if (auths.containsKey(string)) {
                        log.debug((Object)String.valueOf(String.valueOf(new StringBuffer("Standard authentication implementation for ").append(string).append(" is being overidden by ").append(extensionAlgorithm.getImplementationClass()))));
                    } else {
                        log.debug((Object)String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(string))).append(" authentication is implemented by ").append(extensionAlgorithm.getImplementationClass()))));
                    }
                    try {
                        Class clazz = ConfigurationLoader.getExtensionClass(extensionAlgorithm.getImplementationClass());
                        Object t = clazz.newInstance();
                        if (!(t instanceof SshAuthenticationClient)) continue;
                        auths.put(string, clazz);
                    }
                    catch (Exception exception) {
                        log.warn((Object)"Failed to load extension authentication implementation".concat(String.valueOf(String.valueOf(extensionAlgorithm.getImplementationClass()))), (Throwable)exception);
                    }
                }
            }
        }
        catch (ConfigurationException configurationException) {
            // empty catch block
        }
    }
}

