/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.j2ssh.configuration.automate;

import com.sshtools.j2ssh.configuration.automate.AuthorizedKeysFormat;
import com.sshtools.j2ssh.configuration.automate.RemoteIdentificationException;
import com.sshtools.j2ssh.configuration.automate.RemoteIdentificationRule;
import java.util.AbstractList;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;

public class RemoteIdentification {
    private String defaultName;
    private Vector rules = new Vector();
    private Class authorizedKeysFormat;
    private String defaultPath;

    public RemoteIdentification(String string) {
        this.defaultName = string;
    }

    protected List getRules() {
        return this.rules;
    }

    public String getDefaultName() {
        return this.defaultName;
    }

    public String getName(String string) throws RemoteIdentificationException {
        RemoteIdentificationRule remoteIdentificationRule;
        boolean bl = false;
        Iterator iterator = ((AbstractList)this.rules).iterator();
        Vector<RemoteIdentificationRule> vector = new Vector<RemoteIdentificationRule>();
        Object var6_5 = null;
        while (iterator.hasNext()) {
            remoteIdentificationRule = (RemoteIdentificationRule)iterator.next();
            if (!remoteIdentificationRule.testRule(string)) continue;
            vector.add(remoteIdentificationRule);
        }
        if (vector.size() > 0) {
            iterator = ((AbstractList)vector).iterator();
            RemoteIdentificationRule remoteIdentificationRule2 = null;
            while (iterator.hasNext()) {
                remoteIdentificationRule = (RemoteIdentificationRule)iterator.next();
                if (remoteIdentificationRule2 == null) {
                    remoteIdentificationRule2 = remoteIdentificationRule;
                    continue;
                }
                if (remoteIdentificationRule.getPriority() >= remoteIdentificationRule2.getPriority()) continue;
                remoteIdentificationRule2 = remoteIdentificationRule;
            }
            if (remoteIdentificationRule2.getName() != null) {
                return remoteIdentificationRule2.getName();
            }
            return this.defaultName;
        }
        throw new RemoteIdentificationException("No rules exist to identify the remote host with ident string ".concat(String.valueOf(String.valueOf(string))));
    }

    protected void addRule(RemoteIdentificationRule remoteIdentificationRule) {
        this.rules.add(remoteIdentificationRule);
    }

    protected boolean testRules(String string) {
        boolean bl = false;
        Iterator iterator = ((AbstractList)this.rules).iterator();
        while (iterator.hasNext() && !bl) {
            RemoteIdentificationRule remoteIdentificationRule = (RemoteIdentificationRule)iterator.next();
            bl = remoteIdentificationRule.testRule(string);
        }
        return bl;
    }

    protected void setAuthorizedKeysFormat(Class clazz) {
        this.authorizedKeysFormat = clazz;
    }

    protected void setAuthorizedKeysDefaultPath(String string) {
        this.defaultPath = string;
    }

    public String getAuthorizedKeysDefaultPath() {
        return this.defaultPath;
    }

    public AuthorizedKeysFormat getAuthorizedKeysFormat() throws RemoteIdentificationException {
        try {
            if (this.authorizedKeysFormat != null) {
                AuthorizedKeysFormat authorizedKeysFormat = (AuthorizedKeysFormat)this.authorizedKeysFormat.newInstance();
                return authorizedKeysFormat;
            }
            throw new RemoteIdentificationException("There is no authorized keys format set for this remote id");
        }
        catch (Exception exception) {
            throw new RemoteIdentificationException("Failed to instansiate ".concat(String.valueOf(String.valueOf(this.authorizedKeysFormat.getName()))));
        }
    }
}

