/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.j2ssh.configuration.automate;

import com.sshtools.j2ssh.configuration.automate.AuthorizedKeys;
import com.sshtools.j2ssh.configuration.automate.AuthorizedKeysFileLoader;
import com.sshtools.j2ssh.configuration.automate.AuthorizedKeysFileSaver;
import com.sshtools.j2ssh.configuration.automate.AuthorizedKeysFormat;
import com.sshtools.j2ssh.transport.publickey.InvalidSshKeyException;
import com.sshtools.j2ssh.transport.publickey.SECSHPublicKeyFormat;
import com.sshtools.j2ssh.transport.publickey.SshPublicKey;
import com.sshtools.j2ssh.transport.publickey.SshPublicKeyFile;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Iterator;
import java.util.Map;

public class SSH2AuthorizedKeysFormat
implements AuthorizedKeysFormat {
    private static final String header = "# Open3SP auto-generated authorization file\n";
    private static final String key = "key ";

    public byte[] format(AuthorizedKeys authorizedKeys) throws InvalidSshKeyException, IOException {
        throw new UnsupportedOperationException("SSH2 authorized keys format requries seperate key files!");
    }

    public AuthorizedKeys unformat(byte[] byArray) throws InvalidSshKeyException, IOException {
        throw new UnsupportedOperationException("SSH2 authorized keys format requries seperate key files!");
    }

    public byte[] format(AuthorizedKeys authorizedKeys, AuthorizedKeysFileSaver authorizedKeysFileSaver) throws InvalidSshKeyException, IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byteArrayOutputStream.write(header.getBytes());
        SECSHPublicKeyFormat sECSHPublicKeyFormat = new SECSHPublicKeyFormat();
        Iterator iterator = authorizedKeys.getAuthorizedKeys().entrySet().iterator();
        while (iterator != null && iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            String string = (String)entry.getKey();
            String string2 = String.valueOf(String.valueOf(string)).concat(".pub");
            sECSHPublicKeyFormat.setComment(string);
            SshPublicKeyFile sshPublicKeyFile = SshPublicKeyFile.create((SshPublicKey)entry.getValue(), sECSHPublicKeyFormat);
            authorizedKeysFileSaver.saveFile(string2, sshPublicKeyFile.toString().getBytes());
            byteArrayOutputStream.write(key.getBytes());
            byteArrayOutputStream.write(string2.getBytes());
            byteArrayOutputStream.write(10);
        }
        return byteArrayOutputStream.toByteArray();
    }

    public AuthorizedKeys unformat(byte[] byArray, AuthorizedKeysFileLoader authorizedKeysFileLoader) throws InvalidSshKeyException, IOException {
        String string;
        AuthorizedKeys authorizedKeys = new AuthorizedKeys();
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(new ByteArrayInputStream(byArray)));
        while ((string = bufferedReader.readLine()) != null) {
            if (!string.trim().startsWith("key")) continue;
            String string2 = string.substring(string.trim().lastIndexOf(" ") + 1).trim();
            SshPublicKeyFile sshPublicKeyFile = SshPublicKeyFile.parse(authorizedKeysFileLoader.loadFile(string2));
            String string3 = string2.substring(0, string2.length() - 4);
            authorizedKeys.addKey(string3, sshPublicKeyFile.toPublicKey());
        }
        return authorizedKeys;
    }

    public boolean requiresKeyFiles() {
        return true;
    }
}

