/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.j2ssh.forwarding;

import com.sshtools.j2ssh.connection.Channel;
import com.sshtools.j2ssh.connection.InvalidChannelException;
import com.sshtools.j2ssh.forwarding.ForwardingConfiguration;
import com.sshtools.j2ssh.forwarding.ForwardingConfigurationException;
import com.sshtools.j2ssh.io.ByteArrayWriter;
import com.sshtools.j2ssh.transport.ServiceOperationException;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import org.apache.log4j.Logger;

public class ForwardingChannel
extends Channel {
    public static final String X11_FORWARDING_CHANNEL = "x11";
    public static final String LOCAL_FORWARDING_CHANNEL = "direct-tcpip";
    public static final String REMOTE_FORWARDING_CHANNEL = "forwarded-tcpip";
    private static Logger log = Logger.getLogger((Class)(class$com$sshtools$j2ssh$forwarding$ForwardingChannel == null ? (class$com$sshtools$j2ssh$forwarding$ForwardingChannel = ForwardingChannel.class$("com.sshtools.j2ssh.forwarding.ForwardingChannel")) : class$com$sshtools$j2ssh$forwarding$ForwardingChannel));
    private ForwardingConfiguration config;
    private String forwardType;
    private String originatingHost;
    private int originatingPort;
    private Socket socket;
    static /* synthetic */ Class class$com$sshtools$j2ssh$forwarding$ForwardingChannel;

    public ForwardingChannel(String string, ForwardingConfiguration forwardingConfiguration, String string2, int n) throws ForwardingConfigurationException {
        if (!(string.equals(LOCAL_FORWARDING_CHANNEL) || string.equals(REMOTE_FORWARDING_CHANNEL) || string.equals(X11_FORWARDING_CHANNEL))) {
            throw new ForwardingConfigurationException("The forwarding type is invalid");
        }
        this.config = forwardingConfiguration;
        this.forwardType = string;
        this.originatingHost = string2;
        this.originatingPort = n;
    }

    public byte[] getChannelOpenData() {
        try {
            ByteArrayWriter byteArrayWriter = new ByteArrayWriter();
            if (this.forwardType.equals(LOCAL_FORWARDING_CHANNEL)) {
                byteArrayWriter.writeString(this.config.getHostToConnect());
                byteArrayWriter.writeInt(this.config.getPortToConnect());
            } else {
                byteArrayWriter.writeString(this.config.getAddressToBind());
                byteArrayWriter.writeInt(this.config.getPortToBind());
            }
            byteArrayWriter.writeString(this.originatingHost);
            byteArrayWriter.writeInt(this.originatingPort);
            byte[] byArray = byteArrayWriter.toByteArray();
            return byArray;
        }
        catch (IOException iOException) {
            byte[] byArray = null;
            return byArray;
        }
    }

    public byte[] getChannelConfirmationData() {
        return null;
    }

    public String getChannelType() {
        return this.forwardType;
    }

    protected int getMinimumWindowSpace() {
        return 32768;
    }

    protected int getMaximumWindowSpace() {
        return 131072;
    }

    protected int getMaximumPacketSize() {
        return 32768;
    }

    public ForwardingConfiguration getForwardingConfiguration() {
        return this.config;
    }

    public InetSocketAddress getRemoteSocketAddress() {
        if (this.socket != null) {
            return (InetSocketAddress)this.socket.getRemoteSocketAddress();
        }
        return new InetSocketAddress(this.originatingHost, this.originatingPort);
    }

    public InetAddress getLocalAddress() {
        try {
            if (this.socket != null) {
                InetAddress inetAddress = this.socket.getInetAddress();
                return inetAddress;
            }
            InetAddress inetAddress = InetAddress.getLocalHost();
            return inetAddress;
        }
        catch (UnknownHostException unknownHostException) {
            InetAddress inetAddress = null;
            return inetAddress;
        }
    }

    public void bindSocket(Socket socket) throws IOException {
        this.socket = socket;
        if (this.state.getValue() == 2) {
            this.bindInputStream(socket.getInputStream());
            this.bindOutputStream(socket.getOutputStream());
        }
    }

    protected void onChannelClose() throws ServiceOperationException {
    }

    protected void onChannelOpen() throws InvalidChannelException {
        try {
            if (this.socket != null) {
                this.bindInputStream(this.socket.getInputStream());
                this.bindOutputStream(this.socket.getOutputStream());
            }
        }
        catch (IOException iOException) {
            throw new InvalidChannelException("Failed to bind the channel to the forwarded socket: ".concat(String.valueOf(String.valueOf(iOException.getMessage()))));
        }
    }

    protected void onChannelRequest(String string, boolean bl, byte[] byArray) throws IOException {
        this.connection.sendChannelRequestFailure(this);
    }

    static Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

